/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellShell;
import dmg.cells.nucleus.LogbackShell;
import dmg.cells.nucleus.Reply;
import dmg.util.AuthorizedString;
import dmg.util.DomainInterruptHandler;
import dmg.util.Gate;
import dmg.util.logback.FilterShell;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.dcache.util.Args;
import org.dcache.util.cli.CommandInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemCell
extends CellAdapter
implements Runnable,
Thread.UncaughtExceptionHandler {
    private static final Logger _log = LoggerFactory.getLogger(SystemCell.class);
    private byte[] _oomSafetyBuffer = new byte[0x200000];
    private final CellShell _cellShell;
    private final CellNucleus _nucleus;
    private int _packetsReceived;
    private int _packetsAnswered;
    private int _packetsForwarded;
    private int _packetsReplied;
    private int _exceptionCounter;
    private DomainInterruptHandler _interruptHandler;
    private Thread _interruptThread;
    private long _interruptTimer = 2000L;
    private final Runtime _runtime = Runtime.getRuntime();
    private final Gate _shutdownLock = new Gate(false);
    public static final String hh_get_hostname = "# returns the hostname of the computer this domain is running at";

    public SystemCell(String cellDomainName) {
        super(cellDomainName);
        this._nucleus = this.getNucleus();
        this._cellShell = new CellShell(this.getNucleus());
        this._cellShell.addCommandListener(this);
        this._cellShell.addCommandListener(new LogbackShell());
        this._cellShell.addCommandListener(new FilterShell(this._nucleus.getLoggingThresholds()));
        this._cellShell.addCommandListener(new CommandInterpreter.HelpCommands((CommandInterpreter)this._cellShell));
        this.useInterpreter(false);
        this._runtime.addShutdownHook(new TheKiller());
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public String toString() {
        long fm = this._runtime.freeMemory();
        long tm = this._runtime.totalMemory();
        return this.getCellDomainName() + ":IOrec=" + this._packetsReceived + ";IOexc=" + this._exceptionCounter + ";MEM=" + (tm - fm);
    }

    public int enableInterrupts(String handlerName) {
        Class<DomainInterruptHandler> handlerClass;
        try {
            handlerClass = Class.forName(handlerName).asSubclass(DomainInterruptHandler.class);
        }
        catch (ClassNotFoundException cnfe) {
            _log.warn("Couldn't install interrupt handler (" + handlerName + ") : " + cnfe);
            return -1;
        }
        try {
            this._interruptHandler = handlerClass.newInstance();
        }
        catch (Exception ee) {
            _log.warn("Couldn't install interrupt handler (" + handlerName + ") : " + ee);
            return -2;
        }
        this._interruptThread = this._nucleus.newThread(this);
        this._interruptThread.start();
        return 0;
    }

    public String ac_get_hostname_$_0(Args args) {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            return "localhost";
        }
    }

    @Override
    public void run() {
        try {
            do {
                Thread.sleep(this._interruptTimer);
            } while (!this._interruptHandler.interruptPending());
        }
        catch (InterruptedException ie) {
            _log.info("Interrupt loop was interrupted");
        }
        _log.info("Interrupt loop stopped (shutting down system now)");
        this.kill();
    }

    private void shutdownSystem() {
        List<String> names = this._nucleus.getCellNames();
        ArrayList<String> nonSystem = new ArrayList<String>(names.size());
        ArrayList<String> system = new ArrayList<String>(names.size());
        for (String name : names) {
            String cellName;
            CellInfo info = this._nucleus.getCellInfo(name);
            if (info == null || (cellName = info.getCellName()).equals("System")) continue;
            if (info.getCellType().equals("System")) {
                system.add(cellName);
                continue;
            }
            nonSystem.add(cellName);
        }
        _log.info("Will try to shutdown non-system cells {}", nonSystem);
        this.shutdownCells(nonSystem, 3000L);
        _log.info("Will try to shutdown remaining cells {}", system);
        this.shutdownCells(system, 5000L);
    }

    private void shutdownCells(List<String> cells, long timeout) {
        for (String cellName : cells) {
            try {
                this._nucleus.kill(cellName);
            }
            catch (IllegalArgumentException e) {
                _log.info("Problem killing : {} -> {}", (Object)cellName, (Object)e.getMessage());
            }
        }
        for (String cellName : cells) {
            try {
                if (this._nucleus.join(cellName, timeout)) {
                    _log.info("Killed {}", (Object)cellName);
                    continue;
                }
                _log.warn("Timeout waiting for {}", (Object)cellName);
                this._nucleus.listThreadGroupOf(cellName);
            }
            catch (InterruptedException e) {
                _log.warn("Problem killing : {} -> {}", (Object)cellName, (Object)e.getMessage());
            }
            break;
        }
    }

    @Override
    public void cleanUp() {
        this.shutdownSystem();
        _log.info("Opening shutdown lock");
        this._shutdownLock.open();
        System.exit(0);
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.append(" CellDomainName   = ").println(this.getCellDomainName());
        pw.format(" I/O rcv=%d;asw=%d;frw=%d;rpy=%d;exc=%d\n", this._packetsReceived, this._packetsAnswered, this._packetsForwarded, this._packetsReplied, this._exceptionCounter);
        long fm = this._runtime.freeMemory();
        long tm = this._runtime.totalMemory();
        pw.format(" Memory : tot=%d;free=%d;used=%d\n", tm, fm, tm - fm);
        pw.println(" Cells (Threads)");
        for (String name : this._nucleus.getCellNames()) {
            pw.append(" ").append(name).append("(");
            Thread[] threads = this._nucleus.getThreads(name);
            if (threads != null) {
                boolean first = true;
                for (Thread thread : threads) {
                    pw.print(thread.getName());
                    if (first) {
                        first = false;
                        continue;
                    }
                    pw.print(",");
                }
            }
            pw.println(")");
        }
    }

    @Override
    public void messageToForward(CellMessage msg) {
        msg.nextDestination();
        try {
            this.sendMessage(msg);
            ++this._packetsForwarded;
        }
        catch (Exception eee) {
            ++this._exceptionCounter;
        }
    }

    @Override
    public void messageArrived(CellMessage msg) {
        _log.info("Message arrived : " + msg);
        ++this._packetsReceived;
        if (msg.isReply()) {
            _log.warn("Seems to a bounce : " + msg);
            return;
        }
        Serializable obj = msg.getMessageObject();
        Object reply = null;
        boolean processed = false;
        if (obj instanceof String) {
            String command = (String)((Object)obj);
            if (command.isEmpty()) {
                return;
            }
            _log.info("Command: {}", (Object)command);
            reply = command.equals("xyzzy") ? "Nothing happens." : this._cellShell.objectCommand2(command);
            processed = true;
        } else if (obj instanceof AuthorizedString) {
            AuthorizedString as = (AuthorizedString)obj;
            String command = as.toString();
            if (command.length() < 1) {
                return;
            }
            _log.info("Command(p=" + as.getAuthorizedPrincipal() + ") : " + command);
            reply = this._cellShell.objectCommand2(command);
            processed = true;
        }
        if (processed) {
            _log.debug("Reply : {}", reply);
            ++this._packetsAnswered;
        }
        msg.revertDirection();
        try {
            if (processed && reply instanceof Reply) {
                ((Reply)reply).deliver(this, msg);
            } else {
                if (processed) {
                    msg.setMessageObject((Serializable)reply);
                }
                this.sendMessage(msg);
                _log.debug("Sending : {}", (Object)msg);
            }
            ++this._packetsReplied;
        }
        catch (Exception e) {
            ++this._exceptionCounter;
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof VirtualMachineError) {
            this._oomSafetyBuffer = null;
            _log.error("Fatal JVM error", e);
            _log.error("Shutting down...");
            this.kill();
        }
        _log.error("Uncaught exception in thread " + t.getName(), e);
    }

    private class TheKiller
    extends Thread {
        private TheKiller() {
        }

        @Override
        public void run() {
            _log.info("Running shutdown sequence");
            SystemCell.this.kill();
            _log.info("Kill done, waiting for shutdown lock");
            SystemCell.this._shutdownLock.check();
            _log.info("Killer done");
        }
    }
}

