/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProviderCell
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(DataProviderCell.class);
    private CellNucleus _nucleus;
    private Args _args;
    private File _dir;
    private Hashtable<String, byte[]> _classHash = new Hashtable();
    private int _requestCounter;
    private int _errorCounter;

    public DataProviderCell(String cellName, String args) {
        super(cellName, args, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        try {
            if (this._args.argc() < 1) {
                throw new IllegalArgumentException("USAGE : ... <storeBase>");
            }
            this._dir = new File(this._args.argv(0));
            if (!this._dir.isDirectory()) {
                throw new IllegalArgumentException("Not a directory : " + this._dir);
            }
        }
        catch (Exception e) {
            this.start();
            this.kill();
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            throw new IllegalArgumentException(e.toString());
        }
        this.useInterpreter(false);
        this.start();
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println(" Directory   : " + this._dir);
        pw.println(" Requests    : " + this._requestCounter);
        pw.println(" Errors      : " + this._errorCounter);
        Iterator<String> i$ = this._classHash.keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String className = o = i$.next();
            byte[] data = this._classHash.get(className);
            pw.println("   " + className + "=" + data.length);
        }
    }

    @Override
    public String toString() {
        return this._dir.toString();
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Serializable req = msg.getMessageObject();
        if (!(req instanceof String)) {
            return;
        }
        Args args = new Args((CharSequence)((String)((Object)req)));
        if (args.argc() < 2) {
            return;
        }
        String command = args.argv(0);
        if (command.equals("getclass")) {
            args.shift();
            this.do_getclass_command(msg, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_getclass_command(CellMessage msg, Args args) {
        String fileName = args.argv(0);
        _log.info("Request for class : " + fileName);
        File file = new File(this._dir, fileName + ".class");
        if (!file.canRead() && !(file = new File(this._dir, (fileName = fileName.replace('.', '/')) + ".class")).canRead()) {
            this.reply(msg, (Serializable)((Object)"Class not found"));
            _log.info("File not found : " + fileName);
            ++this._errorCounter;
            return;
        }
        int len = (int)file.length();
        if (len == 0) {
            _log.info("File has zero length");
            this.reply(msg, (Serializable)((Object)"Zero size entry found"));
            ++this._errorCounter;
            return;
        }
        byte[] data = new byte[len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            in.read(data);
            ++this._requestCounter;
            this._classHash.put(fileName, data);
            this.reply(msg, (Serializable)data);
        }
        catch (IOException ee) {
            ++this._errorCounter;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    private void reply(CellMessage msg, Serializable o) {
        try {
            _log.info("returning message" + o.toString());
            msg.setMessageObject(o);
            msg.revertDirection();
            this.sendMessage(msg);
        }
        catch (NoRouteToCellException noRouteToCellException) {
            // empty catch block
        }
    }
}

