/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.applets.login.DomainConnectionListener;
import dmg.cells.applets.login.DomainEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class JCommander
extends JPanel
implements DomainConnectionListener,
DomainEventListener {
    private static final long serialVersionUID = -8239106425185640530L;
    private DomainConnection _connection;
    private Font _bigFont = new Font("Times", 1, 26);
    private JTextField _commandField = new JTextField();
    private JTextArea _displayArea = new JTextArea();
    private JScrollPane _scrollPane;
    private JButton _clearButton = new JButton("Clear");
    private JTextField _destination = new JTextField();

    private JPanel createSouth() {
        GridBagLayout lo = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel(lo);
        c.gridheight = 1;
        c.insets = new Insets(4, 4, 4, 4);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)this._clearButton, c);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 0;
        panel.add((Component)new JLabel("Destination"), c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        panel.add((Component)this._destination, c);
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)this._commandField, c);
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)panel, "Center");
        return jp;
    }

    public JCommander(DomainConnection connection) {
        this._connection = connection;
        BorderLayout l = new BorderLayout();
        l.setVgap(10);
        l.setHgap(10);
        this.setLayout(l);
        this._connection.addDomainEventListener(this);
        JLabel label = new JLabel("Commander", 0);
        label.setFont(this._bigFont);
        this.add((Component)label, "North");
        this._displayArea.setEditable(false);
        this._scrollPane = new JScrollPane(this._displayArea);
        this.add((Component)this._scrollPane, "Center");
        this.add((Component)this.createSouth(), "South");
        this._clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JCommander.this._displayArea.setText("");
            }
        });
        this._commandField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String text = JCommander.this._commandField.getText();
                JCommander.this._commandField.setText("");
                try {
                    String destination = JCommander.this._destination.getText();
                    if (destination.equals("")) {
                        JCommander.this._connection.sendObject((Serializable)((Object)text), new OurListener(), 4);
                    } else {
                        System.out.println("Sending to " + destination);
                        JCommander.this._connection.sendObject(destination, (Serializable)((Object)text), new OurListener(), 4);
                    }
                }
                catch (Exception ee) {
                    System.err.println("Error in sending : " + ee);
                }
            }
        });
    }

    private void append(String text) {
        this._displayArea.append(text);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle rect = JCommander.this._displayArea.getBounds();
                rect.y = rect.height - 30;
                JCommander.this._scrollPane.getViewport().scrollRectToVisible(rect);
            }
        });
    }

    @Override
    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    @Override
    public void connectionOpened(DomainConnection connection) {
        System.out.println("Connection opened");
    }

    @Override
    public void connectionClosed(DomainConnection connection) {
        System.out.println("Connection closed");
    }

    @Override
    public void connectionOutOfBand(DomainConnection connection, Object obj) {
        System.out.println("Connection connectionOutOfBand " + obj);
    }

    @Override
    public void domainAnswerArrived(Object obj, int subid) {
        System.out.println("Answer (" + subid + ") : " + obj.toString());
    }

    private class OurListener
    implements DomainConnectionListener {
        private OurListener() {
        }

        @Override
        public void domainAnswerArrived(Object obj, int subid) {
            JCommander.this.append(obj.toString() + "\n");
        }
    }
}

