/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class MovingPigs
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 5282546475861165173L;
    private HashMap<String, Item> _list = new HashMap();
    private Item _cursor;
    private Point _offset = new Point();
    private String _currentFontType = "Times";
    private int _currentFontMode = 3;
    private int _currentFontSize = 16;
    private Font _font = new Font("Times", 3, 16);
    private boolean _mode = true;
    private JPopupMenu _popup;
    private JMenu _edit;
    private Color _backgroundColor = Color.white;
    private Color _itemColor = blue;
    private Color _textColor = white;
    private Color _linkColor = red;
    private JPopupMenu _itemPopup;
    private Dimension _dimension;
    private Rectangle _shutdown;
    private Random _random = new Random(new Date().getTime());
    private static Color black = new Color(20, 20, 20);
    private static Color white = new Color(240, 240, 255);
    private static Color red = new Color(149, 43, 42);
    private static Color blue = new Color(94, 105, 176);
    private static Color yellow = new Color(255, 255, 140);

    private void createPopup() {
        this._popup = new JPopupMenu("Edit");
        this._edit = new JMenu("Edit");
        this._popup.setBorderPainted(true);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String string = JOptionPane.showInputDialog(MovingPigs.this, (Object)"Name of new Domain");
                if (string != null) {
                    MovingPigs.this.addItem(string);
                }
            }
        };
        JMenuItem mi = this._popup.add(new JMenuItem("New Domain"));
        mi.addActionListener(al);
        mi = this._edit.add(new JMenuItem("New Domain"));
        mi.addActionListener(al);
        mi.setAccelerator(KeyStroke.getKeyStroke(68, 2, false));
        this._edit.addSeparator();
        this._popup.addSeparator();
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovingPigs.this._backgroundColor = JColorChooser.showDialog(MovingPigs.this, "Choose the bg color", Color.red);
                if (MovingPigs.this._backgroundColor != null) {
                    MovingPigs.this.setBackground(MovingPigs.this._backgroundColor);
                    MovingPigs.this.repaint();
                }
            }
        };
        mi = this._popup.add(new JMenuItem("Background Color"));
        mi.addActionListener(al);
        mi = this._edit.add(new JMenuItem("Background Color"));
        mi.addActionListener(al);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(MovingPigs.this, "Choose the item color", Color.red);
                if (color != null) {
                    MovingPigs.this._itemColor = color;
                    MovingPigs.this.repaint();
                }
            }
        };
        mi = this._popup.add(new JMenuItem("Item Color"));
        mi.addActionListener(al);
        mi = this._edit.add(new JMenuItem("Item Color"));
        mi.addActionListener(al);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovingPigs.this._textColor = JColorChooser.showDialog(MovingPigs.this, "Choose the text color", Color.red);
                if (MovingPigs.this._textColor != null) {
                    MovingPigs.this.repaint();
                }
            }
        };
        mi = this._popup.add(new JMenuItem("Text Color"));
        mi.addActionListener(al);
        mi = this._edit.add(new JMenuItem("Text Color"));
        mi.addActionListener(al);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovingPigs.this._linkColor = JColorChooser.showDialog(MovingPigs.this, "Choose the link color", Color.red);
                if (MovingPigs.this._linkColor != null) {
                    MovingPigs.this.repaint();
                }
            }
        };
        mi = this._popup.add(new JMenuItem("Link Color"));
        mi.addActionListener(al);
        mi = this._edit.add(new JMenuItem("Link Color"));
        mi.addActionListener(al);
        this._edit.addSeparator();
        this._popup.addSeparator();
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String ac = event.getActionCommand();
                MovingPigs.this._currentFontType = ac;
                MovingPigs.this._font = new Font(MovingPigs.this._currentFontType, MovingPigs.this._currentFontMode, MovingPigs.this._currentFontSize);
                MovingPigs.this.repaint();
            }
        };
        String[] fontTypes = new String[]{"Times", "Courier", "LucidaBright"};
        JMenu submenu = new JMenu("Font Type");
        for (String fontType : fontTypes) {
            mi = submenu.add(new JMenuItem(fontType));
            mi.addActionListener(al);
            submenu.add(mi);
        }
        this._edit.add(submenu);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String ac = event.getActionCommand();
                try {
                    MovingPigs.this._currentFontSize = Integer.parseInt(ac);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                MovingPigs.this._font = new Font(MovingPigs.this._currentFontType, MovingPigs.this._currentFontMode, MovingPigs.this._currentFontSize);
                MovingPigs.this.repaint();
            }
        };
        String[] fontSizes = new String[]{"8", "10", "12", "14", "16"};
        submenu = new JMenu("Font Size");
        for (String fontSize : fontSizes) {
            mi = submenu.add(new JMenuItem(fontSize));
            mi.addActionListener(al);
            submenu.add(mi);
        }
        this._edit.add(submenu);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String ac;
                switch (ac = event.getActionCommand()) {
                    case "Plain": {
                        MovingPigs.this._currentFontMode = 0;
                        break;
                    }
                    case "Italic": {
                        MovingPigs.this._currentFontMode = 2;
                        break;
                    }
                    case "Bold": {
                        MovingPigs.this._currentFontMode = 1;
                        break;
                    }
                    case "BoldItalic": {
                        MovingPigs.this._currentFontMode = 3;
                    }
                }
                MovingPigs.this._font = new Font(MovingPigs.this._currentFontType, MovingPigs.this._currentFontMode, MovingPigs.this._currentFontSize);
                MovingPigs.this.repaint();
            }
        };
        String[] fontModes = new String[]{"Plain", "Italic", "Bold", "BoldItalic"};
        submenu = new JMenu("Font Mode");
        for (String fontMode : fontModes) {
            mi = submenu.add(new JMenuItem(fontMode));
            mi.addActionListener(al);
            submenu.add(mi);
        }
        this._edit.add(submenu);
        this._edit.addSeparator();
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Iterator<Item> i = MovingPigs.this.items();
                while (i.hasNext()) {
                    Item item = i.next();
                    MovingPigs.this.moveToRevert(item);
                }
            }
        };
        mi = this._edit.add(new JMenuItem("Revert Position"));
        mi.addActionListener(al);
        mi.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MovingPigs.this.shutdown();
            }
        };
        mi = this._edit.add(new JMenuItem("Shutdown"));
        mi.addActionListener(al);
        mi.setAccelerator(KeyStroke.getKeyStroke(90, 2, false));
    }

    public void shutdown() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MovingPigs.this._shutdown = new Rectangle();
                try {
                    for (double gamma = 0.0; gamma < 1.0; gamma += 0.06) {
                        ((MovingPigs)MovingPigs.this)._shutdown.x = ((MovingPigs)MovingPigs.this)._dimension.width / 2 - (int)(gamma * (double)(((MovingPigs)MovingPigs.this)._dimension.width / 2));
                        ((MovingPigs)MovingPigs.this)._shutdown.y = ((MovingPigs)MovingPigs.this)._dimension.height / 2 - (int)(gamma * (double)(((MovingPigs)MovingPigs.this)._dimension.height / 2));
                        ((MovingPigs)MovingPigs.this)._shutdown.width = (int)(gamma * (double)((MovingPigs)MovingPigs.this)._dimension.width);
                        ((MovingPigs)MovingPigs.this)._shutdown.height = (int)(gamma * (double)((MovingPigs)MovingPigs.this)._dimension.height);
                        Thread.sleep(100L);
                        MovingPigs.this.repaint();
                    }
                    ((MovingPigs)MovingPigs.this)._shutdown.x = 0;
                    ((MovingPigs)MovingPigs.this)._shutdown.y = 0;
                    ((MovingPigs)MovingPigs.this)._shutdown.width = ((MovingPigs)MovingPigs.this)._dimension.width;
                    ((MovingPigs)MovingPigs.this)._shutdown.height = ((MovingPigs)MovingPigs.this)._dimension.height;
                    MovingPigs.this.repaint();
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
        }).start();
    }

    public JComponent getEditMenu() {
        return this._edit;
    }

    private JPopupMenu createPrivateMenu(final Item item) {
        Item linkItem;
        JPopupMenu popup = new JPopupMenu(item.getName());
        Iterator<Item> i = this.items();
        int counter = 0;
        while (i.hasNext()) {
            Item toLink = i.next();
            if (!toLink.hasLink(item)) continue;
            ++counter;
        }
        JMenuItem mi = new JMenuItem(item.isListener() ? "Don't Listen" : "Listen");
        mi.setEnabled(counter == 0);
        popup.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                item.setListener(!item.isListener());
                MovingPigs.this.repaint();
            }
        });
        popup.addSeparator();
        JMenu submenu = new JMenu("Add Link To");
        i = this.items();
        while (i.hasNext()) {
            linkItem = i.next();
            if (linkItem.getName().equals(item.getName())) continue;
            submenu.add(new CreateLinkMenuItem(item, linkItem, true));
        }
        popup.add(submenu);
        submenu = new JMenu("Remove Link");
        i = item.links();
        while (i.hasNext()) {
            linkItem = i.next();
            submenu.add(new CreateLinkMenuItem(item, linkItem, false));
        }
        popup.add(submenu);
        popup.addSeparator();
        popup.add(new DeleteMenuItem(item));
        popup.addSeparator();
        popup.add(new SetColorMenuItem(item));
        return popup;
    }

    private JPopupMenu createPrivateLineMenu(final Item from, final Item to) {
        JPopupMenu popup = new JPopupMenu(from.getName());
        JMenuItem mi = popup.add(new JMenuItem("Remove This Link"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                from.removeLink(to.getName());
                to.removeLink(from.getName());
                MovingPigs.this.repaint();
            }
        });
        popup.addSeparator();
        mi = popup.add(new JMenuItem("Set Default Route"));
        mi.setEnabled(from.getDefaultRoute() != to);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                from.setDefaultRoute(to);
                MovingPigs.this.repaint();
            }
        });
        mi = popup.add(new JMenuItem("Remove Default Route"));
        mi.setEnabled(from.getDefaultRoute() == to);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                from.setDefaultRoute(null);
                MovingPigs.this.repaint();
            }
        });
        return popup;
    }

    public MovingPigs() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
        this.createPopup();
    }

    public Item getItem(String name) {
        return this.getItem(name, false);
    }

    public Item getItem(String name, boolean create) {
        Item item = this._list.get(name);
        if (item == null) {
            if (!create) {
                return null;
            }
            item = new Item(name, this._itemColor);
            this._list.put(name, item);
        }
        this.repaint();
        return item;
    }

    public Iterator<Item> items() {
        return this._list.values().iterator();
    }

    public synchronized void addItem(String name) {
        if (this._list.get(name) == null) {
            this.getItem(name, true);
        }
    }

    public synchronized void remove(String name) {
        Iterator<Item> i = this.items();
        while (i.hasNext()) {
            i.next().removeLink(name);
        }
        this._list.remove(name);
        this.repaint();
    }

    public void clear() {
        this._list.clear();
        this.repaint();
    }

    public void connect(String from, String to) {
        Item x = this.getItem(from);
        Item y = this.getItem(to);
        if (x == null || y == null) {
            return;
        }
        x.addLink(y);
        this.repaint();
    }

    private Polygon getTriangle(Point from, Point to) {
        double nu = 20.0;
        double mu = 10.0;
        Polygon triangle = new Polygon();
        Point N = new Point(to.x - from.x, to.y - from.y);
        double NN = (double)N.x * (double)N.x + (double)N.y * (double)N.y;
        NN = Math.sqrt(NN);
        Point M = new Point(N.y, -N.x);
        double MM = (double)M.x * (double)M.x + (double)M.y * (double)M.y;
        double tmp = 0.5 + nu / NN;
        triangle.addPoint((int)(tmp * (double)N.x) + from.x, (int)(tmp * (double)N.y) + from.y);
        tmp = 0.5 - nu / NN;
        MM = Math.sqrt(MM);
        triangle.addPoint((int)(tmp * (double)N.x + mu * (double)M.x / MM) + from.x, (int)(tmp * (double)N.y + mu * (double)M.y / MM) + from.y);
        triangle.addPoint((int)(0.5 * (double)N.x) + from.x, (int)(0.5 * (double)N.y) + from.y);
        triangle.addPoint((int)(tmp * (double)N.x - mu * (double)M.x / MM) + from.x, (int)(tmp * (double)N.y - mu * (double)M.y / MM) + from.y);
        return triangle;
    }

    private Point getDistance(Point from, Point to, Point p) {
        Point N = new Point(to.x - from.x, to.y - from.y);
        Point P = new Point(p.x - from.x, p.y - from.y);
        double NP = (double)N.x * (double)P.x + (double)N.y * (double)P.y;
        double NN = (double)N.x * (double)N.x + (double)N.y * (double)N.y;
        double mu = NP / NN;
        if (mu < 0.0 || mu > 1.0) {
            return null;
        }
        double PP = (double)P.x * (double)P.x + (double)P.y * (double)P.y;
        double dd = PP + NP * NP / NN - 2.0 * NP * NP / NN;
        return new Point(mu < 0.5 ? -1 : 1, (int)dd);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize(null);
        if (this._dimension == null) {
            this._dimension = d;
        } else if (!d.equals(this._dimension)) {
            this.resizeItems(d);
            this._dimension = d;
        }
        Iterator<Item> iter = this._list.values().iterator();
        Color c = g.getColor();
        g.setColor(this._linkColor);
        while (iter.hasNext()) {
            Item item = iter.next();
            item.recalculate(g);
            Item def = item.getDefaultRoute();
            Point t = item.getCenter();
            Iterator<Item> n = item.links();
            while (n.hasNext()) {
                Item linkTo = n.next();
                linkTo.recalculate(g);
                Point pointTo = linkTo.getCenter();
                g.drawLine(t.x, t.y, pointTo.x, pointTo.y);
                if (def == linkTo) {
                    this.drawCircle(g, t, pointTo);
                }
                if (linkTo.getDefaultRoute() == item) {
                    this.drawCircle(g, pointTo, t);
                }
                g.fillPolygon(this.getTriangle(t, pointTo));
            }
        }
        g.setColor(c);
        for (Item item : this._list.values()) {
            if (this._cursor != null && this._cursor == item) continue;
            item.draw(g);
        }
        if (this._cursor != null) {
            g.setXORMode(Color.green);
            this._cursor.draw(g);
            g.setPaintMode();
        }
        if (this._shutdown != null) {
            g.fillRect(this._shutdown.x, this._shutdown.y, this._shutdown.width, this._shutdown.height);
        }
    }

    private void drawCircle(Graphics g, Point from, Point to) {
        double mu = 0.25;
        int x = (int)((double)from.x + mu * ((double)to.x - (double)from.x));
        int y = (int)((double)from.y + mu * ((double)to.y - (double)from.y));
        g.fillOval(x - 10, y - 10, 20, 20);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 500);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this._popup.show(this, e.getPoint().x, e.getPoint().y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this._popup.show(this, e.getPoint().x, e.getPoint().y);
        }
        this._cursor = null;
        this.repaint();
    }

    private Item getItemByPosition(Point p) {
        for (Item o : this._list.values()) {
            Item item = o;
            if (!item._r.contains(p)) continue;
            return item;
        }
        return null;
    }

    private void resizeItems(Dimension d) {
        for (Item o : this._list.values()) {
            o.newPosition(this._dimension, d);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        for (Item item : this._list.values()) {
            if (!item._r.contains(p)) continue;
            if (e.isPopupTrigger()) {
                this.createPrivateMenu(item).show(this, p.x, p.y);
                return;
            }
            this._cursor = item;
            this._offset.x = p.x - ((Item)item)._r.x;
            this._offset.y = p.y - ((Item)item)._r.y;
            this.repaint();
            return;
        }
        this._cursor = null;
        for (Item item : this._list.values()) {
            Iterator<Item> links = item.links();
            while (links.hasNext()) {
                Item toItem = links.next();
                Point diff = this.getDistance(item.getCenter(), toItem.getCenter(), p);
                if (diff == null || diff.y >= 100 || !e.isPopupTrigger()) continue;
                this.createPrivateLineMenu(diff.x < 0 ? item : toItem, diff.x < 0 ? toItem : item).show(this, p.x, p.y);
                return;
            }
        }
        if (e.isPopupTrigger()) {
            this._popup.show(this, p.x, p.y);
            return;
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this._mode = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this._mode = true;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._cursor != null) {
            Dimension d = this.getSize(null);
            Item item = this._cursor;
            Point p = e.getPoint();
            if (p.x < 0 || p.y < 0 || p.x >= d.width || p.y >= d.height) {
                return;
            }
            ((Item)item)._r.x = p.x - this._offset.x;
            ((Item)item)._r.y = p.y - this._offset.y;
            this.repaint();
        }
    }

    public void writeSetup(PrintWriter pw) {
        Item item;
        Iterator<Item> i = this.items();
        while (i.hasNext()) {
            item = i.next();
            pw.println("define " + item.getName());
            Item defRoute = item.getDefaultRoute();
            if (item.isListener()) {
                pw.println("listen " + item.getName());
            }
            Iterator<Item> links = item.links();
            while (links.hasNext()) {
                Item link = links.next();
                pw.println("connect " + item.getName() + " " + link.getName());
            }
            if (defRoute == null) continue;
            pw.println("defaultroute " + item.getName() + " " + defRoute.getName());
        }
        pw.println("# color * background " + this._backgroundColor.getRed() + " " + this._backgroundColor.getGreen() + " " + this._backgroundColor.getBlue() + " ");
        pw.println("# color * item " + this._itemColor.getRed() + " " + this._itemColor.getGreen() + " " + this._itemColor.getBlue() + " ");
        pw.println("# color * text " + this._textColor.getRed() + " " + this._textColor.getGreen() + " " + this._textColor.getBlue() + " ");
        pw.println("# color * link " + this._linkColor.getRed() + " " + this._linkColor.getGreen() + " " + this._linkColor.getBlue() + " ");
        i = this.items();
        while (i.hasNext()) {
            item = i.next();
            pw.println("# move " + item.getName() + " " + (float)((double)((Item)item)._r.x / (double)this._dimension.width) + " " + (float)((double)((Item)item)._r.y / (double)this._dimension.height));
            pw.println("# color " + item.getName() + " background " + item._c.getRed() + " " + item._c.getGreen() + " " + item._c.getBlue());
        }
    }

    private void moveToRevert(Item item) {
        this.moveTo(item, (double)(this._dimension.width - ((Item)item)._r.x - ((Item)item)._r.width) / (double)this._dimension.width, (double)(this._dimension.height - ((Item)item)._r.y - ((Item)item)._r.height) / (double)this._dimension.height);
    }

    private void moveTo(final Item item, final double newX, final double newY) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                double x = (double)((Item)item)._r.x / (double)((MovingPigs)MovingPigs.this)._dimension.width;
                double y = (double)((Item)item)._r.y / (double)((MovingPigs)MovingPigs.this)._dimension.height;
                double diffX = newX - x;
                double diffY = newY - y;
                try {
                    for (double gamma = 0.0; gamma < 1.0; gamma += 0.02) {
                        item.setPosition(gamma * diffX + x, gamma * diffY + y);
                        Thread.sleep(50L);
                        MovingPigs.this.repaint();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                item.setPosition(newX, newY);
            }
        }).start();
    }

    public String command(String command) {
        if (command.length() < 2) {
            return null;
        }
        if (command.charAt(0) == '#') {
            return this.command(command.substring(1));
        }
        StringTokenizer st = new StringTokenizer(command);
        int count = st.countTokens();
        String[] c = new String[count];
        for (int i = 0; i < count; ++i) {
            c[i] = st.nextToken();
        }
        return this.command(c);
    }

    private static Color colorByString(String string) {
        StringTokenizer st = new StringTokenizer(string, ",");
        try {
            return new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        catch (Exception ee) {
            return Color.black;
        }
    }

    public String command(String[] c) {
        if (c.length < 1) {
            return null;
        }
        switch (c[0]) {
            case "define": {
                if (c.length < 2) {
                    return null;
                }
                for (int i = 1; i < c.length; ++i) {
                    this.addItem(c[i]);
                }
                break;
            }
            case "listen": {
                if (c.length < 2) {
                    return null;
                }
                for (int i = 1; i < c.length; ++i) {
                    Item item = this.getItem(c[i], true);
                    item.setListener(true);
                }
                break;
            }
            case "defaultroute": {
                if (c.length != 3) {
                    return null;
                }
                Item item = this.getItem(c[1], true);
                Item routeItem = this.getItem(c[2], true);
                item.setDefaultRoute(routeItem);
                break;
            }
            case "position": {
                if (c.length != 4) {
                    return null;
                }
                try {
                    double x = Double.parseDouble(c[2]);
                    double y = Double.parseDouble(c[3]);
                    Item item = this.getItem(c[1], true);
                    item.setPosition(x, y);
                    break;
                }
                catch (Exception ii) {
                    System.out.println(ii.toString());
                    return null;
                }
            }
            case "move": {
                if (c.length != 4) {
                    return null;
                }
                try {
                    double x = Double.parseDouble(c[2]);
                    double y = Double.parseDouble(c[3]);
                    Item item = this.getItem(c[1], true);
                    this.moveTo(item, x, y);
                    break;
                }
                catch (Exception ii) {
                    System.out.println(ii.toString());
                    return null;
                }
            }
            case "color": {
                if (c.length < 6) {
                    return null;
                }
                try {
                    Color cc = new Color(Integer.parseInt(c[3]), Integer.parseInt(c[4]), Integer.parseInt(c[5]));
                    if (c[1].equals("*")) {
                        switch (c[2]) {
                            case "background": {
                                this._backgroundColor = cc;
                                this.setBackground(this._backgroundColor);
                                break;
                            }
                            case "item": {
                                this._itemColor = cc;
                                break;
                            }
                            case "text": {
                                this._textColor = cc;
                                break;
                            }
                            case "link": {
                                this._linkColor = cc;
                            }
                        }
                    } else {
                        Item item = this.getItem(c[1], true);
                        if (c[2].equals("background")) {
                            item._c = cc;
                        }
                    }
                    this.repaint();
                    break;
                }
                catch (Exception ii) {
                    System.out.println(ii.toString());
                    return null;
                }
            }
            case "clear": {
                this.clear();
                break;
            }
            case "exit": {
                System.exit(0);
            }
            case "connect": {
                if (c.length < 3) {
                    return null;
                }
                Item item = this.getItem(c[1], true);
                for (int i = 2; i < c.length; ++i) {
                    item.addLink(this.getItem(c[i], true));
                }
                break;
            }
            case "remove": {
                if (c.length < 2) {
                    return null;
                }
                this.remove(c[1]);
            }
        }
        return null;
    }

    public class CreateLinkMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = -2959618973411988014L;
        private Item _from;
        private Item _to;
        boolean _create;

        private CreateLinkMenuItem(Item from, Item to, boolean create) {
            super(to.getName());
            this._create = true;
            this._from = from;
            this._to = to;
            this._create = create;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (CreateLinkMenuItem.this._create) {
                        CreateLinkMenuItem.this._from.addLink(CreateLinkMenuItem.this._to);
                    } else {
                        CreateLinkMenuItem.this._from.removeLink(CreateLinkMenuItem.this._to.getName());
                    }
                    MovingPigs.this.repaint();
                }
            });
        }
    }

    public class SetColorMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = -8292651423752612468L;
        private Item _item;

        private SetColorMenuItem(Item item) {
            super("Set color of " + item.getName());
            this._item = item;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Color color = JColorChooser.showDialog(MovingPigs.this, "Choose Color", Color.red);
                    if (color != null) {
                        SetColorMenuItem.this._item._c = color;
                    }
                    MovingPigs.this.repaint();
                }
            });
        }
    }

    public class DeleteMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 139020444246840041L;
        private Item _item;

        private DeleteMenuItem(Item item) {
            super("Delete " + item.getName());
            this._item = item;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MovingPigs.this.remove(DeleteMenuItem.this._item.getName());
                }
            });
        }

        public Item getItem() {
            return this._item;
        }
    }

    public class Item {
        private Rectangle _r;
        private Color _c;
        private String _s;
        private double _nextX = -1.0;
        private double _nextY = -1.0;
        private int _frame = 8;
        private boolean _doesListen;
        private HashMap<String, Item> _links = new HashMap();
        private Item _defaultRoute;

        private Item(String string, Color c) {
            this._s = string;
            this._c = c;
            this._r = MovingPigs.this._dimension != null ? new Rectangle(MovingPigs.this._random.nextInt(((MovingPigs)MovingPigs.this)._dimension.width - 50), MovingPigs.this._random.nextInt(((MovingPigs)MovingPigs.this)._dimension.height - 50), 0, 0) : new Rectangle(10, 10, 0, 0);
        }

        public synchronized void setListener(boolean listen) {
            this._doesListen = listen;
            MovingPigs.this.repaint();
        }

        public boolean isListener() {
            return this._doesListen;
        }

        public synchronized void setDefaultRoute(Item item) {
            this._defaultRoute = item;
            MovingPigs.this.repaint();
        }

        public synchronized Item getDefaultRoute() {
            return this._defaultRoute;
        }

        private synchronized void setPosition(Point p) {
            this._r.x = p.x;
            this._r.y = p.y;
            MovingPigs.this.repaint();
        }

        private synchronized void setPosition(double x, double y) {
            this._nextX = x;
            this._nextY = y;
            MovingPigs.this.repaint();
        }

        private synchronized void newPosition(Dimension oldDim, Dimension newDim) {
            this._r.x = (int)((double)this._r.x / (double)oldDim.width * (double)newDim.width);
            this._r.y = (int)((double)this._r.y / (double)oldDim.height * (double)newDim.height);
        }

        private Point getCenter() {
            Point p = new Point(this._r.x + this._r.width / 2, this._r.y + this._r.height / 2);
            return p;
        }

        private boolean hasLink(Item item) {
            return this._links.get(item.getName()) != null;
        }

        public synchronized void addLink(Item item) {
            this._links.put(item.getName(), item);
            item.setListener(true);
        }

        public synchronized void removeLink(String link) {
            Item item = this._links.remove(link);
            if (item == null) {
                return;
            }
            if (item == this._defaultRoute) {
                this._defaultRoute = null;
            }
            if (item._defaultRoute == this) {
                item._defaultRoute = null;
            }
        }

        public Iterator<Item> links() {
            return this._links.values().iterator();
        }

        public String getName() {
            return this._s;
        }

        private synchronized void recalculate(Graphics g) {
            if (MovingPigs.this._dimension == null) {
                return;
            }
            Rectangle r = (Rectangle)this._r.clone();
            if (this._nextX > -1.0) {
                this._r.x = (int)(this._nextX * (double)((MovingPigs)MovingPigs.this)._dimension.width);
                this._r.y = (int)(this._nextY * (double)((MovingPigs)MovingPigs.this)._dimension.height);
                this._nextX = -1.0;
            }
            g.setFont(MovingPigs.this._font);
            FontMetrics fm = g.getFontMetrics();
            this._r.width = fm.stringWidth(this._s) + 2 * this._frame;
            this._r.height = fm.getMaxAscent() + fm.getMaxDescent() + 2 * this._frame;
        }

        private synchronized void draw(Graphics g) {
            this.recalculate(g);
            g.setColor(this._c);
            g.fill3DRect(this._r.x, this._r.y, this._r.width, this._r.height, MovingPigs.this._mode);
            g.setColor(MovingPigs.this._textColor);
            if (this._doesListen) {
                int[] x = new int[3];
                int[] y = new int[3];
                x[0] = this._r.x + 3;
                x[1] = x[0] + 8;
                x[2] = x[0];
                y[0] = this._r.y + 3;
                y[1] = y[0];
                y[2] = y[0] + 8;
                g.fillPolygon(x, y, 3);
            }
            FontMetrics fm = g.getFontMetrics();
            g.drawString(this._s, this._r.x + this._frame, this._r.y + (fm.getMaxAscent() + this._frame));
        }

        public String toString() {
            return this._s;
        }

        public boolean equals(Object obj) {
            return obj != null && obj.toString().equals(this._s);
        }

        public int hashCode() {
            int i = this._s.hashCode();
            return i;
        }
    }
}

