/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.services.login.UnixPassword;
import dmg.protocols.telnet.TelnetServerAuthentication;
import java.io.Serializable;
import java.net.InetAddress;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetSAuth_A
implements TelnetServerAuthentication {
    private static final Logger _log = LoggerFactory.getLogger(TelnetSAuth_A.class);
    private CellNucleus _nucleus;
    private Args _args;
    private String _password;
    private boolean _localOk;
    private String _acmCell;
    private static UnixPassword __passwordFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TelnetSAuth_A(CellNucleus nucleus, Args args) throws Exception {
        this._nucleus = nucleus;
        this._args = args;
        this._password = args.getOpt("passwd");
        this._password = this._password == null ? "elch" : this._password;
        this._localOk = args.hasOption("localOk");
        this._acmCell = args.getOpt("acm");
        String pwdFile = args.getOpt("pswdfile");
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (__passwordFile == null && pwdFile != null) {
                __passwordFile = new UnixPassword(pwdFile);
            }
        }
    }

    @Override
    public boolean isHostOk(InetAddress host) {
        return this._localOk;
    }

    @Override
    public boolean isUserOk(InetAddress host, String user) {
        return false;
    }

    private boolean checkPasswd(String user, String passwd) throws Exception {
        Object[] request = new Object[]{"request", "*", "check-password", user, passwd};
        CellMessage answerMsg = this._nucleus.sendAndWait(new CellMessage(new CellPath(this._acmCell), (Serializable)request), 4000L);
        if (answerMsg == null) {
            throw new Exception("Timeout from acm");
        }
        Serializable answer = answerMsg.getMessageObject();
        if (!(answer instanceof Object[]) || ((Object[])answer).length < 6 || !(((Object[])answer)[5] instanceof Boolean)) {
            throw new Exception("Wrong formated answer");
        }
        return (Boolean)((Object[])answer)[5];
    }

    private boolean checkAcl(String user, String action, String className, String instanceName) throws Exception {
        Object[] request = new Object[]{"request", "*", "check-acl", user, action, className, instanceName};
        CellMessage answerMsg = this._nucleus.sendAndWait(new CellMessage(new CellPath(this._acmCell), (Serializable)request), 4000L);
        if (answerMsg == null) {
            throw new Exception("Timeout from acm");
        }
        Serializable answer = answerMsg.getMessageObject();
        if (answer instanceof Exception) {
            throw (Exception)answer;
        }
        if (!(answer instanceof Object[]) || ((Object[])answer).length < 8 || !(((Object[])answer)[7] instanceof Boolean)) {
            throw new Exception("Wrong formated answer");
        }
        return (Boolean)((Object[])answer)[7];
    }

    @Override
    public boolean isPasswordOk(InetAddress host, String user, String passwd) {
        if (this._acmCell != null) {
            try {
                if (!this.checkPasswd(user, passwd)) {
                    throw new Exception("Not authenticated");
                }
                if (!this.checkAcl(user, "exec", "shell", "*")) {
                    throw new Exception("Not authorized");
                }
                return true;
            }
            catch (Exception e) {
                _log.info("Exception in TelnetSAuth_A : " + e);
                return false;
            }
        }
        if (__passwordFile != null) {
            return __passwordFile.checkPassword(user, passwd);
        }
        return passwd.equals(this._password);
    }
}

