/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.services.login.UserDb;
import dmg.cells.services.login.UserHandle;
import dmg.cells.services.login.UserPrivileges;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMgrCell
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(UserMgrCell.class);
    private String _cellName;
    private CellNucleus _nucleus;
    private UserDb _userDb;
    private Args _args;
    private static final String[] __root_priv = new String[]{"create-user:user:*", "create-group:user:*", "add-user:user:*", "add-group:user:*", "remove-user:user:*", "destroy-user:user:*", "remove-group:user:*", "destroy-group:user:*", "modify-user:user:*", "modify-group:user:*", "add-allowed:user:*", "remove-allowed:user:*", "add-denied:user:*", "remove-denied:user:*"};
    private static final Class<?>[] __argListDef = new Class[]{UserPrivileges.class, Object[].class};

    public UserMgrCell(String name, String argString) throws Exception {
        super(name, argString, false);
        this._cellName = name;
        this._args = this.getArgs();
        try {
            if (this._args.argc() < 1) {
                throw new IllegalArgumentException("Usage : ... <dbPath>");
            }
            try {
                this._userDb = new UserDb(new File(this._args.argv(0)), false);
            }
            catch (Exception eee) {
                this._userDb = new UserDb(new File(this._args.argv(0)), true);
                this.createRootUser(this._userDb);
            }
        }
        catch (Exception e) {
            this.start();
            this.kill();
            throw e;
        }
        this.start();
    }

    private void createRootUser(UserDb db) throws Exception {
        UserHandle user = db.createUser("root");
        user.open(2);
        for (String a__root_priv : __root_priv) {
            user.addAllowed(a__root_priv);
        }
        user.setPassword("elch");
        user.close(8);
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Serializable answer;
        Serializable obj = msg.getMessageObject();
        try {
            _log.info("Message : " + obj.getClass());
            if (!(obj instanceof Object[]) || ((Object[])obj).length < 3 || !((Object[])obj)[0].equals("request")) {
                String r = "Illegal message object received from : " + msg.getSourcePath();
                _log.warn(r);
                throw new Exception(r);
            }
            Object[] request = (Object[])obj;
            String user = request[1] == null ? "unknown" : (String)request[1];
            String command = (String)request[2];
            UserPrivileges priv = this._userDb.getUserPrivileges(user);
            _log.info(">" + command + "< request from " + user);
            try {
                command = this.createMethodName(command);
                Method m = this.getClass().getDeclaredMethod(command, __argListDef);
                Object[] a = new Object[]{priv, request};
                answer = (Serializable)m.invoke((Object)this, a);
            }
            catch (InvocationTargetException ite) {
                throw (Exception)ite.getTargetException();
            }
            catch (Exception xe) {
                throw new Exception("Command not found : " + request[2]);
            }
        }
        catch (Exception iex) {
            answer = iex;
        }
        if (answer instanceof Object[]) {
            ((Object[])answer)[0] = "response";
        }
        msg.revertDirection();
        msg.setMessageObject(answer);
        try {
            this.sendMessage(msg);
        }
        catch (Exception ioe) {
            _log.warn("Can't send acl_response : " + ioe);
        }
    }

    private String createMethodName(String com) {
        StringBuilder sb = new StringBuilder();
        sb.append("acl_");
        for (int i = 0; i < com.length(); ++i) {
            char c = com.charAt(i);
            sb.append(c == '-' ? (char)'_' : (char)c);
        }
        return sb.toString();
    }

    private Object acl_check_password(UserPrivileges priv, Object[] request) throws Exception {
        String password;
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'check-password'");
        }
        Object[] response = new Object[6];
        System.arraycopy(request, 0, response, 0, 5);
        response[1] = request[3];
        String userName = (String)request[3];
        UserHandle user = this._userDb.getUserByName(userName);
        user.open(1);
        try {
            password = user.getPassword();
        }
        catch (Exception e) {
            user.close(16);
            throw e;
        }
        user.close(8);
        response[5] = password.equals(request[4]);
        return response;
    }

    private Object acl_check_acl(UserPrivileges priv, Object[] request) throws Exception {
        if (request.length < 7) {
            throw new IllegalArgumentException("Not enough arguments for 'check-acl'");
        }
        Object[] response = new Object[8];
        System.arraycopy(request, 0, response, 0, 7);
        response[1] = request[3];
        String userName = (String)request[3];
        UserPrivileges privToCheck = this._userDb.getUserPrivileges(userName);
        String p = "" + request[4] + ":" + request[5] + ":" + request[6];
        response[7] = privToCheck.isAllowed(p);
        return response;
    }

    private Object acl_create_user(UserPrivileges priv, Object[] request) throws Exception {
        if (!priv.isAllowed("create-user:user:*")) {
            throw new Exception("Operation not allowed for " + priv.getUserName());
        }
        if (request.length < 4) {
            throw new IllegalArgumentException("Not enough arguments for 'create-user'");
        }
        this._userDb.createUser((String)request[3]);
        return request;
    }

    private Object acl_get_user_attr(UserPrivileges priv, Object[] request) throws Exception {
        if (request.length < 4) {
            throw new IllegalArgumentException("Not enough arguments for 'get-user-attr'");
        }
        UserHandle user = this._userDb.getUserByName(request[3].toString());
        user.open(1);
        String eMail = user.getEmail();
        user.close(8);
        String[] p = new String[]{"e-mail", eMail};
        Object[] answer = new Object[5];
        System.arraycopy(request, 0, answer, 0, 4);
        answer[4] = new Object[1];
        ((Object[])answer[4])[0] = p;
        return answer;
    }

    private Object acl_set_user_attr(UserPrivileges priv, Object[] request) throws Exception {
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'set-user-attr'");
        }
        if (!(request[4] instanceof Object[])) {
            throw new IllegalArgumentException("Illegal request format 'set-user-attr'");
        }
        UserHandle user = this._userDb.getUserByName(request[3].toString());
        if (!priv.isAllowed("set-password:user:*") && !priv.getUserName().equals(request[3].toString())) {
            throw new Exception("Operation not allowed for " + priv.getUserName());
        }
        Object[] array = (Object[])request[4];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] instanceof String[]) {
                String[] pair = (String[])array[i];
                if (pair[0].equals("e-mail")) {
                    user.open(2);
                    user.setEmail(pair[1]);
                    user.close(8);
                    continue;
                }
                pair[1] = "";
                continue;
            }
            array[i] = null;
        }
        return request;
    }

    private Object acl_create_group(UserPrivileges priv, Object[] request) throws Exception {
        if (request.length < 4) {
            throw new IllegalArgumentException("Not enough arguments for 'create-group'");
        }
        String groupName = (String)request[3];
        if (!priv.isAllowed("create-group:user:" + groupName)) {
            throw new Exception("Operation not allowed for " + priv.getUserName());
        }
        this._userDb.createGroup(groupName);
        return request;
    }

    private Object acl_set_password(UserPrivileges priv, Object[] request) throws Exception {
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'set-password'");
        }
        String userName = (String)request[3];
        if (!priv.isAllowed("set-password:user:*") && !priv.getUserName().equals(userName)) {
            throw new Exception("Operation not allowed for " + priv.getUserName());
        }
        UserHandle user = this._userDb.getUserByName(userName);
        user.open(2);
        user.setPassword((String)request[4]);
        user.close(8);
        return request;
    }

    private Object acl_add_allowed(UserPrivileges priv, Object[] request) throws Exception {
        boolean isGroup;
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'add-allowed'");
        }
        String userName = (String)request[3];
        UserHandle user = this._userDb.getUserByName(userName);
        user.open(1);
        try {
            isGroup = user.isGroup();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            user.close(8);
        }
        if (isGroup) {
            String p = "add-allowed:user:" + userName;
            if (!priv.isAllowed(p)) {
                _log.info(">" + p + "< denied for " + priv.getUserName());
                throw new Exception("Operation not allowed for " + priv.getUserName());
            }
        } else {
            String p = "add-allowed:user:*";
            if (!priv.isAllowed(p)) {
                _log.info(">" + p + "< denied for " + priv.getUserName());
                throw new Exception("Operation not allowed for " + priv.getUserName());
            }
        }
        user.open(2);
        try {
            user.addAllowed((String)request[4]);
        }
        catch (Exception e) {
            user.close(16);
            throw e;
        }
        user.close(8);
        return request;
    }
}

