/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.services.login.user.AcDictionary;
import dmg.cells.services.login.user.AclDb;
import dmg.cells.services.login.user.AclPermissionException;
import dmg.cells.services.login.user.DatabaseException;
import dmg.cells.services.login.user.FileUserRelation;
import dmg.cells.services.login.user.InMemoryUserRelation;
import dmg.cells.services.login.user.UserMetaDb;
import dmg.cells.services.login.user.UserRelationable;
import dmg.util.Authorizable;
import dmg.util.AuthorizedString;
import dmg.util.CommandPanicException;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSecurityCell
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(UserSecurityCell.class);
    private final String _cellName;
    private final CellNucleus _nucleus;
    private final Args _args;
    private AclDb _aclDb;
    private UserRelationable _userDb;
    private UserMetaDb _userMetaDb;
    public static final String hh_show_all = "<user> exception|null|object|string";
    public static final String hh_check_permission = "<user> <acl>";
    public static final String hh_create_user = "<userName>";
    public static final String hh_create_group = "<groupName>";
    public static final String hh_destroy_principal = "<principalName>";
    public static final String hh_add = "<principalName> to <groupName>";
    public static final String hh_remove = "<principalName> from <groupName>";
    public static final String hh_add_access = "[-allowed|-denied] <acl> <principal>";
    public static final String hh_create_acl = "<aclName>";
    public static final String hh_ls_acl = "<aclName> -resolve";

    public UserSecurityCell(String name, String argString) throws Exception {
        super(name, argString, false);
        this._cellName = name;
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        try {
            if (this._args.argc() < 1) {
                throw new IllegalArgumentException("Usage : ... <dbPath>");
            }
            File dbBase = new File(this._args.argv(0));
            this._aclDb = new AclDb(new File(dbBase, "acls"));
            this._userDb = new InMemoryUserRelation(new FileUserRelation(new File(dbBase, "relations")));
            this._userMetaDb = new UserMetaDb(new File(dbBase, "meta"));
        }
        catch (Exception e) {
            _log.warn("Exception while <init> : " + e, (Throwable)e);
            this.start();
            this.kill();
            throw e;
        }
        this.start();
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Serializable answer;
        block10: {
            Serializable obj = msg.getMessageObject();
            try {
                _log.info("Message type : " + obj.getClass());
                if (obj instanceof Object[] && ((Object[])obj).length >= 3 && ((Object[])obj)[0].equals("request")) {
                    Object[] request = (Object[])obj;
                    String user = request[1] == null ? "unknown" : (String)request[1];
                    String command = (String)request[2];
                    _log.info(">" + command + "< request from " + user);
                    try {
                        if (!command.equals("check-password")) {
                            throw new Exception("Command not found : " + command);
                        }
                        answer = this.acl_check_password(request);
                        break block10;
                    }
                    catch (Exception xe) {
                        throw new Exception("Problem : " + xe);
                    }
                }
                if (obj instanceof AuthorizedString) {
                    String command = obj.toString();
                    String user = ((Authorizable)((Object)obj)).getAuthorizedPrincipal();
                    answer = this.execAuthorizedString(user, command);
                    break block10;
                }
                String r = "Illegal message object received from : " + msg.getSourcePath();
                _log.warn(r);
                throw new Exception(r);
            }
            catch (Exception iex) {
                answer = iex;
            }
        }
        if (answer instanceof Object[]) {
            ((Object[])answer)[0] = "response";
        }
        msg.revertDirection();
        msg.setMessageObject(answer);
        try {
            this.sendMessage(msg);
        }
        catch (Exception ioe) {
            _log.warn("Can't send acl_response : " + ioe, (Throwable)ioe);
        }
    }

    private Serializable execAuthorizedString(String user, String command) throws Exception {
        if (user == null || user.length() == 0) {
            throw new Exception("Not authenticated");
        }
        if (command.trim().isEmpty()) {
            return "";
        }
        try {
            return this.command(new Args((CharSequence)(command + " -auth=" + user)));
        }
        catch (CommandPanicException cte) {
            throw (Exception)cte.getTargetException();
        }
        catch (CommandThrowableException cte) {
            throw (Exception)cte.getTargetException();
        }
    }

    private Serializable acl_check_password(Object[] request) {
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'check-password'");
        }
        Object[] response = new Object[6];
        System.arraycopy(request, 0, response, 0, 5);
        response[1] = request[3];
        String userName = (String)request[3];
        response[5] = true;
        return response;
    }

    private void checkPermission(String user, String acl) throws AclPermissionException {
        if (user == null) {
            throw new AclPermissionException("Not authenticated");
        }
        if (!user.equals("admin") && !this._aclDb.check(acl, user, this._userDb)) {
            throw new AclPermissionException("Acl >" + acl + "< negative for " + user);
        }
    }

    public Object ac_show_all_$_1(Args args) throws Exception {
        String user = args.getOpt("auth");
        if (user == null) {
            throw new Exception("Not authenticated");
        }
        String command = args.argv(0);
        _log.info("show all : mode=" + command + ";user=user");
        if (command.equals("exception")) {
            throw new Exception("hallo otto");
        }
        if (command.equals("null")) {
            return null;
        }
        if (command.equals("object")) {
            return args;
        }
        return "Done";
    }

    public Object ac_check_permission_$_2(Args args) {
        try {
            this.checkPermission(args.argv(0), args.argv(1));
            return true;
        }
        catch (AclPermissionException e) {
            return false;
        }
    }

    public String ac_create_user_$_1(Args args) throws Exception {
        this.checkPermission(args.getOpt("auth"), "user.*.create");
        String user = args.argv(0);
        this._userMetaDb.createUser(user);
        return "";
    }

    public String ac_create_group_$_1(Args args) throws Exception {
        this.checkPermission(args.getOpt("auth"), "user.*.create");
        String group = args.argv(0);
        this._userMetaDb.createGroup(group);
        this._userDb.createContainer(group);
        this._aclDb.createAclItem("group." + group + ".access");
        return "";
    }

    public String ac_destroy_principal_$_1(Args args) throws Exception {
        this.checkPermission(args.getOpt("auth"), "user.*.create");
        String user = args.argv(0);
        Enumeration<String> e = this._userDb.getElementsOf(user);
        if (e.hasMoreElements()) {
            throw new DatabaseException("Not Empty : " + user);
        }
        e = this._userDb.getParentsOf(user);
        if (e.hasMoreElements()) {
            throw new DatabaseException("Still in groups : " + user);
        }
        this._userMetaDb.removePrincipal(user);
        try {
            this._userDb.removeContainer(user);
            this._aclDb.removeAclItem("group." + user + ".access");
        }
        catch (Exception ee) {
            _log.warn(args.toString() + " : " + ee);
        }
        return "";
    }

    public String ac_add_$_3(Args args) throws Exception {
        if (!args.argv(1).equals("to")) {
            throw new CommandSyntaxException("keyword 'to' missing");
        }
        String group = args.argv(2);
        String princ = args.argv(0);
        this.checkPermission(args.getOpt("auth"), "group." + group + ".access");
        this._userDb.addElement(group, princ);
        return "";
    }

    public String ac_remove_$_3(Args args) throws Exception {
        if (!args.argv(1).equals("from")) {
            throw new CommandSyntaxException("keyword 'from' missing");
        }
        String group = args.argv(2);
        String princ = args.argv(0);
        this.checkPermission(args.getOpt("auth"), "group." + group + ".access");
        this._userDb.removeElement(group, princ);
        return "";
    }

    public String ac_add_access_$_2(Args args) throws Exception {
        boolean allowed = !args.hasOption("denied");
        String acl = args.argv(0);
        String princ = args.argv(1);
        this.checkPermission(args.getOpt("auth"), "acl." + acl + ".access");
        if (allowed) {
            this._aclDb.addAllowed(acl, princ);
        } else {
            this._aclDb.addDenied(acl, princ);
        }
        return "";
    }

    public String ac_create_acl_$_1(Args args) throws Exception {
        this.checkPermission(args.getOpt("auth"), "super.access");
        this._aclDb.createAclItem(args.argv(0));
        return "";
    }

    public String ac_ls_acl_$_1(Args args) throws Exception {
        if (this._aclDb == null) {
            throw new Exception("AclDb not open");
        }
        boolean resolve = args.hasOption("resolve");
        AcDictionary dict = this._aclDb.getPermissions(args.argv(0), resolve);
        Enumeration<String> e = dict.getPrincipals();
        String inherits = dict.getInheritance();
        StringBuilder sb = new StringBuilder();
        if (inherits == null) {
            sb.append("<resolved>\n");
        } else {
            sb.append("<inherits=").append(inherits).append(">\n");
        }
        while (e.hasMoreElements()) {
            String user = e.nextElement();
            sb.append(user).append(" -> ").append(dict.getPermission(user)).append("\n");
        }
        return sb.toString();
    }
}

