/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ber;

import dmg.protocols.ber.BerFrame;
import dmg.protocols.ber.BerObject;
import java.util.Vector;

public class BerContainer
extends BerObject {
    private static final long serialVersionUID = -5141282409777149384L;
    private Vector<BerObject> _vector = new Vector();

    public BerContainer(int berClass, int tag, byte[] data, int off, int size) {
        super(berClass, false, tag);
        BerFrame frame;
        for (int sum = 0; sum < size; sum += frame.getHeaderSize() + frame.getPayloadSize()) {
            frame = BerContainer.decode(data, off + sum, 0);
            this.addObject(frame.getObject());
        }
    }

    public BerContainer(int berClass, int tag) {
        super(berClass, false, tag);
    }

    public void addObject(BerObject obj) {
        this._vector.addElement(obj);
    }

    public BerObject objectAt(int i) {
        return this._vector.elementAt(i);
    }

    public BerContainer containerAt(int i) {
        return (BerContainer)this._vector.elementAt(i);
    }

    public int size() {
        return this._vector.size();
    }

    @Override
    public String getTypeString() {
        return super.getTypeString() + (this.getType() == 48 ? " SEQUENCE " : "");
    }

    @Override
    public byte[] getEncodedData() {
        byte[][] a = new byte[this._vector.size()][];
        int totalLength = 0;
        for (int i = 0; i < a.length; ++i) {
            a[i] = this._vector.elementAt(i).getEncodedData();
            totalLength += a[i].length;
        }
        byte[] len = BerContainer.getEncodedLength(totalLength);
        byte[] type = this.getEncodedType();
        byte[] result = new byte[totalLength + len.length + type.length];
        int p = 0;
        System.arraycopy(type, 0, result, p, type.length);
        System.arraycopy(len, 0, result, p += type.length, len.length);
        p += len.length;
        for (byte[] bytes : a) {
            System.arraycopy(bytes, 0, result, p, bytes.length);
            p += bytes.length;
        }
        return result;
    }

    @Override
    public void printNice(int level) {
        int i;
        int count = this.size();
        for (i = 0; i < level * 3; ++i) {
            System.out.print(" ");
        }
        System.out.println(this.getTypeString());
        for (i = 0; i < count; ++i) {
            this.objectAt(i).printNice(level + 1);
        }
    }
}

