/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ber;

import dmg.protocols.ber.BerObject;

public class BerInteger
extends BerObject {
    private static final long serialVersionUID = 834710276513025029L;
    private long _value;

    public BerInteger(long value) {
        super(0, true, 2);
        this._value = value;
    }

    public BerInteger(byte[] data, int off, int size) {
        super(0, true, 2);
        this._value = 0L;
        for (int i = 0; i < size; ++i) {
            this._value <<= 8;
            int b = data[off + i];
            this._value += (long)(b < 0 ? b + 256 : b);
        }
    }

    public long getLongValue() {
        return this._value;
    }

    @Override
    public String toString() {
        return "" + this._value;
    }

    @Override
    public String getTypeString() {
        return super.getTypeString() + " Integer";
    }

    @Override
    public byte[] getEncodedData() {
        byte[] a = new byte[8];
        long x = this._value;
        int h = -1;
        for (int i = 0; i < 8; ++i) {
            int tmp = (int)(x & 0xFFL);
            tmp = tmp > 128 ? tmp - 256 : tmp;
            a[i] = (byte)tmp;
            if (a[i] != 0) {
                h = i;
            }
            x >>= 8;
        }
        byte[] result = new byte[h + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[h - i];
        }
        return this.getEncodedData(result);
    }

    public static void main(String[] args) {
        long n = Long.parseLong(args[0]);
        BerInteger ber = new BerInteger(n);
        ber.printNice();
        byte[] r = ber.getEncodedData();
        BerObject.displayHex(r);
    }
}

