/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpGetNextRequest;
import dmg.protocols.snmp.SnmpGetRequest;
import dmg.protocols.snmp.SnmpGetResponse;
import dmg.protocols.snmp.SnmpInteger;
import dmg.protocols.snmp.SnmpObjectHeader;
import dmg.protocols.snmp.SnmpSequence;
import dmg.protocols.snmp.SnmpSetRequest;
import dmg.protocols.snmp.SnmpTrap;

public class SnmpPDU
extends SnmpSequence {
    SnmpInteger _requestID;
    SnmpInteger _errorStatus;
    SnmpInteger _errorIndex;
    SnmpSequence _varBindList;
    int _type;

    SnmpPDU(SnmpObjectHeader head, byte[] b, int offIn, int maxLen) {
        super(head, b, offIn, maxLen);
        if (this.size() < 4) {
            throw new NumberFormatException("Not a PDU");
        }
        try {
            this._requestID = (SnmpInteger)this.objectAt(0);
            this._errorStatus = (SnmpInteger)this.objectAt(1);
            this._errorIndex = (SnmpInteger)this.objectAt(2);
            this._varBindList = (SnmpSequence)this.objectAt(3);
        }
        catch (Exception e) {
            throw new NumberFormatException("Not a PDU structure");
        }
        this._determineType();
    }

    public SnmpPDU(SnmpInteger id, SnmpInteger status, SnmpInteger index, SnmpSequence list) {
        this._requestID = id;
        this._errorStatus = status;
        this._errorIndex = index;
        this._varBindList = list;
        this._determineType();
        this.addObject(this._requestID);
        this.addObject(this._errorStatus);
        this.addObject(this._errorIndex);
        this.addObject(this._varBindList);
    }

    public SnmpPDU(SnmpSequence snmp) {
        super(snmp);
        if (this.size() < 4) {
            throw new NumberFormatException("Not a PDU");
        }
        try {
            this._requestID = (SnmpInteger)this.objectAt(0);
            this._errorStatus = (SnmpInteger)this.objectAt(1);
            this._errorIndex = (SnmpInteger)this.objectAt(2);
            this._varBindList = (SnmpSequence)this.objectAt(3);
        }
        catch (Exception e) {
            throw new NumberFormatException("Not a PDU structure");
        }
        this._determineType();
    }

    @Override
    public byte[] getSnmpBytes() {
        this.removeAllObjects();
        this.addObject(this._requestID);
        this.addObject(this._errorStatus);
        this.addObject(this._errorIndex);
        this.addObject(this._varBindList);
        return super.getSnmpBytes(this._type);
    }

    private void _determineType() {
        if (this instanceof SnmpGetRequest) {
            this._type = 160;
        } else if (this instanceof SnmpGetNextRequest) {
            this._type = 161;
        } else if (this instanceof SnmpGetResponse) {
            this._type = 162;
        } else if (this instanceof SnmpSetRequest) {
            this._type = 163;
        } else if (this instanceof SnmpTrap) {
            this._type = 164;
        }
    }

    public SnmpInteger getRequestID() {
        return this._requestID;
    }

    public SnmpInteger getErrorStatus() {
        return this._errorStatus;
    }

    public SnmpInteger getErrorIndex() {
        return this._errorIndex;
    }

    public SnmpSequence getVarBindList() {
        return this._varBindList;
    }
}

