/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpGetNextRequest;
import dmg.protocols.snmp.SnmpInteger;
import dmg.protocols.snmp.SnmpNull;
import dmg.protocols.snmp.SnmpOID;
import dmg.protocols.snmp.SnmpObject;
import dmg.protocols.snmp.SnmpObjectHeader;
import dmg.protocols.snmp.SnmpOctetString;
import dmg.protocols.snmp.SnmpSequence;
import dmg.protocols.snmp.SnmpVarBind;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class SnmpTest {
    public static final int listenPort = 22112;

    public static void main(String[] args) {
        if (args.length < 2) {
            try {
                DatagramSocket socket = new DatagramSocket(22112);
                DatagramPacket recPacket = new DatagramPacket(new byte[1024], 1024);
                System.out.println("Waiting for answer");
                socket.receive(recPacket);
                System.out.println("Tranmission finished");
                byte[] b = recPacket.getData();
                int len = recPacket.getLength();
                SnmpObjectHeader._print(b, 0, len);
            }
            catch (Exception eee) {
                System.err.println(" Exception : " + eee);
            }
        } else {
            String hostName = args[0];
            int port = new Integer(args[1]);
            String oid = args.length < 3 ? "1.3.6.1.2.1.1.3" : args[2];
            SnmpSequence list = new SnmpSequence();
            list.addObject(new SnmpVarBind(new SnmpOID(oid), new SnmpNull()));
            SnmpGetNextRequest getRequest = new SnmpGetNextRequest(new SnmpInteger(100L), new SnmpInteger(0L), new SnmpInteger(0L), list);
            SnmpSequence request = new SnmpSequence();
            request.addObject(new SnmpInteger(0L));
            request.addObject(new SnmpOctetString("public"));
            request.addObject(getRequest);
            byte[] b = request.getSnmpBytes();
            String output = SnmpObjectHeader._print(b, 0, b.length);
            System.out.println("Sending to host " + hostName + " port " + port);
            System.out.println("Data : " + output);
            try {
                DatagramSocket socket = new DatagramSocket();
                InetAddress addr = InetAddress.getByName(hostName);
                DatagramPacket recPacket = new DatagramPacket(new byte[1024], 1024);
                DatagramPacket packet = new DatagramPacket(b, b.length, addr, port);
                socket.send(packet);
                System.out.println("Waiting for answer");
                socket.receive(recPacket);
                System.out.println("Tranmission finished");
                b = recPacket.getData();
                int len = recPacket.getLength();
                System.out.println(" Result (" + len + ") : " + SnmpObjectHeader._print(b, 0, len));
                SnmpObject res = SnmpObject.generate(b, 0, len);
                System.out.println("Data : " + res);
            }
            catch (Exception eee) {
                System.err.println(" Exception : " + eee);
            }
        }
    }
}

