/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpNull;
import dmg.protocols.snmp.SnmpOID;
import dmg.protocols.snmp.SnmpObject;
import dmg.protocols.snmp.SnmpObjectHeader;
import dmg.protocols.snmp.SnmpSequence;

public class SnmpVarBind
extends SnmpSequence {
    SnmpOID _id;
    SnmpObject _value;

    SnmpVarBind(SnmpObjectHeader head, byte[] b, int offIn, int maxLen) {
        super(head, b, offIn, maxLen);
        if (this.size() < 4) {
            throw new NumberFormatException("Not a VarBind");
        }
        try {
            this._id = (SnmpOID)this.objectAt(0);
            this._value = this.objectAt(1);
        }
        catch (Exception e) {
            throw new NumberFormatException("Not a VarBind structure");
        }
    }

    public SnmpVarBind(SnmpOID id, SnmpObject value) {
        this._id = id;
        this._value = value;
    }

    @Override
    public byte[] getSnmpBytes() {
        this.removeAllObjects();
        this.addObject(this._id);
        this.addObject(this._value);
        return super.getSnmpBytes();
    }

    public SnmpOID getObjectID() {
        return this._id;
    }

    public SnmpObject getValue() {
        return this._value;
    }

    public static void main(String[] args) {
        SnmpVarBind varBind = new SnmpVarBind(new SnmpOID("1.3.6.1.2"), new SnmpNull());
        byte[] b = varBind.getSnmpBytes();
        String x = SnmpObjectHeader._print(b, 0, b.length);
        System.out.println(x);
    }
}

