/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshCmsgExitConfirmation;
import dmg.protocols.ssh.SshCmsgStdinData;
import dmg.protocols.ssh.SshMsgDebug;
import dmg.protocols.ssh.SshPacket;
import dmg.protocols.ssh.SshSmsgExitStatus;
import dmg.protocols.ssh.SshSmsgStderrData;
import dmg.protocols.ssh.SshSmsgStdoutData;
import dmg.protocols.ssh.SshStreamEngine;
import dmg.protocols.ssh.SshStringPacket;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshInputStream
extends InputStream {
    private static final Logger _log = LoggerFactory.getLogger(SshInputStream.class);
    private SshStreamEngine _core;
    private int _rest;
    private int _position;
    private int _mode;
    private byte[] _buffer;
    private boolean _exitReceived;
    private boolean _exitConfirmed;

    public SshInputStream(SshStreamEngine core) {
        this._core = core;
        this._mode = this._core.getMode();
    }

    @Override
    public int read() throws IOException {
        byte[] x = new byte[1];
        int rc = this.read(x, 0, x.length);
        if (rc <= 0) {
            return rc;
        }
        return x[0] < 0 ? 256 + x[0] : x[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this._rest > 0 || this.nextPacket()) {
            int l = len > this._rest ? this._rest : len;
            System.arraycopy(this._buffer, this._position, b, off, l);
            this._rest -= l;
            this._position += l;
            return l;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this._rest == 0 && this._core.isPacketAvailable()) {
            this.nextPacket();
        }
        return this._rest;
    }

    private boolean nextPacket() throws IOException {
        if (this._exitConfirmed) {
            throw new IOException("Stream inactive");
        }
        block9: while (true) {
            SshPacket packet;
            if ((packet = this._core.readPacket()) == null) {
                this._exitConfirmed = true;
                this._core.confirmed();
                return false;
            }
            switch (packet.getType()) {
                case 16: {
                    _log.debug("SSH_CMSG_STDIN_DATA");
                    SshStringPacket stdin = new SshCmsgStdinData(packet);
                    this._buffer = stdin.getBinary();
                    this._rest = this._buffer.length;
                    this._position = 0;
                    if (this._rest > 0) {
                        return true;
                    }
                }
                case 17: {
                    _log.debug("SSH_CMSG_STDOUT_DATA");
                    SshStringPacket stdin = new SshSmsgStdoutData(packet);
                    this._buffer = stdin.getBinary();
                    this._rest = this._buffer.length;
                    this._position = 0;
                    if (this._rest <= 0) continue block9;
                    return true;
                }
                case 18: {
                    _log.debug("SSH_CMSG_STDERR_DATA");
                    SshStringPacket stdin = new SshSmsgStderrData(packet);
                    this._buffer = stdin.getBinary();
                    this._rest = this._buffer.length;
                    this._position = 0;
                    if (this._rest <= 0) continue block9;
                    return true;
                }
                case 20: {
                    SshSmsgExitStatus status = new SshSmsgExitStatus(packet);
                    _log.debug("SSH_SMSG_EXITSTATUS {}", (Object)status.getValue());
                    this._core.writePacket(new SshCmsgExitConfirmation());
                    this._exitConfirmed = true;
                    this._core.confirmed();
                    return false;
                }
                case 33: {
                    _log.debug("SSH_CMSG_EXIT_CONFORMATION");
                    this._exitConfirmed = true;
                    this._core.confirmed();
                    return false;
                }
                case 19: {
                    _log.debug("SSH_CMSG_EOF");
                    return false;
                }
                case 36: {
                    SshMsgDebug debug = new SshMsgDebug(packet);
                    _log.debug("SSH_MSG_DEBUG : {}", (Object)debug.getMessage());
                    break;
                }
                default: {
                    _log.debug("Unknown packet Type: {}", (Object)packet.getType());
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this._core.close();
        this._exitConfirmed = true;
    }
}

