/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshOutputStreamWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class SshInputStreamReader
extends FilterReader {
    private boolean _eof;
    private boolean _echo = true;
    private char _echoChar = '\u0000';
    private boolean _tempEchoOff;
    private SshOutputStreamWriter _output;
    private static final char CONTROL_H = '\b';

    public SshInputStreamReader(InputStream input) {
        super(new InputStreamReader(input));
        this._output = null;
    }

    public SshInputStreamReader(InputStream input, OutputStream output) {
        super(new InputStreamReader(input));
        this._output = new SshOutputStreamWriter(output);
    }

    public void setEcho(boolean e) {
        this._echo = e;
    }

    public void setEchoChar(char c) {
        this._echoChar = c;
    }

    public int readx(char[] cbuf, int off, int len) throws IOException {
        System.out.println("Requesting " + len);
        if (this._eof) {
            return -1;
        }
        int rc = super.read(cbuf, off, len);
        System.out.println("rc : " + rc);
        if (rc <= 0) {
            return rc;
        }
        for (int i = off; i < off + rc; ++i) {
            char ccc = cbuf[i];
            System.out.println("xx = " + ccc);
            if (cbuf[i] == '\r') {
                cbuf[i] = 10;
                this._tempEchoOff = false;
            } else {
                if (cbuf[i] == '\u0004') {
                    this._eof = true;
                    rc = i - off - 1;
                    break;
                }
                if (cbuf[i] == '\t') {
                    this._tempEchoOff = true;
                }
            }
            if (this._output == null) continue;
            if (cbuf[i] == '\n' || this._echo && !this._tempEchoOff) {
                this._output.write(cbuf[i]);
            } else if (this._echoChar != '\u0000') {
                this._output.write(this._echoChar);
            }
            this._output.flush();
        }
        return rc;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this._eof) {
            return -1;
        }
        int i = off;
        while (i < off + 1) {
            int n = super.read(cbuf, i, 1);
            if (n < 0) {
                this._eof = true;
                return -1;
            }
            if (cbuf[i] == '\r') {
                cbuf[i] = 10;
                this.push(cbuf[i]);
                this._tempEchoOff = false;
                ++i;
                break;
            }
            if (cbuf[i] == '\u0004') {
                this._eof = true;
                break;
            }
            if (cbuf[i] == '\b' || cbuf[i] == '\u007f') {
                cbuf[i] = 8;
                this.push('\b');
                this.push(' ');
                this.push('\b');
                ++i;
                continue;
            }
            if (cbuf[i] == '\t') {
                this._tempEchoOff = !this._tempEchoOff;
                continue;
            }
            this.push(cbuf[i]);
            ++i;
        }
        return i - off;
    }

    public void push(char c) throws IOException {
        if (this._output != null) {
            if (c == '\n' || this._echo && !this._tempEchoOff) {
                this._output.write(c);
            } else if (this._echoChar != '\u0000') {
                this._output.write(this._echoChar);
            }
            this._output.flush();
        }
    }
}

