/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshAuthMethod;
import dmg.protocols.ssh.SshAuthPassword;
import dmg.protocols.ssh.SshAuthRhostsRsa;
import dmg.protocols.ssh.SshAuthRsa;
import dmg.protocols.ssh.SshClientAuthentication;
import dmg.protocols.ssh.SshRsaKey;
import dmg.protocols.ssh.SshRsaKeyContainer;
import dmg.protocols.ssh.SshSharedKey;
import dmg.protocols.ssh.SshStreamEngine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class SshStreamClientTest
implements SshClientAuthentication {
    SshRsaKey _userKey;
    SshRsaKey _hostKey;
    SshRsaKeyContainer _objectKeys;
    SshStreamEngine _engine;
    Socket _socket;
    private static final int ST_NULL = 0;
    private static final int ST_PASSWORD = 1;
    private static final int ST_RSA = 2;
    private static final int ST_RHOSTS_RSA = 3;
    private int _state = 2;

    public SshStreamClientTest(String address, int port, String objectsKeysFile, String userKeyFile, String hostKeyFile) throws Exception {
        String str;
        this._socket = new Socket(address, port);
        this._objectKeys = new SshRsaKeyContainer(new FileInputStream(objectsKeysFile));
        this._userKey = userKeyFile.equals("NONE") ? null : new SshRsaKey(new FileInputStream(userKeyFile));
        this._hostKey = hostKeyFile.equals("NONE") ? null : new SshRsaKey(new FileInputStream(hostKeyFile));
        this._engine = new SshStreamEngine(this._socket, this);
        System.out.println("Creating reader");
        BufferedReader br = new BufferedReader(this._engine.getReader());
        System.out.println("Creating writer");
        PrintWriter pw = new PrintWriter(this._engine.getWriter());
        System.out.println("Sending command");
        pw.println("ps -a");
        pw.println("exit");
        pw.println("exit");
        pw.flush();
        while ((str = br.readLine()) != null) {
            System.out.println(" line received : " + str);
        }
    }

    @Override
    public boolean isHostKey(InetAddress host, SshRsaKey keyModulus) {
        SshRsaKey key = this._objectKeys.findByModulus(keyModulus);
        System.out.println("ServerKey : " + keyModulus.getFingerPrint());
        if (key == null) {
            System.out.println(" Couldn't find key for host " + host);
            return true;
        }
        System.out.println(" Key found for host " + host + " -> " + key.getComment());
        return true;
    }

    @Override
    public String getUser() {
        System.out.println(" User requested");
        return "manfred";
    }

    @Override
    public SshSharedKey getSharedKey(InetAddress host) {
        return null;
    }

    @Override
    public SshAuthMethod getAuthMethod() {
        SshAuthMethod rc = null;
        switch (this._state) {
            case 0: {
                rc = null;
                break;
            }
            case 1: {
                System.out.println("Trying ST_PASSWORD");
                rc = new SshAuthPassword("manfred");
                this._state = 3;
                break;
            }
            case 2: {
                System.out.println("Trying ST_RSA");
                System.out.println(" User Key : \n" + this._userKey);
                rc = new SshAuthRsa(this._userKey);
                this._state = 0;
                break;
            }
            case 3: {
                System.out.println("Trying ST_RHOSTS_RSA");
                rc = new SshAuthRhostsRsa("patrick", this._hostKey);
                this._state = 0;
            }
        }
        return rc;
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println(" USAGE : SshStreamClientTest <host> <port> <knownObjects.pub> <userKey.priv>|NONE  <hostKey.priv>|NONE");
            System.exit(4);
        }
        try {
            String address = args[0];
            int port = new Integer(args[1]);
            String knownObjects = args[2];
            String userKey = args[3];
            String hostKey = args[4];
            new SshStreamClientTest(address, port, knownObjects, userKey, hostKey);
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
            e.printStackTrace();
        }
    }
}

