/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.idea;

import java.util.Date;
import java.util.Random;

public class Jdea {
    private long[] _k = new long[54];
    private long[] _dk = new long[54];
    private byte[] _vec = new byte[8];
    private int _num;
    private byte[] _key = new byte[16];
    private final int DECRYPT = 0;
    private final int ENCRYPT = 1;

    public Jdea() {
        byte[] key = new byte[this._key.length];
        Random r = new Random(new Date().getTime());
        r.nextBytes(key);
        this._Jdea(key);
    }

    private void printSchedule(long[] x) {
        for (int j = 0; j < 6; ++j) {
            for (int i = 0; i < 9; ++i) {
                System.out.print(Long.toHexString(x[6 * i + j]) + " ");
            }
            System.out.println("");
        }
    }

    public Jdea(byte[] key) {
        this._Jdea(key);
    }

    private void _Jdea(byte[] key) {
        System.arraycopy(key, 0, this._key, 0, this._key.length);
        for (int i = 0; i < this._key.length / 2; ++i) {
            this._vec[i] = (byte)(this._key[i] ^ this._key[i + this._vec.length]);
        }
        this.createEnKey(this._key);
        this.printSchedule(this._k);
        this.createDeKey();
    }

    public byte[] getKeyBytes() {
        byte[] out = new byte[this._key.length];
        System.arraycopy(this._key, 0, out, 0, this._key.length);
        return out;
    }

    public void setStartValue(byte[] vec) {
        System.arraycopy(vec, 0, this._vec, 0, vec.length > this._vec.length ? this._vec.length : vec.length);
        this._num = 0;
    }

    public byte[] getStartValue() {
        byte[] vec = new byte[this._vec.length];
        System.arraycopy(this._vec, 0, vec, 0, this._vec.length);
        return vec;
    }

    public void encryptECB(byte[] in, int inOff, byte[] out, int outOff) {
        this.xcrypt(in, inOff, out, outOff, this._k);
    }

    public void decryptECB(byte[] in, int inOff, byte[] out, int outOff) {
        this.xcrypt(in, inOff, out, outOff, this._dk);
    }

    public void encryptCFB64(byte[] in, int oIn, int len) {
        this.encryptCFB64(in, oIn, in, oIn, len);
    }

    public void decryptCFB64(byte[] in, int oIn, int len) {
        this.decryptCFB64(in, oIn, in, oIn, len);
    }

    public void encryptCFB64(byte[] in, int oIn, byte[] out, int oOut, int len) {
        this._num = this.cbf64_xcrypt(in, oIn, out, oOut, len, this._k, this._vec, this._num, 1);
    }

    public void decryptCFB64(byte[] in, int oIn, byte[] out, int oOut, int len) {
        this._num = this.cbf64_xcrypt(in, oIn, out, oOut, len, this._k, this._vec, this._num, 0);
    }

    private void createEnKey(byte[] key) {
        int i;
        long[] k = new long[16];
        for (i = 0; i < 16; ++i) {
            k[i] = key[i] < 0 ? 256L + (long)key[i] : (long)key[i];
        }
        for (i = 0; i < 8; ++i) {
            this._k[i] = k[2 * i] << 8 | k[2 * i + 1];
        }
        int kt = 0;
        int kf = 0;
        kt += 8;
        for (int i2 = 0; i2 < 6; ++i2) {
            long r2 = this._k[kf + 1];
            long r1 = this._k[kf + 2];
            this._k[kt++] = (r2 << 9 | r1 >>> 7) & 0xFFFFL;
            long r0 = this._k[kf + 3];
            this._k[kt++] = (r1 << 9 | r0 >>> 7) & 0xFFFFL;
            r1 = this._k[kf + 4];
            this._k[kt++] = (r0 << 9 | r1 >>> 7) & 0xFFFFL;
            r0 = this._k[kf + 5];
            this._k[kt++] = (r1 << 9 | r0 >>> 7) & 0xFFFFL;
            r1 = this._k[kf + 6];
            this._k[kt++] = (r0 << 9 | r1 >>> 7) & 0xFFFFL;
            r0 = this._k[kf + 7];
            this._k[kt++] = (r1 << 9 | r0 >>> 7) & 0xFFFFL;
            r1 = this._k[kf + 0];
            if (i2 >= 5) break;
            this._k[kt++] = (r0 << 9 | r1 >>> 7) & 0xFFFFL;
            this._k[kt++] = (r1 << 9 | r2 >>> 7) & 0xFFFFL;
            kf += 8;
        }
    }

    private void createDeKey() {
        int tp = 0;
        int fp = 48;
        for (int r = 0; r < 9; ++r) {
            this._dk[tp++] = this.inverse(this._k[fp + 0]);
            this._dk[tp++] = 65536L - this._k[fp + 2] & 0xFFFFL;
            this._dk[tp++] = 65536L - this._k[fp + 1] & 0xFFFFL;
            this._dk[tp++] = this.inverse(this._k[fp + 3]);
            if (r == 8) break;
            this._dk[tp++] = this._k[(fp -= 6) + 4];
            this._dk[tp++] = this._k[fp + 5];
        }
        long t = this._dk[1];
        this._dk[1] = this._dk[2];
        this._dk[2] = t;
        t = this._dk[49];
        this._dk[49] = this._dk[50];
        this._dk[50] = t;
    }

    private long inverse(long xin) {
        long b2;
        if (xin == 0L) {
            b2 = 0L;
        } else {
            long r;
            long n1 = 65537L;
            long n2 = xin;
            b2 = 1L;
            long b1 = 0L;
            do {
                r = n1 % n2;
                long q = (n1 - r) / n2;
                if (r == 0L) {
                    if (b2 >= 0L) continue;
                    b2 = 65537L + b2;
                    continue;
                }
                n1 = n2;
                n2 = r;
                long t = b2;
                b2 = b1 - q * b2;
                b1 = t;
            } while (r != 0L);
        }
        return b2;
    }

    private long mul(long a, long b) {
        long r;
        long ul = a * b;
        if (ul != 0L) {
            r = (ul & 0xFFFFL) - (ul >> 16);
            r -= r >> 16;
        } else {
            r = (long)(-((int)a)) - b + 1L;
        }
        return r;
    }

    private int cbf64_xcrypt(byte[] in, int oIn, byte[] out, int oOut, int len, long[] key, byte[] vec, int num, int mode) {
        if (mode == 1) {
            for (int i = 0; i < len; ++i) {
                if (num == 0) {
                    this.xcrypt(vec, 0, vec, 0, key);
                }
                byte by = (byte)(vec[num] ^ in[i + oIn]);
                out[i + oOut] = by;
                vec[num] = by;
                num = num + 1 & 7;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (num == 0) {
                    this.xcrypt(vec, 0, vec, 0, key);
                }
                vec[num] = in[i + oIn];
                out[i + oOut] = (byte)(vec[num] ^ vec[num]);
                num = num + 1 & 7;
            }
        }
        return num;
    }

    private void xcrypt(byte[] in, int inOff, byte[] out, int outOff, long[] key) {
        long[] d = new long[]{((long)in[inOff + 0] & 0xFFL) << 24 | ((long)in[inOff + 1] & 0xFFL) << 16 | ((long)in[inOff + 2] & 0xFFL) << 8 | ((long)in[inOff + 3] & 0xFFL) << 0, ((long)in[inOff + 4] & 0xFFL) << 24 | ((long)in[inOff + 5] & 0xFFL) << 16 | ((long)in[inOff + 6] & 0xFFL) << 8 | ((long)in[inOff + 7] & 0xFFL) << 0};
        this.xcrypt(d, key);
        out[outOff + 0] = (byte)(d[0] >>> 24 & 0xFFL);
        out[outOff + 1] = (byte)(d[0] >>> 16 & 0xFFL);
        out[outOff + 2] = (byte)(d[0] >>> 8 & 0xFFL);
        out[outOff + 3] = (byte)(d[0] >>> 0 & 0xFFL);
        out[outOff + 4] = (byte)(d[1] >>> 24 & 0xFFL);
        out[outOff + 5] = (byte)(d[1] >>> 16 & 0xFFL);
        out[outOff + 6] = (byte)(d[1] >>> 8 & 0xFFL);
        out[outOff + 7] = (byte)(d[1] >>> 0 & 0xFFL);
    }

    public long bytesToLong(byte[] b, int off, int l) {
        l = l > 8 ? 8 : l;
        l = l > b.length ? b.length : l;
        long r = 0L;
        int s = 8 * (l - 1);
        int i = 0;
        while (i < l) {
            r |= ((long)b[i] & 0xFFL) << s;
            ++i;
            s -= 8;
        }
        return r;
    }

    public long bytesToLong(byte[] b, int l) {
        l = l > 8 ? 8 : l;
        l = l > b.length ? b.length : l;
        long r = 0L;
        int s = 8 * (l - 1);
        int i = 0;
        while (i < l) {
            r |= ((long)b[i] & 0xFFL) << s;
            ++i;
            s -= 8;
        }
        return r;
    }

    public void longToBytes(long lg, byte[] b, int l) {
        l = l > b.length ? b.length : l;
        long r = 0L;
        int s = 8 * (l - 1);
        int i = 0;
        while (i < l) {
            b[i] = (byte)(lg >>> s & 0xFFL);
            ++i;
            s -= 8;
        }
    }

    public static String byteToHexString(byte b) {
        String str = Integer.toHexString(b < 0 ? 256 + b : b);
        return str.length() == 1 ? "0" + str : str;
    }

    public static String byteToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length + 1);
        for (byte aByte : bytes) {
            sb.append(Jdea.byteToHexString(aByte)).append(" ");
        }
        return sb.toString();
    }

    private void xcrypt(long[] d, long[] key) {
        long t1;
        long t0;
        long x2 = d[0];
        long x1 = x2 >> 16;
        long x4 = d[1];
        long x3 = x4 >> 16;
        int p = 0;
        for (int i = 0; i < 8; ++i) {
            x1 &= 0xFFFFL;
            x1 = this.mul(x1, key[p++]);
            x2 += key[p++];
            int n = p++;
            x4 &= 0xFFFFL;
            x4 = this.mul(x4, key[p++]);
            t0 = (x1 ^ (x3 += key[n])) & 0xFFFFL;
            t0 = this.mul(t0, key[p++]);
            t1 = t0 + (x2 ^ x4) & 0xFFFFL;
            t1 = this.mul(t1, key[p++]);
            x1 ^= t1;
            x4 ^= (t0 += t1);
            long ul = x2 ^ t0;
            x2 = x3 ^ t1;
            x3 = ul;
        }
        x1 &= 0xFFFFL;
        x1 = this.mul(x1, key[p++]);
        t0 = x3 + key[p++];
        t1 = x2 + key[p++];
        x4 &= 0xFFFFL;
        x4 = this.mul(x4, key[p]);
        d[0] = t0 & 0xFFFFL | (x1 & 0xFFFFL) << 16;
        d[1] = x4 & 0xFFFFL | (t1 & 0xFFFFL) << 16;
    }

    public static void main(String[] args) {
        int i;
        if (args.length < 16) {
            System.err.println(" Jdea <key0> <key15> [<data0> ... <data15>]");
            System.exit(3);
        }
        byte[] key = new byte[16];
        for (i = 0; i < key.length; ++i) {
            key[i] = (byte)i;
        }
        for (i = 0; i < 16; ++i) {
            key[i] = (byte)Long.parseLong(args[i], 16);
        }
        Random r = new Random();
        byte[] vector = new byte[8];
        r.nextBytes(vector);
        Jdea encrypt = new Jdea(key);
        Jdea decrypt = new Jdea(key);
        encrypt.setStartValue(vector);
        decrypt.setStartValue(vector);
        int restArgs = args.length - 16;
        byte[] b = new byte[restArgs];
        for (int i2 = 0; i2 < restArgs; ++i2) {
            b[i2] = (byte)Long.parseLong(args[16 + i2], 16);
        }
        System.out.println(" Plain :  " + Jdea.byteToHexString(b));
        encrypt.encryptECB(b, 0, b, 0);
        System.out.println(" Cypher : " + Jdea.byteToHexString(b));
        decrypt.decryptECB(b, 0, b, 0);
        System.out.println(" Plain :  " + Jdea.byteToHexString(b));
    }
}

