/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.rsa;

import dmg.security.cipher.IllegalEncryptionException;
import dmg.security.cipher.StreamEncryption;
import dmg.security.cipher.rsa.RsaEncryption;
import dmg.security.cipher.rsa.RsaEncryptionKey;

public class RsaStreamEncryption
extends RsaEncryption
implements StreamEncryption {
    private int _cipherLength = this.getCipherBlockLength();

    public RsaStreamEncryption(RsaEncryptionKey pub, RsaEncryptionKey priv) {
        super(pub, priv);
    }

    @Override
    public void encrypt(byte[] plain, int plainOff, byte[] cipher, int cipherOff, int len) throws IllegalEncryptionException {
        if (cipher.length - cipherOff < this._cipherLength) {
            throw new IllegalEncryptionException("Output buffer too small < " + this._cipherLength);
        }
        byte[] out = this.encrypt(plain, plainOff, len);
        System.arraycopy(out, 0, cipher, cipherOff, out.length);
    }

    @Override
    public void decrypt(byte[] cipher, int cipherOff, byte[] plain, int plainOff, int len) throws IllegalEncryptionException {
        byte[] out = this.decrypt(cipher, cipherOff, len);
        if (out.length > plain.length - plainOff) {
            throw new IllegalEncryptionException("Output buffer too small < " + out.length);
        }
    }

    @Override
    public boolean canOneToOne() {
        return false;
    }

    @Override
    public byte[] getKeyDescriptor() {
        return new byte[16];
    }
}

