/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.BufferDescriptor;

public class BufferScheduler {
    private BufferDescriptor[] _fullArray;
    private BufferDescriptor[] _emptyArray;
    private BufferDescriptor[] _all;
    private int _nob;
    private int _bufferSize;
    private final Object _waitForFullLock = new Object();
    private final Object _waitForEmptyLock = new Object();
    private int _nextToPut;
    private int _nextToGet;
    private int _nextEmpty;

    public BufferScheduler(int nob, int bufferSize) {
        this._nob = nob;
        this._bufferSize = bufferSize;
        this._fullArray = new BufferDescriptor[this._nob];
        this._emptyArray = new BufferDescriptor[this._nob];
        this._all = new BufferDescriptor[this._nob];
        for (int i = 0; i < this._nob; ++i) {
            this._emptyArray[i] = this._all[i] = new BufferDescriptor(this._bufferSize, i);
        }
        this._nextEmpty = this._nob - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._nob; ++i) {
            sb.append("").append(this._all[i]).append("\n");
        }
        return sb.toString();
    }

    public BufferDescriptor getFullBuffer() throws InterruptedException {
        BufferDescriptor b = this.getFromFilled();
        b.setMode(3);
        return b;
    }

    public BufferDescriptor getEmptyBuffer() throws InterruptedException {
        BufferDescriptor b = this.getFromEmpty();
        b.setMode(2);
        return b;
    }

    public void release(BufferDescriptor b) {
        int mode = b.getMode();
        switch (mode) {
            case 2: {
                b.setMode(0);
                this.putToFilled(b);
                break;
            }
            case 3: {
                b.setMode(1);
                this.putToEmpty(b);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Mode for release : " + b.modeToString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToFilled(BufferDescriptor b) {
        Object object = this._waitForFullLock;
        synchronized (object) {
            this._fullArray[this._nextToPut++ % this._nob] = b;
            if (this._nextToPut - this._nextToGet == 1) {
                this._waitForFullLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferDescriptor getFromFilled() throws InterruptedException {
        Object object = this._waitForFullLock;
        synchronized (object) {
            while (this._nextToPut - this._nextToGet == 0) {
                this._waitForFullLock.wait();
            }
            return this._fullArray[this._nextToGet++ % this._nob];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferDescriptor getFromEmpty() throws InterruptedException {
        Object object = this._waitForEmptyLock;
        synchronized (object) {
            while (this._nextEmpty < 0) {
                this._waitForEmptyLock.wait();
            }
            return this._emptyArray[this._nextEmpty--];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToEmpty(BufferDescriptor b) {
        Object object = this._waitForEmptyLock;
        synchronized (object) {
            this._emptyArray[++this._nextEmpty] = b;
            if (this._nextEmpty == 0) {
                this._waitForEmptyLock.notifyAll();
            }
        }
    }
}

