/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.edb;

import dmg.util.edb.JdbmObjectInputStream;
import dmg.util.edb.JdbmObjectOutputStream;
import dmg.util.edb.JdbmSerializable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class JdbmBasic
implements JdbmSerializable {
    private static final long serialVersionUID = -4068127117713991402L;
    private String _string = "";
    private JdbmBasic _root;

    public JdbmBasic() {
    }

    public JdbmBasic(String s) {
        int n = s.indexOf(":");
        if (n < 0) {
            this._root = null;
            this._string = s;
        } else {
            this._root = new JdbmBasic(s.substring(n + 1));
            this._string = s.substring(0, n);
        }
    }

    @Override
    public void writeObject(ObjectOutput out) throws IOException {
        out.writeUTF(this._string);
        if (this._root == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeObject(this._root);
        }
    }

    @Override
    public void readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        this._string = in.readUTF();
        int flag = in.readInt();
        System.out.println("Got=" + this._string + ":" + flag);
        this._root = flag == 0 ? null : (JdbmBasic)in.readObject();
    }

    @Override
    public int getPersistentSize() {
        return 0;
    }

    public String toString() {
        if (this._root == null) {
            return this._string;
        }
        return this._string + ":" + this._root.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            JdbmBasic jdbm = new JdbmBasic("Otto");
            JdbmObjectOutputStream out = new JdbmObjectOutputStream(new DataOutputStream(new FileOutputStream("xxx")));
            out.writeObject(new JdbmBasic("otto:karl:waste"));
            out.close();
        } else {
            JdbmObjectInputStream in = new JdbmObjectInputStream(new DataInputStream(new FileInputStream("xxx")));
            try {
                while (true) {
                    JdbmBasic jdbm = (JdbmBasic)in.readObject();
                    System.out.println(jdbm.toString());
                }
            }
            catch (IOException ee) {
                in.close();
            }
        }
    }
}

