/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import com.google.common.net.HostAndPort;
import dmg.cells.network.LocationMgrTunnel;
import dmg.cells.nucleus.CellAdapter;
import dmg.util.DummyStreamEngine;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.dcache.alarms.AlarmMarkerFactory;
import org.dcache.alarms.PredefinedAlarm;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationManagerConnector
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger((String)"org.dcache.cells.network");
    private final String _domain;
    private final InetSocketAddress _address;
    private Thread _thread;
    private String _status = "disconnected";
    private int _retries;

    public LocationManagerConnector(String cellName, String args) {
        super(cellName, "System", args);
        Args a = this.getArgs();
        this._domain = a.getOpt("domain");
        HostAndPort where = HostAndPort.fromString((String)a.getOpt("where"));
        this._address = new InetSocketAddress(where.getHostText(), where.getPort());
    }

    @Override
    protected void started() {
        this._thread = this.getNucleus().newThread(this, "TunnelConnector");
        this._thread.start();
    }

    private synchronized void setStatus(String s) {
        this._status = s;
    }

    private synchronized String getStatus() {
        return this._status;
    }

    private StreamEngine connect() throws IOException, InterruptedException {
        Socket socket;
        this.setStatus("Connecting to " + this._address);
        try {
            socket = SocketChannel.open(this._address).socket();
        }
        catch (UnsupportedAddressTypeException e) {
            throw new IOException("Unsupported address type: " + this._address, e);
        }
        catch (UnresolvedAddressException e) {
            throw new IOException("Unable to resolve " + this._address, e);
        }
        catch (IOException e) {
            throw new IOException("Failed to connect to " + this._address + ": " + e.toString(), e);
        }
        socket.setKeepAlive(true);
        _log.info("Using clear text channel");
        return new DummyStreamEngine(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Args args = this.getArgs();
        String name = this.getCellName() + "*";
        Random random = new Random();
        try {
            while (true) {
                try {
                    ++this._retries;
                    LocationMgrTunnel tunnel = new LocationMgrTunnel(name, this.connect(), args);
                    try {
                        tunnel.start().get();
                        this._retries = 0;
                        this.setStatus("Connected");
                        this.getNucleus().join(tunnel.getCellName());
                    }
                    finally {
                        try {
                            this.getNucleus().kill(tunnel.getCellName());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
                catch (InterruptedIOException e) {
                    throw e;
                }
                catch (IOException | ExecutionException e) {
                    _log.warn(AlarmMarkerFactory.getMarker((PredefinedAlarm)PredefinedAlarm.LOCATION_MANAGER_FAILURE, (String[])new String[]{name, this._domain, e.getMessage()}), "Failed to connect to " + this._domain + ": " + e.getMessage());
                }
                this.setStatus("Sleeping");
                long sleep = random.nextInt(16000) + 4000;
                _log.warn("Sleeping " + sleep / 1000L + " seconds");
                Thread.sleep(sleep);
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    @Override
    public String toString() {
        return this.getStatus();
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("Location manager connector : " + this.getCellName());
        pw.println("Status   : " + this.getStatus());
        pw.println("Retries  : " + this._retries);
    }

    @Override
    public void cleanUp() {
        if (this._thread != null) {
            this._thread.interrupt();
        }
    }
}

