/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellDomainRole;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.util.StreamEngine;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.nio.channels.AsynchronousCloseException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.dcache.util.Args;
import org.dcache.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMgrTunnel
extends CellAdapter
implements CellTunnel,
Runnable {
    private static final Tunnels _tunnels = new Tunnels();
    private static final Logger _log = LoggerFactory.getLogger(LocationMgrTunnel.class);
    private final CellNucleus _nucleus;
    private CellDomainInfo _localDomainInfo;
    private CellDomainInfo _remoteDomainInfo;
    private boolean _allowForwardingOfRemoteMessages;
    private Thread _thread;
    private final Socket _socket;
    private final OutputStream _rawOut;
    private final InputStream _rawIn;
    private ObjectSource _input;
    private ObjectSink _output;
    private LongAdder _messagesToTunnel = new LongAdder();
    private LongAdder _messagesToSystem = new LongAdder();

    public LocationMgrTunnel(String cellName, StreamEngine engine, Args args) {
        super(cellName, "System", args);
        this._nucleus = this.getNucleus();
        this._socket = engine.getSocket();
        this._rawOut = new BufferedOutputStream(engine.getOutputStream());
        this._rawIn = new BufferedInputStream(engine.getInputStream());
        CellDomainRole role = args.hasOption("role") ? CellDomainRole.valueOf(args.getOption("role").toUpperCase()) : CellDomainRole.SATELLITE;
        this._localDomainInfo = new CellDomainInfo(this._nucleus.getCellDomainName(), Version.of(LocationMgrTunnel.class).getVersion(), role);
    }

    @Override
    protected void startUp() throws Exception {
        this._socket.setTcpNoDelay(true);
        this.handshake();
        _tunnels.add(this);
    }

    @Override
    protected void started() {
        this.installRoutes();
        this._thread = this._nucleus.newThread(this, "Tunnel");
        this._thread.start();
    }

    @Override
    public void cleanUp() {
        _log.info("Closing tunnel to {}", (Object)this.getRemoteDomainName());
        _tunnels.remove(this);
        try {
            try {
                this._socket.shutdownOutput();
                if (this._thread != null) {
                    this._thread.join(800L);
                }
            }
            catch (IOException e) {
                _log.debug("Failed to shutdown socket: {}", (Object)e.getMessage());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        finally {
            try {
                this._socket.close();
            }
            catch (IOException e) {
                _log.warn("Failed to close socket: {}", (Object)e.getMessage());
            }
        }
    }

    private void installRoutes() {
        String domain = this.getRemoteDomainName();
        CellNucleus nucleus = this.getNucleus();
        CellRoute route = new CellRoute(domain, nucleus.getThisAddress(), 3);
        try {
            nucleus.routeAdd(route);
        }
        catch (IllegalArgumentException e) {
            _log.warn("Failed to add route: {}", (Object)e.getMessage());
        }
    }

    private void handshake() throws IOException {
        try {
            ObjectOutputStream out = new ObjectOutputStream(this._rawOut);
            out.writeObject(this._localDomainInfo);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(this._rawIn);
            this._remoteDomainInfo = (CellDomainInfo)in.readObject();
            if (this._remoteDomainInfo == null) {
                throw new IOException("EOS encountered while reading DomainInfo");
            }
            this._allowForwardingOfRemoteMessages = this._remoteDomainInfo.getRole() != CellDomainRole.CORE;
            this._input = new JavaObjectSource(in);
            this._output = new JavaObjectSink(out);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot deserialize object. This is most likely due to a version mismatch.", e);
        }
        _log.debug("Established tunnel to {}", (Object)this.getRemoteDomainName());
    }

    @Override
    public void run() {
        try {
            CellMessage msg;
            while ((msg = this._input.readObject()) != null) {
                this.getNucleus().sendMessage(msg, true, this._allowForwardingOfRemoteMessages);
                this._messagesToSystem.increment();
            }
        }
        catch (EOFException | AsynchronousCloseException msg) {
        }
        catch (ClassNotFoundException e) {
            _log.warn("Cannot deserialize object. This is most likely due to a version mismatch.");
        }
        catch (IOException e) {
            _log.warn("Error while reading from tunnel: {}", (Object)e.toString());
        }
        finally {
            this.kill();
        }
    }

    @Override
    public void messageArrived(MessageEvent me) {
        if (me instanceof RoutedMessageEvent) {
            CellMessage msg = me.getMessage();
            try {
                this._messagesToTunnel.increment();
                this._output.writeObject(msg);
            }
            catch (IOException e) {
                _log.warn("Error while sending message: " + e.getMessage());
                CellMessage envelope = new CellMessage(msg.getSourcePath().revert(), (Serializable)new NoRouteToCellException(msg, "Communication failure. Message could not be delivered."));
                envelope.setLastUOID(msg.getUOID());
                this._nucleus.sendMessage(envelope, true, true);
                this.kill();
            }
        } else {
            super.messageArrived(me);
        }
    }

    @Override
    public CellTunnelInfo getCellTunnelInfo() {
        return new CellTunnelInfo(this.getNucleus().getThisAddress(), this._localDomainInfo, this._remoteDomainInfo);
    }

    private String getRemoteDomainName() {
        return this._remoteDomainInfo == null ? "" : this._remoteDomainInfo.getCellDomainName();
    }

    @Override
    public String toString() {
        return "Connected to " + this.getRemoteDomainName();
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("Tunnel        : " + this.getCellName());
        pw.println("Messages delivered to");
        pw.println("   Peer       : " + this._messagesToTunnel);
        pw.println("   Local      : " + this._messagesToSystem);
        pw.println("Local domain");
        pw.println("   Name       : " + this._localDomainInfo.getCellDomainName());
        pw.println("   Version    : " + this._localDomainInfo.getVersion());
        pw.println("   Role       : " + (Object)((Object)this._localDomainInfo.getRole()));
        pw.println("Peer domain");
        pw.println("   Name       : " + this._remoteDomainInfo.getCellDomainName());
        pw.println("   Version    : " + this._remoteDomainInfo.getVersion());
        pw.println("   Role       : " + (Object)((Object)this._remoteDomainInfo.getRole()));
    }

    private static class JavaObjectSink
    implements ObjectSink {
        private ObjectOutputStream out;

        private JavaObjectSink(ObjectOutputStream out) {
            this.out = out;
        }

        @Override
        public void writeObject(CellMessage message) throws IOException {
            this.out.writeObject(message);
            this.out.reset();
            this.out.flush();
        }
    }

    private static class JavaObjectSource
    implements ObjectSource {
        private ObjectInputStream in;

        private JavaObjectSource(ObjectInputStream in) {
            this.in = in;
        }

        @Override
        public CellMessage readObject() throws IOException, ClassNotFoundException {
            return (CellMessage)this.in.readObject();
        }
    }

    private static interface ObjectSink {
        public void writeObject(CellMessage var1) throws IOException;
    }

    private static interface ObjectSource {
        public CellMessage readObject() throws IOException, ClassNotFoundException;
    }

    private static class Tunnels {
        private Map<String, LocationMgrTunnel> _tunnels = new HashMap<String, LocationMgrTunnel>();

        private Tunnels() {
        }

        public synchronized void add(LocationMgrTunnel tunnel) throws InterruptedException {
            LocationMgrTunnel old;
            if (this._tunnels.containsValue(tunnel)) {
                throw new IllegalArgumentException("Cannot register the same tunnel twice");
            }
            String domain = tunnel.getRemoteDomainName();
            while ((old = this._tunnels.get(domain)) != null) {
                old.kill();
                this.wait();
            }
            this._tunnels.put(domain, tunnel);
            this.notifyAll();
        }

        public synchronized void remove(LocationMgrTunnel tunnel) {
            if (this._tunnels.remove(tunnel.getRemoteDomainName(), tunnel)) {
                this.notifyAll();
            }
        }
    }
}

