/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.nucleus.CellPath;
import java.io.Serializable;

public class PingMessage
implements Serializable {
    private static final long serialVersionUID = -2899727151648545028L;
    private final long _millis;
    private final byte[] _payload;
    private boolean _wayback;
    private CellPath _outboundPath;

    public PingMessage() {
        this(0);
    }

    public PingMessage(int payloadSize) {
        this._payload = new byte[payloadSize];
        this._millis = System.currentTimeMillis();
    }

    public void setWayBack() {
        this._wayback = true;
    }

    public boolean isWayBack() {
        return this._wayback;
    }

    public void setOutboundPath(CellPath path) {
        this._outboundPath = path.clone();
    }

    public CellPath getOutboundPath() {
        return this._outboundPath;
    }

    public long getTransferTime() {
        return System.currentTimeMillis() - this._millis;
    }

    public int getPayloadSize() {
        return this._payload.length;
    }

    public String toString() {
        return "Transfer Time = " + this.getTransferTime() + " (payload=" + this._payload.length + " bytes)";
    }
}

