/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.util.Objects;

public final class CellAddressCore
implements Cloneable,
Serializable,
Comparable<CellAddressCore> {
    private static final long serialVersionUID = 4072907109959708379L;
    private final String _domain;
    private final String _cell;

    public CellAddressCore(String addr) {
        int ind = addr.indexOf(64);
        if (ind < 0) {
            this._cell = addr;
            this._domain = "local";
        } else {
            this._cell = addr.substring(0, ind);
            this._domain = ind == addr.length() - 1 ? "local" : addr.substring(ind + 1);
        }
    }

    public CellAddressCore(String addr, String domain) {
        Preconditions.checkNotNull((Object)addr);
        this._cell = addr;
        this._domain = domain == null ? "local" : domain;
    }

    public String getCellName() {
        return this._cell;
    }

    public String getCellDomainName() {
        return this._domain;
    }

    public String toString() {
        return this._cell + "@" + this._domain;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CellAddressCore)) {
            return false;
        }
        CellAddressCore other = (CellAddressCore)obj;
        return other._domain.equals(this._domain) && other._cell.equals(this._cell);
    }

    public int hashCode() {
        return Objects.hash(this._cell, this._domain);
    }

    @Override
    public int compareTo(CellAddressCore other) {
        return ComparisonChain.start().compare((Comparable)((Object)this._cell), (Comparable)((Object)other._cell)).compare((Comparable)((Object)this._domain), (Comparable)((Object)other._domain)).result();
    }

    public boolean isDomainAddress() {
        return this._cell.equals("*");
    }

    public boolean isLocalAddress() {
        return this._domain.equals("local");
    }
}

