/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import dmg.cells.nucleus.CellDomainRole;
import dmg.util.Releases;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class CellDomainInfo
implements Serializable {
    private static final long serialVersionUID = 486982068268709272L;
    private final String _domainName;
    private final String _version;
    private CellDomainRole _role;

    public CellDomainInfo(String name, String version, CellDomainRole role) {
        this._domainName = (String)Preconditions.checkNotNull((Object)name);
        this._version = (String)Preconditions.checkNotNull((Object)version);
        this._role = (CellDomainRole)((Object)Preconditions.checkNotNull((Object)((Object)role)));
    }

    public String getVersion() {
        return this._version;
    }

    public short getRelease() {
        return Releases.getRelease(this._version);
    }

    public String getCellDomainName() {
        return this._domainName;
    }

    public CellDomainRole getRole() {
        return this._role;
    }

    public String toString() {
        return this._domainName + "," + this._version + "," + (Object)((Object)this._role);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._role == null) {
            this._role = CellDomainRole.SATELLITE;
        }
    }
}

