/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellVersion;
import java.io.Serializable;
import java.util.Date;

public class CellInfo
implements Serializable {
    private static final long serialVersionUID = 8837418209418282912L;
    private String _cellName = "Unknown";
    private String _cellType = "Unknown";
    private String _cellClass = "Unknown";
    private String _domainName = "Unknown";
    private Date _creationTime;
    private String _shortInfo = "NA";
    private String _privateInfo = "NA";
    private int _state;
    private int _eventQueueSize;
    private int _threadCount;
    private long _expectedQueueTime;
    private CellVersion _version = new CellVersion();
    private static final String[] _stateNames = new String[]{"Initial", "Active", "Removing", "Dead", "Unknown"};

    public CellInfo() {
    }

    public CellInfo(CellInfo info) {
        this._cellName = info._cellName;
        this._cellType = info._cellType;
        this._cellClass = info._cellClass;
        this._domainName = info._domainName;
        this._creationTime = info._creationTime;
        this._shortInfo = info._shortInfo;
        this._privateInfo = info._privateInfo;
        this._state = info._state;
        this._eventQueueSize = info._eventQueueSize;
        this._expectedQueueTime = info._expectedQueueTime;
        this._threadCount = info._threadCount;
        this._version = info._version;
    }

    public void setCellName(String name) {
        this._cellName = name;
    }

    public void setCellType(String type) {
        this._cellType = type;
    }

    public void setCellClass(String info) {
        this._cellClass = info;
    }

    public void setCellVersion(CellVersion version) {
        this._version = version;
    }

    public void setDomainName(String name) {
        this._domainName = name;
    }

    public void setCreationTime(Date date) {
        this._creationTime = date;
    }

    public void setPrivateInfo(String info) {
        this._privateInfo = info;
    }

    public void setShortInfo(String info) {
        this._shortInfo = info;
    }

    public void setEventQueueSize(int size) {
        this._eventQueueSize = size;
    }

    public void setExpectedQueueTime(long millis) {
        this._expectedQueueTime = millis;
    }

    public void setThreadCount(int threadCount) {
        this._threadCount = threadCount;
    }

    public void setState(int state) {
        this._state = state < 0 || this._state >= _stateNames.length ? _stateNames.length : state;
    }

    public int getState() {
        return this._state;
    }

    public String getStateName() {
        return _stateNames[this._state];
    }

    public String toString() {
        return CellInfo.f(this._cellName, 20) + CellInfo.f(_stateNames[this._state].substring(0, 1), 2) + CellInfo.f("" + this._eventQueueSize, 3) + CellInfo.f("" + this._threadCount, 3) + CellInfo.f(CellInfo.cutClass(this._cellClass), 20) + this._shortInfo;
    }

    public CellVersion getCellVersion() {
        return this._version;
    }

    public String getPrivatInfo() {
        return this._privateInfo;
    }

    public int getEventQueueSize() {
        return this._eventQueueSize;
    }

    public long getExpectedQueueTime() {
        return this._expectedQueueTime;
    }

    public String getCellName() {
        return this._cellName;
    }

    public String getCellType() {
        return this._cellType;
    }

    public String getCellClass() {
        return this._cellClass;
    }

    public String getShortInfo() {
        return this._shortInfo;
    }

    public Date getCreationTime() {
        return this._creationTime;
    }

    public String getDomainName() {
        return this._domainName;
    }

    public int getThreadCount() {
        return this._threadCount;
    }

    public static String f(String in, int field) {
        return CellInfo.f(in, field, 0);
    }

    public static String f(String in, int field, int flags) {
        if (in.length() >= field) {
            return in;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(in);
        int diff = field - in.length();
        for (int i = 0; i < diff; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String cutClass(String c) {
        int lastDot = c.lastIndexOf(46);
        if (lastDot < 0 || lastDot >= c.length() - 1) {
            return c;
        }
        return c.substring(lastDot + 1);
    }
}

