/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.UOID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CellMessage
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5559658187264201731L;
    private static final int TTL_BUFFER_MAXIMUM = 10000;
    private static final float TTL_BUFFER_FRACTION = 0.1f;
    private CellPath _source;
    private CellPath _destination;
    private Object _message;
    private long _creationTime;
    private long _ttl = Long.MAX_VALUE;
    private int _mode;
    private UOID _umid;
    private UOID _lastUmid;
    private byte[] _messageStream;
    private boolean _isPersistent;
    private Object _session;
    private static final int ORIGINAL_MODE = 0;
    private static final int STREAM_MODE = 1;
    private static final int DUMMY_MODE = 2;
    private transient long _receivedAt;

    public CellMessage(CellAddressCore address, Serializable msg) {
        this(msg, new CellPath(address));
    }

    public CellMessage(CellPath addr, Serializable msg) {
        this(msg, addr.clone());
    }

    private CellMessage(Serializable msg, CellPath path) {
        this._destination = path;
        this._message = msg;
        this._source = new CellPath();
        this._receivedAt = this._creationTime = System.currentTimeMillis();
        this._mode = 0;
        this._lastUmid = this._umid = new UOID();
        this._session = CDC.getSession();
        this._messageStream = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<CM: S=").append(this._source.toString()).append(";D=").append(this._destination.toString());
        if (this._mode == 0) {
            sb.append(";C=").append(this._message.getClass().getName());
        } else {
            sb.append(";C=Stream");
        }
        sb.append(";O=").append(this._umid).append(";LO=").append(this._lastUmid);
        if (this._session != null) {
            sb.append(";SID=").append(this._session);
        }
        if (this._ttl < Long.MAX_VALUE) {
            sb.append(";TTL=").append(this._ttl);
        }
        sb.append(">");
        return sb.toString();
    }

    public int hashCode() {
        return this._umid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CellMessage) {
            return ((CellMessage)obj)._umid.equals(this._umid);
        }
        if (obj instanceof UOID) {
            return obj.equals(this._umid);
        }
        return false;
    }

    public boolean isReply() {
        return this._isPersistent;
    }

    public UOID getUOID() {
        return this._umid;
    }

    public UOID getLastUOID() {
        return this._lastUmid;
    }

    public void setUOID(UOID umid) {
        this._umid = umid;
    }

    public void setLastUOID(UOID lastUOID) {
        this._lastUmid = lastUOID;
    }

    public Serializable getSession() {
        return (Serializable)this._session;
    }

    public void setSession(Serializable session) {
        this._session = session;
    }

    public void setTtl(long ttl) {
        this._ttl = ttl;
    }

    public long getTtl() {
        return this._ttl;
    }

    public CellAddressCore getSourceAddress() {
        return this._source.getSourceAddress();
    }

    public CellPath getDestinationPath() {
        return this._destination;
    }

    public CellPath getSourcePath() {
        return this._source;
    }

    public Serializable getMessageObject() {
        return (Serializable)this._message;
    }

    public void setMessageObject(Serializable obj) {
        Preconditions.checkState((this._mode == 0 ? 1 : 0) != 0);
        this._message = obj;
    }

    public void revertDirection() {
        Preconditions.checkState((!this._source.getSourceAddress().isDomainAddress() ? 1 : 0) != 0, (Object)"Cannot return envelope to a domain address.");
        this._destination = this._source.revert();
        this._source = new CellPath();
        this._lastUmid = this._umid;
        this._isPersistent = true;
    }

    public boolean isFinalDestination() {
        return this._destination.isFinalDestination();
    }

    public boolean isFirstDestination() {
        return this._destination.isFirstDestination();
    }

    public boolean nextDestination() {
        return this._destination.next();
    }

    boolean isStreamMode() {
        return this._mode == 1;
    }

    void touch() {
        if (this._destination.isFirstDestination()) {
            this._umid = new UOID();
            this._receivedAt = System.currentTimeMillis();
        }
    }

    public CellMessage() {
        this._mode = 2;
        this._messageStream = null;
    }

    public CellMessage clone() {
        try {
            CellMessage copy = (CellMessage)super.clone();
            copy._destination = this._destination.clone();
            if (this._source != null) {
                copy._source = this._source.clone();
            }
            copy._messageStream = this._messageStream;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public CellMessage encode() throws SerializationException {
        Preconditions.checkState((this._mode == 0 ? 1 : 0) != 0);
        CellMessage encoded = this.clone();
        encoded._mode = 1;
        encoded._message = null;
        encoded._messageStream = CellMessage.encode(this._message);
        return encoded;
    }

    public CellMessage decode() throws SerializationException {
        Preconditions.checkState((this._mode == 1 ? 1 : 0) != 0);
        CellMessage decoded = this.clone();
        decoded._mode = 0;
        decoded._messageStream = null;
        decoded._message = CellMessage.decode(this._messageStream);
        return decoded;
    }

    protected static byte[] encode(Object message) {
        int initialBufferSize = 256;
        ByteArrayOutputStream array = new ByteArrayOutputStream(initialBufferSize);
        try (ObjectOutputStream out = new ObjectOutputStream(array);){
            out.writeObject(message);
        }
        catch (InvalidClassException e) {
            throw new SerializationException("Failed to serialize object: " + e + "(this is usually a bug)", e);
        }
        catch (NotSerializableException e) {
            throw new SerializationException("Failed to serialize object because the object is not serializable (this is usually a bug)", e);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize object: " + e, e);
        }
        return array.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Object decode(byte[] messageStream) {
        try (ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(messageStream));){
            Object object = stream.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Failed to deserialize object: The class could not be found. Is there a software version mismatch in your installation?", e);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to deserialize object: " + e, e);
        }
    }

    public void addSourceAddress(CellAddressCore source) {
        this._source.add(source);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this._receivedAt = System.currentTimeMillis();
    }

    public long getLocalAge() {
        return System.currentTimeMillis() - this._receivedAt;
    }

    public long getAdjustedTtl() {
        return this._ttl == Long.MAX_VALUE ? Long.MAX_VALUE : this._ttl - Math.min(10000L, (long)((float)this._ttl * 0.1f));
    }
}

