/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellGlue;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellLock;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellRoutingTable;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.EventLogger;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.StartEvent;
import dmg.cells.nucleus.SystemCell;
import dmg.cells.nucleus.UOID;
import dmg.cells.zookeeper.CellCuratorFramework;
import dmg.util.Pinboard;
import dmg.util.logback.FilterThresholdSet;
import dmg.util.logback.RootFilterThresholds;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.curator.framework.CuratorFramework;
import org.dcache.util.BoundedCachedExecutor;
import org.dcache.util.BoundedExecutor;
import org.dcache.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CellNucleus
implements ThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellNucleus.class);
    private static final int PINBOARD_DEFAULT_SIZE = 200;
    private static final int INITIAL = 0;
    private static final int ACTIVE = 1;
    private static final int REMOVING = 2;
    private static final int DEAD = 3;
    private static CellGlue __cellGlue;
    private final String _cellName;
    private final String _cellType;
    private final ThreadGroup _threads;
    private final AtomicInteger _threadCounter = new AtomicInteger();
    private final Cell _cell;
    private final Date _creationTime = new Date();
    private final AtomicInteger _state = new AtomicInteger(0);
    private final Map<UOID, CellLock> _waitHash = new HashMap<UOID, CellLock>();
    private String _cellClass;
    private final BoundedExecutor _messageExecutor;
    private final AtomicInteger _eventQueueSize = new AtomicInteger();
    private static final Timer _timer;
    private final TimerTask _timeoutTask;
    private Pinboard _pinboard;
    private FilterThresholdSet _loggingThresholds;
    private final Queue<Runnable> _deferredTasks = Queues.synchronizedQueue(new ArrayDeque());
    private volatile long _lastQueueTime;
    private final CellCuratorFramework _curatorFramework;

    public CellNucleus(Cell cell, String name, String type, Executor executor) {
        String cellName;
        this.setPinboard(new Pinboard(200));
        if (cell instanceof SystemCell) {
            __cellGlue.setSystemNucleus(this);
        }
        if ((cellName = name.replace('@', '+')).isEmpty()) {
            cellName = "*";
        }
        if (cellName.charAt(cellName.length() - 1) == '*') {
            cellName = cellName.length() == 1 ? "$-" + this.getUnique() : cellName.substring(0, cellName.length() - 1) + "-" + this.getUnique();
        }
        this._cellName = cellName;
        this._cellType = type;
        this._cell = cell;
        this._cellClass = this._cell.getClass().getName();
        CellNucleus parentNucleus = CellNucleus.getLogTargetForCell(MDC.get((String)"cells.cell"));
        FilterThresholdSet parentThresholds = parentNucleus.isSystemNucleus() || parentNucleus == this ? RootFilterThresholds.getInstance() : parentNucleus.getLoggingThresholds();
        this.setLoggingThresholds(new FilterThresholdSet(parentThresholds));
        this._threads = new ThreadGroup(__cellGlue.getMasterThreadGroup(), this._cellName + "-threads");
        this._messageExecutor = executor == null ? new BoundedCachedExecutor((ThreadFactory)this, 1) : new BoundedExecutor(executor, 1);
        CuratorFramework curatorFramework = __cellGlue.getCuratorFramework();
        this._curatorFramework = curatorFramework != null ? new CellCuratorFramework(curatorFramework, (Executor)this._messageExecutor) : null;
        this._timeoutTask = new TimerTask(){

            @Override
            public void run() {
                try (CDC ignored = CDC.reset(CellNucleus.this);){
                    try {
                        CellNucleus.this.executeMaintenanceTasks();
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            }
        };
        LOGGER.info("Created {}", (Object)name);
    }

    public static CellNucleus getLogTargetForCell(String cell) {
        CellNucleus nucleus = null;
        if (__cellGlue != null) {
            if (cell != null) {
                nucleus = __cellGlue.getCell(cell);
            }
            if (nucleus == null) {
                nucleus = __cellGlue.getSystemNucleus();
            }
        }
        return nucleus;
    }

    public static void initCellGlue(String cellDomainName, CuratorFramework curatorFramework) {
        Preconditions.checkState((__cellGlue == null ? 1 : 0) != 0);
        __cellGlue = new CellGlue(cellDomainName, curatorFramework);
    }

    public static void shutdownCellGlue() {
        if (__cellGlue != null) {
            __cellGlue.shutdown();
        }
    }

    boolean isSystemNucleus() {
        return this == __cellGlue.getSystemNucleus();
    }

    public String getCellName() {
        return this._cellName;
    }

    public String getCellType() {
        return this._cellType;
    }

    public String getCellClass() {
        return this._cellClass;
    }

    public void setCellClass(String cellClass) {
        this._cellClass = cellClass;
    }

    public CellAddressCore getThisAddress() {
        return new CellAddressCore(this._cellName, __cellGlue.getCellDomainName());
    }

    public String getCellDomainName() {
        return __cellGlue.getCellDomainName();
    }

    public List<String> getCellNames() {
        return __cellGlue.getCellNames();
    }

    public CellInfo getCellInfo(String name) {
        return __cellGlue.getCellInfo(name);
    }

    public CellInfo getCellInfo() {
        return this._getCellInfo();
    }

    public Map<String, Object> getDomainContext() {
        return __cellGlue.getCellContext();
    }

    public Reader getDomainContextReader(String contextName) throws FileNotFoundException {
        Object o = __cellGlue.getCellContext(contextName);
        if (o == null) {
            throw new FileNotFoundException("Context not found : " + contextName);
        }
        return new StringReader(o.toString());
    }

    public void setDomainContext(String contextName, Object context) {
        __cellGlue.getCellContext().put(contextName, context);
    }

    public Object getDomainContext(String str) {
        return __cellGlue.getCellContext(str);
    }

    Cell getThisCell() {
        return this._cell;
    }

    CellInfo _getCellInfo() {
        CellInfo info = new CellInfo();
        info.setCellName(this.getCellName());
        info.setDomainName(this.getCellDomainName());
        info.setCellType(this.getCellType());
        info.setCreationTime(this._creationTime);
        try {
            info.setCellVersion(this._cell.getCellVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setPrivateInfo(this._cell.getInfo());
        }
        catch (Exception e) {
            info.setPrivateInfo("Not yet/No more available\n");
        }
        try {
            info.setShortInfo(this._cell.toString());
        }
        catch (Exception e) {
            info.setShortInfo("Not yet/No more available");
        }
        info.setCellClass(this._cellClass);
        try {
            int eventQueueSize = this.getEventQueueSize();
            info.setEventQueueSize(eventQueueSize);
            info.setExpectedQueueTime(eventQueueSize == 0 ? 0L : this._lastQueueTime);
            info.setState(this._state.get());
            info.setThreadCount(this._threads.activeCount());
        }
        catch (Exception e) {
            info.setEventQueueSize(0);
            info.setState(0);
            info.setThreadCount(0);
        }
        return info;
    }

    public void setLoggingThresholds(FilterThresholdSet thresholds) {
        this._loggingThresholds = thresholds;
    }

    public FilterThresholdSet getLoggingThresholds() {
        return this._loggingThresholds;
    }

    public synchronized void setPinboard(Pinboard pinboard) {
        this._pinboard = pinboard;
    }

    public synchronized Pinboard getPinboard() {
        return this._pinboard;
    }

    public void setMaximumPoolSize(int size) {
        this._messageExecutor.setMaximumPoolSize(size);
    }

    public int getMaximumPoolSize() {
        return this._messageExecutor.getMaximumPoolSize();
    }

    public void setMaximumQueueSize(int size) {
        this._messageExecutor.setMaximumQueueSize(size);
    }

    public int getMaximumQueueSize() {
        return this._messageExecutor.getMaximumQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(CellMessage msg, boolean locally, boolean remotely) throws SerializationException {
        if (!msg.isStreamMode()) {
            msg.touch();
            msg.addSourceAddress(this.getThisAddress());
        }
        EventLogger.sendBegin(this, msg, "async");
        try {
            __cellGlue.sendMessage(msg, locally, remotely);
        }
        finally {
            EventLogger.sendEnd(msg);
        }
    }

    public CellMessage sendAndWait(CellMessage envelope, long timeout) throws SerializationException, NoRouteToCellException, InterruptedException, ExecutionException {
        final SettableFuture future = SettableFuture.create();
        this.sendMessage(envelope, true, true, new CellMessageAnswerable(){

            @Override
            public void answerArrived(CellMessage request, CellMessage answer) {
                future.set((Object)answer);
            }

            @Override
            public void exceptionArrived(CellMessage request, Exception exception) {
                future.setException((Throwable)exception);
            }

            @Override
            public void answerTimedOut(CellMessage request) {
                future.set(null);
            }
        }, MoreExecutors.directExecutor(), timeout);
        try {
            return (CellMessage)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), NoRouteToCellException.class);
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), SerializationException.class);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UOID, CellLock> getWaitQueue() {
        Map<UOID, CellLock> map = this._waitHash;
        synchronized (map) {
            return new HashMap<UOID, CellLock>(this._waitHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeMaintenanceTasks() {
        int size;
        ArrayList<CellLock> expired = new ArrayList<CellLock>();
        long now = System.currentTimeMillis();
        Iterator iterator = this._waitHash;
        synchronized (iterator) {
            Iterator<CellLock> i = this._waitHash.values().iterator();
            while (i.hasNext()) {
                CellLock lock = i.next();
                if (lock.getTimeout() >= now) continue;
                expired.add(lock);
                i.remove();
            }
            size = this._waitHash.size();
        }
        for (CellLock lock : expired) {
            CDC ignored = lock.getCdc().restore();
            Throwable throwable = null;
            try {
                try {
                    lock.getExecutor().execute(() -> {
                        CellMessage envelope = lock.getMessage();
                        try {
                            lock.getCallback().answerTimedOut(envelope);
                            EventLogger.sendEnd(envelope);
                        }
                        catch (RejectedExecutionException e) {
                            Map<UOID, CellLock> map = this._waitHash;
                            synchronized (map) {
                                this._waitHash.put(envelope.getUOID(), lock);
                            }
                            LOGGER.warn("Failed to invoke callback: {}", (Object)e.toString());
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    Map<UOID, CellLock> map = this._waitHash;
                    synchronized (map) {
                        this._waitHash.put(lock.getMessage().getUOID(), lock);
                    }
                    LOGGER.warn("Failed to invoke callback: {}", (Object)e.toString());
                }
                catch (RuntimeException e) {
                    Thread t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, e);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        for (Runnable task : Iterables.consumingIterable(this._deferredTasks)) {
            task.run();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(CellMessage msg, boolean local, boolean remote, CellMessageAnswerable callback, Executor executor, long timeout) throws SerializationException {
        if (!msg.isStreamMode()) {
            msg.touch();
            msg.addSourceAddress(this.getThisAddress());
        }
        msg.setTtl(timeout);
        UOID uoid = msg.getUOID();
        CellLock lock = new CellLock(msg, callback, executor, timeout);
        EventLogger.sendBegin(this, msg, "callback");
        Map<UOID, CellLock> map = this._waitHash;
        synchronized (map) {
            this._waitHash.put(uoid, lock);
        }
        try {
            __cellGlue.sendMessage(msg, local, remote);
        }
        catch (SerializationException e) {
            Map<UOID, CellLock> map2 = this._waitHash;
            synchronized (map2) {
                this._waitHash.remove(uoid);
            }
            EventLogger.sendEnd(msg);
            throw e;
        }
        catch (RuntimeException e) {
            Map<UOID, CellLock> map3 = this._waitHash;
            synchronized (map3) {
                this._waitHash.remove(uoid);
            }
            try {
                executor.execute(() -> {
                    try {
                        callback.exceptionArrived(msg, e);
                        EventLogger.sendEnd(msg);
                    }
                    catch (RejectedExecutionException e1) {
                        Map<UOID, CellLock> map = this._waitHash;
                        synchronized (map) {
                            this._waitHash.put(uoid, lock);
                        }
                        LOGGER.error("Failed to invoke callback: {}", (Object)e1.toString());
                    }
                });
            }
            catch (RejectedExecutionException e1) {
                Map<UOID, CellLock> map4 = this._waitHash;
                synchronized (map4) {
                    this._waitHash.put(uoid, lock);
                }
                LOGGER.error("Failed to invoke callback: {}", (Object)e1.toString());
            }
        }
    }

    public void addCellEventListener(final CellEventListener listener) {
        __cellGlue.addCellEventListener(this, new CellEventListener(){

            @Override
            public void cellCreated(CellEvent ce) {
                try (CDC ignored = CDC.reset(CellNucleus.this);){
                    listener.cellCreated(ce);
                }
            }

            @Override
            public void cellDied(CellEvent ce) {
                try (CDC ignored = CDC.reset(CellNucleus.this);){
                    listener.cellDied(ce);
                }
            }

            @Override
            public void routeAdded(CellEvent ce) {
                try (CDC ignored = CDC.reset(CellNucleus.this);){
                    listener.routeAdded(ce);
                }
            }

            @Override
            public void routeDeleted(CellEvent ce) {
                try (CDC ignored = CDC.reset(CellNucleus.this);){
                    listener.routeDeleted(ce);
                }
            }
        });
    }

    public void consume(String queue) {
        __cellGlue.consume(this, queue);
    }

    public void subscribe(String topic) {
        __cellGlue.subscribe(this, topic);
    }

    public void kill() {
        __cellGlue.kill(this);
    }

    public void kill(String cellName) throws IllegalArgumentException {
        __cellGlue.kill(this, cellName);
    }

    public void listThreadGroupOf(String cellName) {
        __cellGlue.threadGroupList(cellName);
    }

    public void threadGroupList() {
        Thread[] threads = new Thread[this._threads.activeCount()];
        int n = this._threads.enumerate(threads);
        for (int i = 0; i < n; ++i) {
            Thread thread = threads[i];
            LOGGER.warn("Thread: {} [{}{}{}] ({}) {}", new Object[]{thread.getName(), thread.isAlive() ? "A" : "-", thread.isDaemon() ? "D" : "-", thread.isInterrupted() ? "I" : "-", thread.getPriority(), thread.getState()});
            for (StackTraceElement s : thread.getStackTrace()) {
                LOGGER.warn("    {}", (Object)s);
            }
        }
    }

    public boolean join(String cellName) throws InterruptedException {
        return __cellGlue.join(cellName, 0L);
    }

    public boolean join(String cellName, long timeout) throws InterruptedException {
        return __cellGlue.join(cellName, timeout);
    }

    private Collection<Thread> getNonDaemonThreads(ThreadGroup group) {
        Thread[] threads = new Thread[group.activeCount()];
        int count = group.enumerate(threads);
        ArrayList<Thread> nonDaemonThreads = new ArrayList<Thread>(count);
        for (int i = 0; i < count; ++i) {
            Thread thread = threads[i];
            if (thread.isDaemon()) continue;
            nonDaemonThreads.add(thread);
        }
        return nonDaemonThreads;
    }

    private boolean joinThreads(Collection<Thread> threads, long timeout) throws InterruptedException {
        long deadline = MathUtils.addWithInfinity((long)System.currentTimeMillis(), (long)timeout);
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            long wait = MathUtils.subWithInfinity((long)deadline, (long)System.currentTimeMillis());
            if (wait <= 0L) {
                return false;
            }
            thread.join(wait);
            if (!thread.isAlive()) continue;
            return false;
        }
        return true;
    }

    private void killThreads(Collection<Thread> threads) {
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            LOGGER.debug("killerThread : interrupting {}", (Object)thread.getName());
            thread.interrupt();
        }
    }

    private Runnable wrapLoggingContext(Runnable runnable) {
        return () -> {
            try (CDC ignored = CDC.reset(this);){
                runnable.run();
            }
        };
    }

    private <T> Callable<T> wrapLoggingContext(Callable<T> callable) {
        return () -> {
            try (CDC ignored = CDC.reset(this);){
                Object v = callable.call();
                return v;
            }
        };
    }

    <T> Future<T> invokeOnMessageThread(Callable<T> task) {
        return this._messageExecutor.submit(this.wrapLoggingContext(task));
    }

    Future<?> invokeOnMessageThread(Runnable task) {
        return this._messageExecutor.submit(this.wrapLoggingContext(task));
    }

    void invokeLater(Runnable runnable) {
        this._deferredTasks.add(runnable);
    }

    @Override
    @Nonnull
    public Thread newThread(@Nonnull Runnable target) {
        return this.newThread(target, this.getCellName() + "-" + this._threadCounter.getAndIncrement());
    }

    @Nonnull
    public Thread newThread(@Nonnull Runnable target, @Nonnull String name) {
        return new Thread(this._threads, this.wrapLoggingContext(target), name);
    }

    Thread[] getThreads(String cellName) {
        return __cellGlue.getThreads(cellName);
    }

    public ThreadGroup getThreadGroup() {
        return this._threads;
    }

    Thread[] getThreads() {
        if (this._threads == null) {
            return new Thread[0];
        }
        int threadCount = this._threads.activeCount();
        Thread[] list = new Thread[threadCount];
        int rc = this._threads.enumerate(list);
        if (rc == list.length) {
            return list;
        }
        Thread[] ret = new Thread[rc];
        System.arraycopy(list, 0, ret, 0, rc);
        return ret;
    }

    private String getUnique() {
        return __cellGlue.getUnique();
    }

    int getEventQueueSize() {
        return this._eventQueueSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToEventQueue(MessageEvent ce) {
        CellLock lock;
        CellMessage msg = ce.getMessage();
        LOGGER.trace("addToEventQueue : message arrived : {}", (Object)msg);
        Map<UOID, CellLock> map = this._waitHash;
        synchronized (map) {
            lock = this._waitHash.remove(msg.getLastUOID());
        }
        if (lock != null) {
            LOGGER.trace("addToEventQueue : lock found for : {}", (Object)msg);
            try {
                this._eventQueueSize.incrementAndGet();
                lock.getExecutor().execute(new CallbackTask(lock, msg));
            }
            catch (RejectedExecutionException e) {
                this._eventQueueSize.decrementAndGet();
                Map<UOID, CellLock> map2 = this._waitHash;
                synchronized (map2) {
                    this._waitHash.put(msg.getLastUOID(), lock);
                }
                LOGGER.error("Dropping reply: {}", (Object)e.getMessage());
            }
        } else {
            if (this._eventQueueSize.get() == 0) {
                this._lastQueueTime = 0L;
            } else if (!msg.isReply()) {
                long queueTime = this._lastQueueTime;
                if (msg.getTtl() < queueTime) {
                    CellMessage envelope = new CellMessage(msg.getSourcePath().revert(), (Serializable)new NoRouteToCellException(msg, this.getCellName() + "@" + this.getCellDomainName() + " is busy (its estimated response time of " + queueTime + " ms is longer than the message TTL of " + msg.getTtl() + " ms)."));
                    envelope.setLastUOID(msg.getUOID());
                    this.sendMessage(envelope, true, true);
                }
            }
            try {
                EventLogger.queueBegin(ce);
                this._eventQueueSize.incrementAndGet();
                this._messageExecutor.execute((Runnable)new DeliverMessageTask(ce));
            }
            catch (RejectedExecutionException e) {
                EventLogger.queueEnd(ce);
                this._eventQueueSize.decrementAndGet();
                LOGGER.error("Dropping message: {}", (Object)e.getMessage());
            }
        }
    }

    public ListenableFuture<Void> start() {
        Preconditions.checkState((boolean)this._state.compareAndSet(0, 1));
        return Futures.catchingAsync((ListenableFuture)this._messageExecutor.submit(this.wrapLoggingContext(this::doStart)), Exception.class, e -> {
            this.shutdown(new KillEvent(new CellPath(this._cellName), 0L));
            throw e;
        });
    }

    private Void doStart() throws Exception {
        _timer.schedule(this._timeoutTask, 20000L, 20000L);
        StartEvent event = new StartEvent(new CellPath(this._cellName), 0L);
        this._cell.prepareStartup(event);
        __cellGlue.addCell(this._cellName, this);
        try {
            this._cell.postStartup(event);
        }
        catch (RuntimeException e) {
            LOGGER.error("Cell post startup callback failed: " + e);
        }
        return null;
    }

    void shutdown(KillEvent event) {
        try (CDC ignored = CDC.reset(this);){
            LOGGER.trace("Received {}", (Object)event);
            Preconditions.checkState((this._state.compareAndSet(0, 2) || this._state.compareAndSet(1, 2) ? 1 : 0) != 0);
            if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this._messageExecutor, (long)2L, (TimeUnit)TimeUnit.SECONDS)) {
                LOGGER.warn("Failed to flush message queue during shutdown.");
            }
            if (this._timeoutTask != null) {
                this._timeoutTask.cancel();
            }
            try {
                this._cell.prepareRemoval(event);
            }
            catch (Throwable e) {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
            }
            LOGGER.debug("Waiting for all threads in {} to finish", (Object)this._threads);
            try {
                Collection<Thread> threads = this.getNonDaemonThreads(this._threads);
                while (!this.joinThreads(threads, 1000L)) {
                    this.killThreads(threads);
                }
                this._threads.destroy();
            }
            catch (IllegalThreadStateException e) {
                this._threads.setDaemon(true);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for threads");
            }
            __cellGlue.destroy(this);
            this._state.set(3);
        }
    }

    public void routeAdd(CellRoute route) throws IllegalArgumentException {
        __cellGlue.routeAdd(route);
    }

    public void routeDelete(CellRoute route) throws IllegalArgumentException {
        __cellGlue.routeDelete(route);
    }

    CellRoute routeFind(CellAddressCore addr) {
        return __cellGlue.getRoutingTable().find(addr, true);
    }

    public CellRoutingTable getRoutingTable() {
        return __cellGlue.getRoutingTable();
    }

    public CellRoute[] getRoutingList() {
        return __cellGlue.getRoutingList();
    }

    public List<CellTunnelInfo> getCellTunnelInfos() {
        return __cellGlue.getCellTunnelInfos();
    }

    public CuratorFramework getCuratorFramework() {
        return this._curatorFramework;
    }

    static {
        _timer = new Timer("Cell maintenance task timer", true);
    }

    private class DeliverMessageTask
    implements Runnable {
        private final MessageEvent _event;

        public DeliverMessageTask(MessageEvent event) {
            this._event = event;
        }

        @Override
        public void run() {
            block18: {
                try (CDC ignored = CDC.reset(CellNucleus.this);){
                    try {
                        EventLogger.queueEnd(this._event);
                        CellNucleus.this._lastQueueTime = this._event.getMessage().getLocalAge();
                        CellNucleus.this._eventQueueSize.decrementAndGet();
                        if (this._event instanceof RoutedMessageEvent) {
                            CellNucleus.this._cell.messageArrived(this._event);
                            break block18;
                        }
                        CDC.setMessageContext(this._event.getMessage());
                        try {
                            CellNucleus.this._cell.messageArrived(this._event);
                        }
                        catch (RuntimeException e) {
                            CellMessage msg = this._event.getMessage();
                            if (!msg.isReply()) {
                                msg.revertDirection();
                                msg.setMessageObject(e);
                                CellNucleus.this.sendMessage(msg, true, true);
                            }
                            throw e;
                        }
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            }
        }

        public String toString() {
            return "Delivery-of-" + this._event;
        }
    }

    private class CallbackTask
    implements Runnable {
        private final CellLock _lock;
        private final CellMessage _message;

        public CallbackTask(CellLock lock, CellMessage message) {
            this._lock = lock;
            this._message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CellNucleus.this._eventQueueSize.decrementAndGet();
            try (CDC ignored = this._lock.getCdc().restore();){
                try {
                    CellMessageAnswerable callback = this._lock.getCallback();
                    CellMessage request = this._lock.getMessage();
                    try {
                        Serializable obj = this._message.getMessageObject();
                        if (obj instanceof Exception) {
                            callback.exceptionArrived(request, (Exception)obj);
                        } else {
                            callback.answerArrived(request, this._message);
                        }
                        EventLogger.sendEnd(request);
                    }
                    catch (RejectedExecutionException e) {
                        Map map = CellNucleus.this._waitHash;
                        synchronized (map) {
                            CellNucleus.this._waitHash.put(request.getUOID(), this._lock);
                        }
                        LOGGER.error("Failed to invoke callback: {}", (Object)e.toString());
                    }
                    LOGGER.trace("addToEventQueue : callback done for : {}", (Object)this._message);
                }
                catch (Throwable e) {
                    Thread t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, e);
                }
            }
        }

        public String toString() {
            return "Delivery-of-" + this._message;
        }
    }
}

