/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import dmg.cells.nucleus.CellAddressCore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.dcache.util.Args;

public class CellRoute
implements Serializable {
    private static final long serialVersionUID = 4566260400288960984L;
    private final String _destCell;
    private final String _destDomain;
    private final String _gateway;
    private final int _type;
    public static final int AUTO = 0;
    public static final int EXACT = 1;
    public static final int QUEUE = 2;
    public static final int DOMAIN = 3;
    public static final int DEFAULT = 4;
    public static final int DUMPSTER = 5;
    public static final int ALIAS = 6;
    public static final int TOPIC = 7;
    private static final String[] TYPE_NAMES = new String[]{"Auto", "Exact", "Queue", "Domain", "Default", "Dumpster", "Alias", "Topic"};

    private static int getTypeOf(Args args) {
        if (args.argc() == 0) {
            throw new IllegalArgumentException("Not enough arguments");
        }
        String opt = args.optc() == 0 ? "-auto" : args.optv(0);
        int type = 0;
        switch (opt) {
            case "auto": {
                type = 0;
                break;
            }
            case "domain": {
                type = 3;
                break;
            }
            case "wellknown": 
            case "queue": {
                type = 2;
                break;
            }
            case "exact": {
                type = 1;
                break;
            }
            case "default": {
                type = 4;
                break;
            }
            case "dumpster": {
                type = 5;
                break;
            }
            case "alias": {
                type = 6;
                break;
            }
            case "topic": {
                type = 7;
            }
        }
        switch (args.argc()) {
            case 1: {
                if (type == 4 || type == 5) break;
                throw new IllegalArgumentException("Not enough arguments");
            }
            case 2: {
                if (type != 4 && type != 5) break;
                throw new IllegalArgumentException("Too many arguments");
            }
            default: {
                throw new IllegalArgumentException("Too many arguments");
            }
        }
        return type;
    }

    private static int getTypeOf(String type) {
        int i = Arrays.asList(TYPE_NAMES).indexOf(type);
        if (i == -1) {
            throw new IllegalArgumentException("Illegal Route Type: " + type);
        }
        return i;
    }

    public CellRoute(Args args) throws IllegalArgumentException {
        this(args.argc() != 2 ? null : args.argv(0), args.argc() != 2 ? args.argv(0) : args.argv(1), CellRoute.getTypeOf(args));
    }

    public CellRoute(String dest, CellAddressCore gateway, int type) throws IllegalArgumentException {
        this(dest, gateway.toString(), type);
    }

    public CellRoute(String dest, String gateway, String type) throws IllegalArgumentException {
        this(dest, gateway, CellRoute.getTypeOf(type));
    }

    public CellRoute(String dest, String gateway, int type) throws IllegalArgumentException {
        String domain;
        String cell;
        this._gateway = gateway;
        if (dest == null || dest.isEmpty()) {
            cell = null;
            domain = null;
        } else {
            int ind = dest.indexOf(64);
            if (ind < 0) {
                cell = dest;
                domain = null;
            } else {
                cell = dest.substring(0, ind);
                domain = ind == dest.length() - 1 ? null : dest.substring(ind + 1);
            }
        }
        switch (type) {
            case 1: 
            case 6: {
                Preconditions.checkArgument((cell != null ? 1 : 0) != 0, (Object)"No destination cell spec.");
                this._destCell = cell;
                this._destDomain = domain == null ? "local" : domain;
                this._type = type;
                break;
            }
            case 2: {
                Preconditions.checkArgument((cell != null ? 1 : 0) != 0, (Object)"No destination cell spec.");
                Preconditions.checkArgument((domain == null ? 1 : 0) != 0, (Object)"QUEUE doesn't accept domain");
                this._destCell = cell;
                this._destDomain = "*";
                this._type = type;
                break;
            }
            case 7: {
                Preconditions.checkArgument((cell != null ? 1 : 0) != 0, (Object)"No destination cell spec.");
                Preconditions.checkArgument((domain == null ? 1 : 0) != 0, (Object)"TOPIC doesn't accept domain");
                this._destCell = cell;
                this._destDomain = "*";
                this._type = type;
                break;
            }
            case 3: {
                Preconditions.checkArgument((domain == null ? 1 : 0) != 0, (Object)"DOMAIN doesn't accept cell");
                Preconditions.checkArgument((cell != null ? 1 : 0) != 0, (Object)"No destination domain spec.");
                this._destDomain = cell;
                this._destCell = "*";
                this._type = type;
                break;
            }
            case 5: {
                Preconditions.checkArgument((cell == null ? 1 : 0) != 0, (Object)"DUMPSTER doesn't accept cell");
                Preconditions.checkArgument((domain == null ? 1 : 0) != 0, (Object)"DUMPSTER doesn't accept domain");
                this._destDomain = "*";
                this._destCell = "*";
                this._type = type;
                break;
            }
            case 4: {
                Preconditions.checkArgument((cell == null ? 1 : 0) != 0, (Object)"DEFAULT doesn't accept cell");
                Preconditions.checkArgument((domain == null ? 1 : 0) != 0, (Object)"DEFAULT doesn't accept domain");
                this._destDomain = "*";
                this._destCell = "*";
                this._type = type;
                break;
            }
            case 0: {
                if (cell != null && domain != null) {
                    this._type = cell.equals("*") && domain.equals("*") ? 4 : (cell.equals("*") ? 3 : (domain.equals("*") ? 2 : 1));
                    this._destCell = cell;
                    this._destDomain = domain;
                    break;
                }
                if (domain != null) {
                    this._destCell = "*";
                    this._destDomain = domain;
                    this._type = 3;
                    break;
                }
                if (cell != null) {
                    this._destCell = cell;
                    this._destDomain = "*";
                    this._type = 2;
                    break;
                }
                this._destCell = "*";
                this._destDomain = "*";
                this._type = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Route type");
            }
        }
    }

    public String getCellName() {
        return this._destCell;
    }

    public String getDomainName() {
        return this._destDomain;
    }

    public String getTargetName() {
        return this._gateway;
    }

    public int getRouteType() {
        return this._type;
    }

    public CellAddressCore getTarget() {
        return new CellAddressCore(this._gateway);
    }

    public String getRouteTypeName() {
        return TYPE_NAMES[this._type];
    }

    public int hashCode() {
        return this._type ^ Objects.hash(this._destCell, this._destDomain, this._gateway);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CellRoute)) {
            return false;
        }
        CellRoute route = (CellRoute)o;
        return route._destCell.equals(this._destCell) && route._destDomain.equals(this._destDomain) && route._gateway.equals(this._gateway) && route._type == this._type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cell", (Object)this.getCellName()).add("domain", (Object)this.getDomainName()).add("gateway", (Object)this.getTargetName()).add("type", (Object)this.getRouteTypeName()).toString();
    }
}

