/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellDomainRole;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.FutureCellMessageAnswerable;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.CoreRouteUpdate;
import dmg.cells.services.GetAllDomainsReply;
import dmg.cells.services.GetAllDomainsRequest;
import dmg.cells.services.PeerShutdownNotification;
import dmg.cells.services.TopicRouteUpdate;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreRoutingManager
extends CellAdapter
implements CellEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(CoreRoutingManager.class);
    private final CellNucleus nucleus;
    private final Multimap<String, String> localConsumers = HashMultimap.create();
    private final Multimap<String, String> localSubscriptions = HashMultimap.create();
    private final CellDomainRole role;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(this.getNucleus());
    private final ConcurrentMap<String, CoreRouteUpdate> updates = new ConcurrentHashMap<String, CoreRouteUpdate>();
    private final ConcurrentMap<String, List<String>> legacyWellknownUpdates = new ConcurrentHashMap<String, List<String>>();
    private final ConcurrentMap<String, Collection<String>> legacyTopicUpdates = new ConcurrentHashMap<String, Collection<String>>();
    private final Multimap<String, String> topicRoutes = HashMultimap.create();
    private final Multimap<String, String> queueRoutes = HashMultimap.create();
    private final Map<CellAddressCore, CellTunnelInfo> coreTunnels = new HashMap<CellAddressCore, CellTunnelInfo>();
    private final Map<CellAddressCore, CellTunnelInfo> satelliteTunnels = new HashMap<CellAddressCore, CellTunnelInfo>();
    private final Map<CellAddressCore, CellTunnelInfo> legacyTunnels = new HashMap<CellAddressCore, CellTunnelInfo>();
    private final List<CellRoute> delayedDefaultRoutes = new ArrayList<CellRoute>();
    private volatile CellAdapter canary;
    public static final String hh_ls = "[-x]";

    public CoreRoutingManager(String name, String arguments) {
        super(name, "System", arguments);
        this.nucleus = this.getNucleus();
        this.nucleus.addCellEventListener(this);
        this.role = this.getArgs().hasOption("role") ? CellDomainRole.valueOf(this.getArgs().getOption("role").toUpperCase()) : CellDomainRole.SATELLITE;
    }

    @Override
    protected void startUp() throws ExecutionException, InterruptedException {
        if (this.role == CellDomainRole.CORE) {
            this.canary = new CellAdapter(this.getCellName() + "-canary", "Generic", ""){

                @Override
                protected void cleanUp() {
                    CoreRoutingManager.this.notifyDownstreamOfDomainDeath();
                }

                @Override
                public void getInfo(PrintWriter pw) {
                    pw.println("If I die, downstream domains will drop their default routes to my domain.");
                }
            };
            this.canary.start().get();
        }
    }

    private synchronized void notifyDownstreamOfDomainDeath() {
        this.canary = null;
        try {
            this.sendToPeers(new PeerShutdownNotification(this.getCellDomainName()), this.satelliteTunnels.values(), 1000L).get();
        }
        catch (ExecutionException e) {
            LOG.info("Failed to notify downstream of shutdown: {}", (Object)e.toString());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void cleanUp() {
        CellAdapter canary = this.canary;
        if (canary != null) {
            try {
                this.getNucleus().kill(canary.getCellName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.executor.shutdown();
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        pw.println("Local consumers: ");
        this.println(pw, this.localConsumers);
        pw.println();
        pw.println("Local subscriptions:");
        this.println(pw, this.localSubscriptions);
        pw.println();
        pw.println("Managed topic routes:");
        this.println(pw, this.topicRoutes);
        pw.println();
        pw.println("Managed well-known routes:");
        this.println(pw, this.queueRoutes);
    }

    private void println(PrintWriter pw, Multimap<String, String> map) {
        for (Map.Entry e : map.asMap().entrySet()) {
            pw.append(" ").append((CharSequence)e.getKey()).append(" : ").println(e.getValue());
        }
    }

    private synchronized void sendToCoreDomains() {
        this.sendToPeers(new CoreRouteUpdate(this.localConsumers.values(), this.localSubscriptions.values()), this.coreTunnels.values());
    }

    private synchronized void sendToSatelliteDomains() {
        this.sendToPeers(new CoreRouteUpdate(this.localConsumers.values()), this.satelliteTunnels.values());
    }

    private void sendToPeers(Serializable msg, Collection<CellTunnelInfo> tunnels) {
        CellAddressCore peer = new CellAddressCore(this.nucleus.getCellName());
        for (CellTunnelInfo tunnel : tunnels) {
            CellAddressCore domain = new CellAddressCore("*", tunnel.getRemoteCellDomainInfo().getCellDomainName());
            this.nucleus.sendMessage(new CellMessage(new CellPath(domain, peer), msg), false, true);
        }
    }

    private ListenableFuture<List<CellMessage>> sendToPeers(Serializable msg, Collection<CellTunnelInfo> tunnels, long timeout) {
        ArrayList<FutureCellMessageAnswerable> futures = new ArrayList<FutureCellMessageAnswerable>();
        CellAddressCore peer = new CellAddressCore(this.nucleus.getCellName());
        for (CellTunnelInfo tunnel : tunnels) {
            CellAddressCore domain = new CellAddressCore("*", tunnel.getRemoteCellDomainInfo().getCellDomainName());
            FutureCellMessageAnswerable future = new FutureCellMessageAnswerable();
            futures.add(future);
            this.nucleus.sendMessage(new CellMessage(new CellPath(domain, peer), msg), false, true, future, MoreExecutors.directExecutor(), timeout);
        }
        return Futures.allAsList(futures);
    }

    private void updateRoutes(String domain, Collection<String> destinations, Multimap<String, String> routes, int type) {
        HashSet<String> newDestinations = new HashSet<String>(destinations);
        Iterator iterator = routes.get((Object)domain).iterator();
        while (iterator.hasNext()) {
            String destination = (String)iterator.next();
            if (newDestinations.remove(destination)) continue;
            try {
                this.nucleus.routeDelete(new CellRoute(destination, "*@" + domain, type));
                iterator.remove();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        for (String destination : newDestinations) {
            try {
                this.nucleus.routeAdd(new CellRoute(destination, "*@" + domain, type));
                routes.put((Object)domain, (Object)destination);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private synchronized void updateTopicRoutes(String domain, Collection<String> topics) {
        this.updateRoutes(domain, topics, this.topicRoutes, 7);
    }

    private synchronized void updateQueueRoutes(String domain, Collection<String> cells) {
        this.updateRoutes(domain, cells, this.queueRoutes, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(CellMessage msg) {
        Serializable obj = msg.getMessageObject();
        if (obj instanceof CoreRouteUpdate) {
            String domain2 = msg.getSourceAddress().getCellDomainName();
            if (this.updates.put(domain2, (CoreRouteUpdate)obj) == null) {
                this.executor.execute(() -> {
                    CoreRouteUpdate update = (CoreRouteUpdate)this.updates.remove(domain2);
                    this.updateTopicRoutes(domain2, update.getTopics());
                    this.updateQueueRoutes(domain2, update.getExports());
                });
            }
        } else if (obj instanceof GetAllDomainsRequest) {
            CellTunnelInfo tunnel = (CellTunnelInfo)Iterables.getFirst(this.coreTunnels.values(), null);
            if (this.role == CellDomainRole.SATELLITE && tunnel != null) {
                msg.getDestinationPath().insert(new CellPath(this.nucleus.getCellName(), tunnel.getRemoteCellDomainInfo().getCellDomainName()));
                msg.nextDestination();
                this.nucleus.sendMessage(msg, false, true);
            } else {
                HashMap<String, Collection<String>> domains = new HashMap<String, Collection<String>>();
                CoreRoutingManager coreRoutingManager = this;
                synchronized (coreRoutingManager) {
                    domains.put(this.getCellDomainName(), new ArrayList(this.localConsumers.values()));
                    Arrays.asList(this.coreTunnels, this.satelliteTunnels, this.legacyTunnels).stream().flatMap(map -> map.values().stream()).map(CellTunnelInfo::getRemoteCellDomainInfo).map(CellDomainInfo::getCellDomainName).forEach(domain -> {
                        Collection cfr_ignored_0 = domains.put((String)domain, new ArrayList());
                    });
                    this.queueRoutes.asMap().forEach((domain, cells) -> {
                        Collection cfr_ignored_0 = domains.put((String)domain, Lists.newArrayList((Iterable)cells));
                    });
                }
                msg.revertDirection();
                msg.setMessageObject(new GetAllDomainsReply(domains));
                this.sendMessage(msg);
            }
        } else if (obj instanceof NoRouteToCellException) {
            LOG.info(((NoRouteToCellException)obj).getMessage());
        } else if (obj instanceof String[]) {
            String[] info = (String[])obj;
            if (info.length < 1) {
                LOG.warn("Protocol error 1 in routing info");
                return;
            }
            String domain3 = info[0];
            LOG.info("Routing info arrived for domain {}", (Object)domain3);
            if (this.legacyWellknownUpdates.put(domain3, Arrays.asList(info).subList(1, info.length)) == null) {
                this.executor.execute(() -> this.updateQueueRoutes(domain3, (Collection)this.legacyWellknownUpdates.remove(domain3)));
            }
        } else if (obj instanceof TopicRouteUpdate) {
            String domain4 = msg.getSourceAddress().getCellDomainName();
            if (this.legacyTopicUpdates.put(domain4, ((TopicRouteUpdate)obj).getTopics()) == null) {
                this.executor.execute(() -> this.updateTopicRoutes(domain4, (Collection)this.legacyTopicUpdates.remove(domain4)));
            }
        } else if (obj instanceof PeerShutdownNotification) {
            PeerShutdownNotification notification = (PeerShutdownNotification)obj;
            String remoteDomain = notification.getDomainName();
            CoreRoutingManager coreRoutingManager = this;
            synchronized (coreRoutingManager) {
                this.coreTunnels.values().stream().filter(i -> i.getRemoteCellDomainInfo().getCellDomainName().equals(remoteDomain)).forEach(i -> {
                    CellRoute route = new CellRoute(null, i.getTunnel(), 4);
                    this.delayedDefaultRoutes.remove(route);
                    if (!this.hasAlternativeDefaultRoute(route)) {
                        this.installDefaultRoute();
                    }
                    try {
                        this.nucleus.routeDelete(route);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                });
            }
            msg.revertDirection();
            this.sendMessage(msg);
        } else {
            LOG.warn("Unidentified message ignored: {}", (Object)obj);
        }
    }

    @Override
    public void cellCreated(CellEvent ce) {
        String name = (String)ce.getSource();
        LOG.info("Cell created: {}", (Object)name);
    }

    @Override
    public synchronized void cellDied(CellEvent ce) {
        String name = (String)ce.getSource();
        LOG.info("Cell died: {}", (Object)name);
    }

    @Override
    public synchronized void routeAdded(CellEvent ce) {
        CellRoute cr = (CellRoute)ce.getSource();
        CellAddressCore target = cr.getTarget();
        LOG.info("Got 'route added' event: {}", (Object)cr);
        switch (cr.getRouteType()) {
            case 3: {
                Optional<CellTunnelInfo> tunnelInfo = this.getTunnelInfo(target);
                tunnelInfo.filter(i -> i.getRemoteCellDomainInfo().getRole() == CellDomainRole.CORE).ifPresent(i -> {
                    this.coreTunnels.put(i.getTunnel(), (CellTunnelInfo)i);
                    this.sendToCoreDomains();
                });
                tunnelInfo.filter(i -> i.getRemoteCellDomainInfo().getRole() == CellDomainRole.SATELLITE && i.getRemoteCellDomainInfo().getRelease() >= 528).ifPresent(i -> {
                    this.satelliteTunnels.put(i.getTunnel(), (CellTunnelInfo)i);
                    this.sendToSatelliteDomains();
                });
                tunnelInfo.filter(i -> i.getRemoteCellDomainInfo().getRole() == CellDomainRole.SATELLITE && i.getRemoteCellDomainInfo().getRelease() < 528).ifPresent(i -> this.legacyTunnels.put(i.getTunnel(), (CellTunnelInfo)i));
                tunnelInfo.filter(i -> i.getLocalCellDomainInfo().getRole() == CellDomainRole.SATELLITE && i.getRemoteCellDomainInfo().getRole() == CellDomainRole.CORE).ifPresent(i -> {
                    this.delayedDefaultRoutes.add(new CellRoute(null, i.getTunnel(), 4));
                    if (this.nucleus.getRoutingTable().hasDefaultRoute()) {
                        this.invokeLater(this::installDefaultRoute);
                    } else {
                        this.installDefaultRoute();
                    }
                });
                break;
            }
            case 7: {
                String topic = cr.getCellName();
                if (!target.getCellDomainName().equals(this.nucleus.getCellDomainName())) break;
                this.localSubscriptions.put((Object)target.getCellName(), (Object)topic);
                this.sendToCoreDomains();
                break;
            }
            case 2: {
                String queue = cr.getCellName();
                if (!target.getCellDomainName().equals(this.nucleus.getCellDomainName())) break;
                this.localConsumers.put((Object)target.getCellName(), (Object)queue);
                this.sendToCoreDomains();
                this.sendToSatelliteDomains();
                break;
            }
            case 4: {
                LOG.info("Default route {} was added", (Object)cr);
            }
        }
    }

    @Override
    public synchronized void routeDeleted(CellEvent ce) {
        CellRoute cr = (CellRoute)ce.getSource();
        CellAddressCore target = cr.getTarget();
        switch (cr.getRouteType()) {
            case 3: {
                this.updateTopicRoutes(cr.getDomainName(), Collections.emptyList());
                this.updateQueueRoutes(cr.getDomainName(), Collections.emptyList());
                this.getTunnelInfo(target).map(CellTunnelInfo::getTunnel).ifPresent(name -> {
                    this.coreTunnels.remove(name);
                    this.satelliteTunnels.remove(name);
                    this.legacyTunnels.remove(name);
                });
                break;
            }
            case 7: {
                String topic = cr.getCellName();
                if (!target.getCellDomainName().equals(this.nucleus.getCellDomainName()) || !this.localSubscriptions.remove((Object)target.getCellName(), (Object)topic)) break;
                this.sendToCoreDomains();
                break;
            }
            case 2: {
                String queue = cr.getCellName();
                if (!target.getCellDomainName().equals(this.nucleus.getCellDomainName()) || !this.localSubscriptions.remove((Object)target.getCellName(), (Object)queue)) break;
                this.sendToCoreDomains();
                this.sendToSatelliteDomains();
            }
        }
    }

    private synchronized void installDefaultRoute() {
        for (CellRoute route : this.delayedDefaultRoutes) {
            try {
                this.nucleus.routeAdd(route);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Failed to add route: {}", (Object)e.getMessage());
            }
        }
        this.delayedDefaultRoutes.clear();
    }

    private boolean hasAlternativeDefaultRoute(CellRoute route) {
        return Arrays.asList(this.nucleus.getRoutingList()).stream().filter(r -> r.getRouteType() == 4).anyMatch(r -> !r.equals(route));
    }

    private Optional<CellTunnelInfo> getTunnelInfo(CellAddressCore tunnel) {
        return this.nucleus.getCellTunnelInfos().stream().filter(i -> i.getTunnel().equals(tunnel)).findAny();
    }

    @Deprecated
    public synchronized Object ac_ls_$_0(Args args) {
        return new Object[]{this.getCellDomainName(), Sets.newHashSet((Iterable)this.localConsumers.values()), this.queueRoutes.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Sets.newHashSet((Iterable)((Iterable)e.getValue()))))};
    }
}

