/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import dmg.cells.network.LocationManagerConnector;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellDomainRole;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.services.login.LoginManager;
import dmg.cells.zookeeper.PathChildrenCache;
import dmg.util.CommandException;
import dmg.util.CommandInterpreter;
import dmg.util.command.Command;
import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.nodes.PersistentNode;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.dcache.util.Args;
import org.dcache.util.ColumnWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationManager
extends CellAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationManager.class);
    private static final String ZK_CORES = "/dcache/lm/cores";
    private final CoreDomains coreDomains;
    private final LegacyServer legacy;
    private final Args args = this.getArgs();
    private final CellNucleus nucleus = this.getNucleus();
    private final CellDomainRole role;
    private final Client client;

    public LocationManager(String name, String args) throws CommandException, IOException {
        super(name, "System", args);
        this.coreDomains = new CoreDomains(this.getCellDomainName(), this.getCuratorFramework());
        this.legacy = this.args.hasOption("legacy") ? new LegacyServer(this.args.getIntOption("legacy")) : null;
        if (this.args.hasOption("role")) {
            this.role = CellDomainRole.valueOf(this.args.getOption("role").toUpperCase());
            switch (this.role) {
                case CORE: {
                    Preconditions.checkArgument((this.args.argc() >= 1 ? 1 : 0) != 0, (Object)"Listening port is required.");
                    this.client = new CoreClient();
                    this.coreDomains.onChange(event -> this.invokeOnMessageThread(() -> this.client.update((PathChildrenCacheEvent)event)));
                    break;
                }
                default: {
                    this.client = new Client();
                    this.coreDomains.onChange(event -> this.invokeOnMessageThread(() -> this.client.update((PathChildrenCacheEvent)event)));
                    break;
                }
            }
        } else {
            this.role = null;
            this.client = null;
        }
    }

    @Override
    protected void started() {
        try {
            this.coreDomains.start();
            if (this.legacy != null) {
                this.legacy.start();
                LOGGER.info("Server Setup Done");
            }
            if (this.client != null) {
                this.client.start();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to start location manager: {}", (Object)e.getCause().toString());
            this.kill();
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to start location manager", (Throwable)e);
            this.kill();
        }
        catch (Exception e) {
            LOGGER.error("Failed to start location manager: {}", (Object)e.toString());
            this.kill();
        }
    }

    @Override
    public void cleanUp() {
        CloseableUtils.closeQuietly((Closeable)this.coreDomains);
        if (this.legacy != null) {
            this.legacy.close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    private String startListener(String args) throws ExecutionException, InterruptedException {
        String cellName = "l*";
        String cellClass = "dmg.cells.network.LocationMgrTunnel";
        String cellArgs = args + " " + cellClass + " " + "-prot=raw" + " -lm=" + this.getCellName() + " -role=" + (Object)((Object)this.role);
        LOGGER.info("Starting acceptor with arguments: {}", (Object)cellArgs);
        LoginManager c = new LoginManager(cellName, "System", cellArgs);
        c.start().get();
        LOGGER.info("Created : {}", (Object)c);
        return c.getCellName();
    }

    private String startConnector(String remoteDomain, HostAndPort address) throws ExecutionException, InterruptedException {
        String cellName = "c-" + remoteDomain + "*";
        String clientKey = this.args.getOpt("clientKey");
        clientKey = clientKey != null && clientKey.length() > 0 ? "-clientKey=" + clientKey : "";
        String clientName = this.args.getOpt("clientUserName");
        clientName = clientName != null && clientName.length() > 0 ? "-clientUserName=" + clientName : "";
        String cellArgs = "-domain=" + remoteDomain + " " + "-lm=" + this.getCellName() + " " + "-role=" + (Object)((Object)this.role) + " " + "-where=" + address + " " + clientKey + " " + clientName;
        LOGGER.info("Starting connector with {}", (Object)cellArgs);
        LocationManagerConnector c = new LocationManagerConnector(cellName, cellArgs);
        c.start().get();
        LOGGER.info("Created : {}", (Object)c);
        return c.getCellName();
    }

    private static HostAndPort toHostAndPort(byte[] bytes) {
        return bytes == null ? null : HostAndPort.fromString((String)new String(bytes, StandardCharsets.US_ASCII));
    }

    @Command(name="ls", hint="list core domains", description="Provides information on available core domains.")
    class ListCommand
    implements Callable<String> {
        ListCommand() {
        }

        @Override
        public String call() throws Exception {
            ColumnWriter writer = new ColumnWriter().header("NAME").left("name").space().header("ADDRESS").left("address");
            for (Map.Entry<String, HostAndPort> entry : LocationManager.this.coreDomains.cores().entrySet()) {
                writer.row().value("name", (Object)entry.getKey()).value("address", (Object)entry.getValue());
            }
            return writer.toString();
        }
    }

    public class CoreClient
    extends Client {
        @Override
        protected boolean shouldConnectTo(String domain) {
            return domain.compareTo(LocationManager.this.getCellDomainName()) < 0;
        }

        @Override
        public void start() throws ExecutionException, InterruptedException {
            LocationManager.this.startListener(String.join((CharSequence)" ", (Iterable<? extends CharSequence>)LocationManager.this.args.getArguments()));
        }

        public String ac_listening_on_$_2(Args args) throws Exception {
            int port = Integer.parseInt(args.argv(1));
            HostAndPort address = HostAndPort.fromParts((String)InetAddress.getLocalHost().getCanonicalHostName(), (int)port);
            LocationManager.this.coreDomains.setLocalAddress(address);
            return "";
        }
    }

    public class Client
    implements CellEventListener {
        private final ConcurrentMap<String, String> connectors = new ConcurrentHashMap<String, String>();

        public Client() {
            LocationManager.this.addCommandListener(this);
            LocationManager.this.addCellEventListener(this);
        }

        public void start() throws ExecutionException, InterruptedException {
        }

        public void close() {
        }

        public void update(PathChildrenCacheEvent event) {
            LOGGER.debug("{}", (Object)event);
            String domain = ZKPaths.getNodeFromPath((String)event.getData().getPath());
            switch (event.getType()) {
                case CHILD_ADDED: {
                    try {
                        if (!this.shouldConnectTo(domain)) break;
                        this.connectors.put(domain, LocationManager.this.startConnector(domain, LocationManager.toHostAndPort(event.getData().getData())));
                    }
                    catch (ExecutionException e) {
                        LOGGER.error("Failed to start tunnel connector to {}: {}", (Object)domain, (Object)e.getCause());
                    }
                    catch (InterruptedException e) {}
                    break;
                }
                case CHILD_REMOVED: {
                    String cell = (String)this.connectors.remove(domain);
                    if (cell == null) break;
                    LocationManager.this.getNucleus().kill(cell);
                }
            }
        }

        protected boolean shouldConnectTo(String domain) {
            return true;
        }

        @Override
        public void cellCreated(CellEvent ce) {
        }

        @Override
        public void cellDied(CellEvent ce) {
            this.connectors.values().remove((String)ce.getSource());
        }

        @Override
        public void routeAdded(CellEvent ce) {
        }

        @Override
        public void routeDeleted(CellEvent ce) {
        }
    }

    @Deprecated
    public class LegacyServer
    implements Runnable,
    Closeable {
        private final int port;
        private final DatagramSocket socket;
        private final Thread worker;
        private final RemoteCommands remoteCommands = new RemoteCommands();

        public LegacyServer(int port) throws SocketException {
            this.port = port;
            this.socket = new DatagramSocket(this.port);
            this.worker = LocationManager.this.nucleus.newThread(this, "Server");
        }

        public void start() {
            this.worker.start();
        }

        @Override
        public void close() {
            this.worker.interrupt();
            this.socket.close();
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                DatagramPacket packet;
                try {
                    packet = new DatagramPacket(new byte[1024], 1024);
                    this.socket.receive(packet);
                }
                catch (SocketException e) {
                    if (Thread.currentThread().isInterrupted()) break;
                    LOGGER.warn("Exception in Server receive loop (exiting)", (Throwable)e);
                    break;
                }
                catch (Exception ie) {
                    LOGGER.warn("Exception in Server receive loop (exiting)", (Throwable)ie);
                    break;
                }
                try {
                    this.process(packet);
                    this.socket.send(packet);
                }
                catch (Exception se) {
                    LOGGER.warn("Exception in send ", (Throwable)se);
                }
            }
            this.socket.close();
        }

        public void process(DatagramPacket packet) throws Exception {
            byte[] data = packet.getData();
            int datalen = packet.getLength();
            InetAddress address = packet.getAddress();
            if (datalen <= 0) {
                LOGGER.warn("Empty Packet arrived from {}", (Object)packet.getAddress());
                return;
            }
            String message = new String(data, 0, datalen);
            LOGGER.info("server query : [{}] ({}) {}", new Object[]{address, message.length(), message});
            Args args = new Args((CharSequence)message);
            String string = message = args.argc() == 0 ? "" : (String)((Object)this.remoteCommands.command(args));
            if (message != null) {
                LOGGER.info("server reply : {}", (Object)message);
                data = message.getBytes();
                packet.setData(data);
                packet.setLength(data.length);
            }
        }

        public class RemoteCommands
        extends CommandInterpreter {
            public static final String hh_whatToDo = "<domainName>";
            public static final String hh_whereIs = "<domainName>";

            public String ac_whatToDo_$_1(Args args) {
                String domainName = args.argv(0);
                String serial = args.getOpt("serial");
                Map<String, HostAndPort> cores = LocationManager.this.coreDomains.cores();
                switch (cores.size()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        String broker = (String)Iterables.get(cores.keySet(), (int)0);
                        return "do" + (serial != null ? " -serial=" + serial : "") + " " + domainName + " " + "nl" + " c:" + broker + " d:" + broker;
                    }
                }
                LOGGER.warn("Legacy domain {} tried to connect, but are not supported in multi-core topologies.", (Object)domainName);
                return "do" + (serial != null ? " -serial=" + serial : "") + " " + domainName;
            }

            public String ac_whereIs_$_1(Args args) {
                String domainName = args.argv(0);
                HostAndPort address = LocationManager.this.coreDomains.readAddressOf(domainName);
                if (address == null) {
                    throw new IllegalArgumentException("Domain not listening: " + domainName);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("location");
                String serial = args.getOpt("serial");
                if (serial != null) {
                    sb.append(" -serial=").append(serial);
                }
                sb.append(" ").append(domainName);
                sb.append(" ").append(address);
                return sb.toString();
            }
        }
    }

    private static class CoreDomains
    implements Closeable {
        private final String domainName;
        private final CuratorFramework client;
        private final PathChildrenCache cores;
        private PersistentNode local;

        CoreDomains(String domainName, CuratorFramework client) {
            this.domainName = domainName;
            this.client = client;
            this.cores = new PathChildrenCache(client, LocationManager.ZK_CORES, true);
        }

        void onChange(Consumer<PathChildrenCacheEvent> consumer) {
            this.cores.getListenable().addListener((client, event) -> consumer.accept(event));
        }

        void start() throws Exception {
            this.cores.start();
        }

        @Override
        public void close() throws IOException {
            CloseableUtils.closeQuietly((Closeable)this.cores);
            if (this.local != null) {
                CloseableUtils.closeQuietly((Closeable)this.local);
            }
        }

        HostAndPort getLocalAddress() {
            return this.local == null ? null : LocationManager.toHostAndPort(this.local.getData());
        }

        void setLocalAddress(HostAndPort address) throws Exception {
            if (this.local == null) {
                PersistentNode node = new PersistentNode(this.client, CreateMode.EPHEMERAL, false, this.pathOf(this.domainName), this.toBytes(address));
                node.start();
                this.local = node;
            } else {
                this.local.setData(this.toBytes(address));
            }
        }

        HostAndPort readAddressOf(String domainName) {
            ChildData data = this.cores.getCurrentData(this.pathOf(domainName));
            return data == null ? null : LocationManager.toHostAndPort(data.getData());
        }

        Map<String, HostAndPort> cores() {
            return this.cores.getCurrentData().stream().collect(Collectors.toMap(d -> ZKPaths.getNodeFromPath((String)d.getPath()), d -> LocationManager.toHostAndPort(d.getData())));
        }

        String pathOf(String domainName) {
            return ZKPaths.makePath((String)LocationManager.ZK_CORES, (String)domainName);
        }

        byte[] toBytes(HostAndPort address) {
            return address.toString().getBytes(StandardCharsets.US_ASCII);
        }
    }
}

