/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellShell;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.ControlBufferedReader;
import dmg.util.CommandExitException;
import dmg.util.Gate;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.ExecutionException;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamLoginCell
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(StreamLoginCell.class);
    private StreamEngine _engine;
    private ControlBufferedReader _in;
    private PrintWriter _out;
    private InetAddress _host;
    private Subject _subject;
    private Thread _workerThread;
    private CellShell _shell;
    private String _destination;
    private boolean _syncMode = true;
    private Gate _readyGate = new Gate(false);
    private int _syncTimeout = 10;
    private int _commandCounter;
    private String _lastCommand = "<init>";
    private Reader _reader;
    private CellNucleus _nucleus;
    public static final String fh_set_sync = " Syntax : set sync on|off \n          sets the message send mode to synchronized or\n          asynchronized mode. The default timeout for the\n          sync mode is 10 seconds. Use the 'set timeout'\n          commmand to change this value\n";
    public static final String hh_set_dest = "local|<destinationCell>";
    public static final String hh_set_sync = "on|off";
    public static final String hh_set_timeout = "<seconds>";
    public static final String hh_set_echochar = "on|off|<echoChar>";

    public StreamLoginCell(String name, StreamEngine engine) {
        super(name, "");
        this._engine = engine;
        this._nucleus = this.getNucleus();
    }

    @Override
    protected void startUp() {
        this._reader = this._engine.getReader();
        this._in = new ControlBufferedReader(this._reader);
        this._out = new PrintWriter(this._engine.getWriter());
        this._subject = this._engine.getSubject();
        this._host = this._engine.getInetAddress();
        this._shell = new CellShell(this._nucleus);
        this._destination = this.getCellName();
        this.useInterpreter(false);
    }

    @Override
    protected void started() {
        this._workerThread = this._nucleus.newThread(this, "worker");
        this._workerThread.start();
    }

    @Override
    public void cleanUp() {
        _log.info("Clean up called");
        this.println("");
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (Exception ee) {
                _log.warn("ignoring exception on PrintWriter.close {}", (Object)ee.toString());
            }
        }
        if (this._workerThread != null) {
            this._workerThread.interrupt();
        }
        try {
            if (!this._engine.getSocket().isClosed()) {
                _log.info("Close socket");
                this._engine.getSocket().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        _log.info("finished");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (Thread.currentThread() == this._workerThread) {
            this.print(this.prompt());
            this._in.onControlC("interrupted");
            try {
                while ((this._lastCommand = this._in.readLine()) != null) {
                    ++this._commandCounter;
                    if (this.execute(this._lastCommand) > 0) {
                        try {
                            this._out.close();
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    this.print(this.prompt());
                }
            }
            catch (IOException e) {
                _log.info("EOF Exception in read line : " + e);
            }
            catch (Exception e) {
                _log.info("I/O Error in read line : " + e);
            }
            _log.info("EOS encountered");
            this._readyGate.open();
            this.kill();
        }
    }

    public void println(String str) {
        this._out.println(str);
        this._out.flush();
    }

    public void print(String str) {
        this._out.print(str);
        this._out.flush();
    }

    public String prompt() {
        return this._destination == null ? " .. > " : this._destination + " > ";
    }

    public int execute(String command) {
        if (command.equals("")) {
            return 0;
        }
        if (this._destination == null) {
            try {
                this.print(this.command(command));
                return 0;
            }
            catch (CommandExitException cee) {
                return 1;
            }
        }
        if (this._destination.equals(this.getCellName())) {
            try {
                this.printObject(this._shell.objectCommand(command));
            }
            catch (CommandExitException cee) {
                this.print("Shell Exit (code=" + cee.getExitCode() + ";msg=" + cee.getMessage() + ")\n");
                this.print("Back to .. mode\n");
                this._destination = null;
            }
        } else {
            if (command.equals("exit")) {
                this._destination = null;
                this.print("Back to .. mode\n");
                return 0;
            }
            try {
                CellMessage msg = new CellMessage(new CellPath(this._destination), (Serializable)((Object)command));
                if (this._syncMode) {
                    msg = this.getNucleus().sendAndWait(msg, 1000 * this._syncTimeout);
                    if (msg == null) {
                        this.print("Timeout ... \n");
                        return 0;
                    }
                    this.printObject(msg.getMessageObject());
                } else {
                    this.sendMessage(msg);
                    this.print("Msg UOID =" + msg.getUOID() + "\n");
                }
            }
            catch (NoRouteToCellException | InterruptedException | RuntimeException | ExecutionException ex) {
                this.print("Problem : " + ex + "\n");
                ex.printStackTrace();
            }
        }
        return 0;
    }

    private void printObject(Object obj) {
        if (obj == null) {
            this.println("Received 'null' Object");
            return;
        }
        if (obj instanceof Object[]) {
            Object[] array;
            for (Object o : array = (Object[])obj) {
                if (o == null) continue;
                String output = o.toString();
                this.print(output);
                if (output.length() <= 0 || output.charAt(output.length() - 1) == '\n') continue;
                this.print("\n");
            }
        } else {
            String output = obj.toString();
            this.print(output);
            if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                this.print("\n");
            }
        }
    }

    @Override
    public String toString() {
        return Subjects.getDisplayName((Subject)this._subject) + "@" + this._host;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("            Stream LoginCell");
        pw.println("         User  : " + Subjects.getDisplayName((Subject)this._subject));
        pw.println("         Host  : " + this._host);
        pw.println(" Last Command  : " + this._lastCommand);
        pw.println(" Command Count : " + this._commandCounter);
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Serializable obj = msg.getMessageObject();
        this.println("");
        this.println(" CellMessage From   : " + msg.getSourcePath());
        this.println(" CellMessage To     : " + msg.getDestinationPath());
        this.println(" CellMessage Object : " + obj.getClass().getName());
        this.printObject(obj);
    }

    public String ac_show_timeout(Args args) {
        return "Sync timeout = " + this._syncTimeout + " seconds \n";
    }

    public String ac_set_timeout_$_1(Args args) {
        this._syncTimeout = Integer.parseInt(args.argv(0));
        return "";
    }

    public String ac_set_sync_on(Args args) {
        this._syncMode = true;
        return "";
    }

    public String ac_set_sync_off(Args args) {
        this._syncMode = false;
        return "";
    }

    public String ac_set_dest_$_1(Args args) {
        this._destination = args.argv(0).equals("local") ? this.getCellName() : args.argv(0);
        return "";
    }

    public String ac_exit(Args args) throws CommandExitException {
        throw new CommandExitException("", 0);
    }
}

