/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractService;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.services.login.LoginCellFactory;
import dmg.util.StreamEngine;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;

public class LegacyLoginCellFactory
extends AbstractService
implements LoginCellFactory {
    private final Constructor<? extends CellAdapter> _loginConstructor;
    private final String _cellName;

    public LegacyLoginCellFactory(Constructor<? extends CellAdapter> loginConstructor, String cellName) {
        this._cellName = (String)Preconditions.checkNotNull((Object)cellName);
        this._loginConstructor = (Constructor)Preconditions.checkNotNull(loginConstructor);
    }

    @Override
    public Cell newCell(StreamEngine engine, String userName) throws InvocationTargetException {
        try {
            CellAdapter cell = this._loginConstructor.newInstance(this._cellName + "-" + userName + "*", engine);
            cell.start().get();
            return cell;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instantiate login cell: " + this.getName(), e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InvocationTargetException(e.getCause(), e.getMessage());
        }
    }

    @Override
    public String getName() {
        return this._loginConstructor.getDeclaringClass().getName();
    }

    protected void doStart() {
        this.notifyStarted();
    }

    protected void doStop() {
        this.notifyStopped();
    }
}

