/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import diskCacheV111.util.FsPath;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ProtocolFamily;
import java.net.StandardProtocolFamily;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.dcache.util.NetworkUtils;

public class LoginBrokerInfo
implements Serializable {
    private static final long serialVersionUID = 4077557054990432737L;
    private final String _cellName;
    private final String _domainName;
    private final String _protocolFamily;
    private final String _protocolVersion;
    private final String _protocolEngine;
    private final String _root;
    private final List<InetAddress> _addresses;
    @Deprecated
    private final String[] _hosts;
    private final int _port;
    private final double _load;
    private final long _update;
    private final Collection<String> _tags;
    private final Collection<String> _readPaths;
    private final Collection<String> _writePaths;
    private transient FsPath _rootFsPath;
    private transient Collection<FsPath> _readFsPaths;
    private transient Collection<FsPath> _writeFsPaths;

    public LoginBrokerInfo(String cellName, String domainName, String protocolFamily, String protocolVersion, String protocolEngine, String root, Collection<String> readPaths, Collection<String> writePaths, Collection<String> tags, List<InetAddress> addresses, int port, double load, long updateTime) {
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0);
        this._cellName = (String)Preconditions.checkNotNull((Object)cellName);
        this._domainName = (String)Preconditions.checkNotNull((Object)domainName);
        this._protocolFamily = (String)Preconditions.checkNotNull((Object)protocolFamily);
        this._protocolVersion = (String)Preconditions.checkNotNull((Object)protocolVersion);
        this._protocolEngine = (String)Preconditions.checkNotNull((Object)protocolEngine);
        this._root = root;
        this._tags = (Collection)Preconditions.checkNotNull(tags);
        this._readPaths = (Collection)Preconditions.checkNotNull(readPaths);
        this._writePaths = (Collection)Preconditions.checkNotNull(writePaths);
        this._addresses = (List)Preconditions.checkNotNull(addresses);
        this._port = port;
        this._load = load;
        this._update = updateTime;
        this._hosts = new String[addresses.size()];
        for (int i = 0; i < addresses.size(); ++i) {
            this._hosts[i] = addresses.get(i).getHostAddress();
        }
        if (this._root != null) {
            this._rootFsPath = FsPath.create((String)this._root);
        }
        this._readFsPaths = this._readPaths.stream().map(FsPath::create).collect(Collectors.toList());
        this._writeFsPaths = this._writePaths.stream().map(FsPath::create).collect(Collectors.toList());
    }

    public boolean supports(NetworkUtils.InetAddressScope scope) {
        return this._addresses.stream().anyMatch(a -> NetworkUtils.InetAddressScope.of((InetAddress)a).ordinal() >= scope.ordinal());
    }

    public boolean supports(ProtocolFamily family) {
        if (family == StandardProtocolFamily.INET) {
            return this._addresses.stream().anyMatch(a -> a instanceof Inet4Address);
        }
        if (family == StandardProtocolFamily.INET6) {
            return this._addresses.stream().anyMatch(a -> a instanceof Inet6Address);
        }
        return true;
    }

    @Nonnull
    public List<InetAddress> getAddresses() {
        return Collections.unmodifiableList(this._addresses);
    }

    @Deprecated
    public String[] getHosts() {
        return this._hosts;
    }

    public int getPort() {
        return this._port;
    }

    @Nonnull
    public String getCellName() {
        return this._cellName;
    }

    @Nonnull
    public String getDomainName() {
        return this._domainName;
    }

    @Nonnull
    public String getProtocolFamily() {
        return this._protocolFamily;
    }

    @Nonnull
    public String getProtocolVersion() {
        return this._protocolVersion;
    }

    @Nonnull
    public String getProtocolEngine() {
        return this._protocolEngine;
    }

    public String getRoot() {
        return this._root;
    }

    public FsPath getRoot(FsPath userRoot) {
        return this._rootFsPath == null ? userRoot : this._rootFsPath;
    }

    public String relativize(FsPath userRoot, FsPath path) {
        return path.stripPrefix(this.getRoot(userRoot));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canWrite(FsPath userRoot, FsPath path) {
        if (!path.hasPrefix(this.getRoot(userRoot))) return false;
        if (!this._writeFsPaths.stream().anyMatch(arg_0 -> ((FsPath)path).hasPrefix(arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canRead(FsPath userRoot, FsPath path) {
        if (!path.hasPrefix(this.getRoot(userRoot))) return false;
        if (!this._readFsPaths.stream().anyMatch(arg_0 -> ((FsPath)path).hasPrefix(arg_0))) return false;
        return true;
    }

    public Collection<String> getTags() {
        return Collections.unmodifiableCollection(this._tags);
    }

    public Collection<String> getReadPaths() {
        return Collections.unmodifiableCollection(this._readPaths);
    }

    public Collection<String> getWritePaths() {
        return Collections.unmodifiableCollection(this._writePaths);
    }

    public void ifCapableOf(Capability capability, Consumer<LoginBrokerInfo> action) {
        Collection<Object> paths;
        switch (capability) {
            case READ: {
                paths = this._readPaths;
                break;
            }
            case WRITE: {
                paths = this._writePaths;
                break;
            }
            default: {
                paths = Collections.emptyList();
            }
        }
        if (!paths.isEmpty()) {
            action.accept(this);
        }
    }

    public double getLoad() {
        return this._load;
    }

    public long getUpdateTime() {
        return this._update;
    }

    @Nonnull
    public String getIdentifier() {
        return this._cellName + "@" + this._domainName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._cellName).append("@").append(this._domainName).append(";");
        int pos = this._protocolEngine.lastIndexOf(46);
        if (pos < 0 || pos == this._protocolEngine.length() - 1) {
            sb.append(this._protocolEngine).append(";");
        } else {
            sb.append(this._protocolEngine.substring(pos + 1)).append(";");
        }
        sb.append("{").append(this._protocolFamily).append(",").append(this._protocolVersion).append("};");
        sb.append("[");
        Joiner.on((String)",").appendTo(sb, this._addresses);
        sb.append(":").append(this._port).append("]").append(";");
        sb.append("<");
        sb.append((int)(this._load * 100.0)).append(",");
        sb.append(this._update).append(">;");
        return sb.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._root != null) {
            this._rootFsPath = FsPath.create((String)this._root);
        }
        this._readFsPaths = this._readPaths.stream().map(FsPath::create).collect(Collectors.toList());
        this._writeFsPaths = this._writePaths.stream().map(FsPath::create).collect(Collectors.toList());
    }

    public static enum Capability {
        READ,
        WRITE;

    }
}

