/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.net.InetAddresses;
import com.google.common.util.concurrent.MoreExecutors;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginBrokerInfoRequest;
import dmg.cells.services.login.LoginBrokerPublisher;
import dmg.cells.services.login.LoginCellFactory;
import dmg.cells.services.login.LoginCellFactoryBuilder;
import dmg.cells.services.login.LoginManagerChildrenInfo;
import dmg.cells.services.login.StreamEngineFactory;
import dmg.cells.services.login.TelnetSAuth_A;
import dmg.util.KeepAliveListener;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javatunnel.UserValidatable;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.commons.util.NDC;
import org.dcache.util.Args;
import org.dcache.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginManager
extends CellAdapter
implements UserValidatable {
    private static final Object DEAD_CELL = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginManager.class);
    private static final Class<?>[] AUTH_CON_SIGNATURE = new Class[]{CellNucleus.class, Args.class};
    private final CellNucleus _nucleus;
    private final Args _args;
    private ListenThread _listenThread;
    private String _locationManager;
    private final AtomicInteger _connectionDeniedCounter = new AtomicInteger();
    private final AtomicInteger _loginCounter = new AtomicInteger();
    private final AtomicInteger _loginFailures = new AtomicInteger();
    private CellVersion _version;
    private Constructor<?> _authConstructor;
    private ScheduledExecutorService _scheduledExecutor;
    private ConcurrentMap<String, Object> _children = new ConcurrentHashMap<String, Object>();
    private CellPath _authenticator;
    private KeepAliveTask _keepAlive;
    private LoginBrokerPublisher _loginBrokerPublisher;
    private String _protocol;
    private Class<?> _authClass;
    private LoginCellFactory _loginCellFactory;
    private volatile boolean _sending = true;
    private volatile int _maxLogin = -1;
    public static final String hh_get_children = "[-binary]";
    public static final String hh_set_keepalive = "<keepAliveValue/seconds>";
    public static final String hh_set_max_logins = "<maxNumberOfLogins>|-1";

    public LoginManager(String name, String argString) {
        this(name, "Generic", argString);
    }

    public LoginManager(String name, String cellType, String argString) {
        super(name, cellType, argString);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
    }

    @Override
    protected void startUp() throws Exception {
        Constructor<?> authConstructor;
        if (this._args.argc() < 2) {
            throw new IllegalArgumentException("USAGE : ... <listenPort> <loginCell> [-prot=telnet|raw] [-auth=<authCell>] [-maxLogin=<n>|-1] [-keepAlive=<seconds>] [-acceptErrorWait=<msecs>] [args givenToLoginClass]");
        }
        int listenPort = Integer.parseInt(this._args.argv(0));
        String loginCell = this._args.argv(1);
        Args childArgs = new Args((CharSequence)this._args.toString().replaceFirst("(^|\\s)-consume=\\S*", "").replaceFirst("(^|\\s)-subscribe=\\S*", ""));
        childArgs.shift();
        childArgs.shift();
        this._protocol = LoginManager.checkProtocol(this._args.getOpt("prot"));
        LOGGER.info("Using protocol : {}", (Object)this._protocol);
        this._authenticator = new CellPath(this._args.getOption("authenticator", "pam"));
        this._authClass = LoginManager.toAuthClass(this._args.getOpt("auth"), this._protocol);
        if (this._authClass != null) {
            authConstructor = this._authClass.getConstructor(AUTH_CON_SIGNATURE);
            LOGGER.trace("Using authentication constructor: {}", authConstructor);
        } else {
            authConstructor = null;
            LOGGER.trace("No authentication used");
        }
        this._authConstructor = authConstructor;
        String maxLogin = this._args.getOpt("maxLogin");
        if (maxLogin != null) {
            try {
                this._maxLogin = Integer.parseInt(maxLogin);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this._maxLogin < 0) {
            LOGGER.info("Maximum login feature disabled");
        } else {
            LOGGER.info("Maximum logins set to: {}", (Object)this._maxLogin);
        }
        this._scheduledExecutor = Executors.newSingleThreadScheduledExecutor(this._nucleus);
        long keepAlive = TimeUnit.SECONDS.toMillis(this._args.getLongOption("keepAlive", 0L));
        LOGGER.info("Keep alive set to {} ms", (Object)keepAlive);
        this._keepAlive = new KeepAliveTask();
        this._keepAlive.schedule(keepAlive);
        this._locationManager = this._args.getOpt("lm");
        this._loginCellFactory = new LoginCellFactoryBuilder().setName(loginCell).setLoginManagerName(this.getCellName()).setArgs(childArgs).build();
        this._version = new CellVersion(Version.of((Object)this._loginCellFactory));
        String topic = this._args.getOpt("brokerTopic");
        if (topic != null) {
            Splitter byComma = Splitter.on((String)",").omitEmptyStrings();
            Splitter byColon = Splitter.on((String)":").omitEmptyStrings();
            this._loginBrokerPublisher = new LoginBrokerPublisher();
            this._loginBrokerPublisher.beforeSetup();
            this._loginBrokerPublisher.setExecutor(this._scheduledExecutor);
            this._loginBrokerPublisher.setTopic(topic);
            this._loginBrokerPublisher.setCellEndpoint(this);
            this._loginBrokerPublisher.setCellAddress(this._nucleus.getThisAddress());
            this._loginBrokerPublisher.setTags(byComma.splitToList((CharSequence)this._args.getOption("brokerTags")));
            this._loginBrokerPublisher.setProtocolEngine(this._loginCellFactory.getName());
            this._loginBrokerPublisher.setProtocolFamily(this._args.getOption("protocolFamily", this._protocol));
            this._loginBrokerPublisher.setProtocolVersion(this._args.getOption("protocolVersion", "1.0"));
            this._loginBrokerPublisher.setUpdateTime(this._args.getLongOption("brokerUpdateTime"));
            this._loginBrokerPublisher.setUpdateTimeUnit(TimeUnit.valueOf(this._args.getOption("brokerUpdateTimeUnit")));
            this._loginBrokerPublisher.setUpdateThreshold(this._args.getDoubleOption("brokerUpdateOffset"));
            this._loginBrokerPublisher.setRoot(Strings.emptyToNull((String)this._args.getOption("root")));
            this._loginBrokerPublisher.setReadPaths(byColon.splitToList((CharSequence)this._args.getOption("brokerReadPaths", "/")));
            this._loginBrokerPublisher.setWritePaths(byColon.splitToList((CharSequence)this._args.getOption("brokerWritePaths", "/")));
            this.addCommandListener(this._loginBrokerPublisher);
            this.addCellEventListener(this._loginBrokerPublisher);
            this._loginBrokerPublisher.afterSetup();
            if (this._maxLogin < 0) {
                this._maxLogin = 100000;
            }
        } else {
            this._loginBrokerPublisher = null;
        }
        this._nucleus.addCellEventListener(new LoginEventListener());
        this._listenThread = new ListenThread(listenPort);
    }

    @Override
    protected void started() {
        this._nucleus.newThread(this._listenThread, this.getCellName() + "-listen").start();
        if (this._locationManager != null) {
            new AsynchronousLocationRegistrationTask(this._locationManager).run();
        }
        if (this._loginBrokerPublisher != null) {
            this._loginBrokerPublisher.afterStart();
        }
    }

    @Override
    public void messageArrived(CellMessage envelope) {
        if (this._loginBrokerPublisher != null) {
            Serializable message = envelope.getMessageObject();
            if (message instanceof NoRouteToCellException) {
                this._loginBrokerPublisher.messageArrived((NoRouteToCellException)message);
            } else if (message instanceof LoginBrokerInfoRequest) {
                this._loginBrokerPublisher.messageArrived((LoginBrokerInfoRequest)message);
            }
        }
    }

    private static Class<?> toAuthClass(String authClassName, String protocol) throws ClassNotFoundException {
        Class<Object> authClass = null;
        if (authClassName == null) {
            switch (protocol) {
                case "raw": {
                    authClass = null;
                    break;
                }
                case "telnet": {
                    authClass = TelnetSAuth_A.class;
                }
            }
        } else if (!authClassName.equals("none")) {
            authClass = Class.forName(authClassName);
        }
        if (authClass != null) {
            LOGGER.info("Using authentication Module: {}", authClass);
        }
        return authClass;
    }

    private static String checkProtocol(String protocol) throws IllegalArgumentException {
        if (protocol == null) {
            protocol = "telnet";
        }
        if (!protocol.equals("telnet") && !protocol.equals("raw")) {
            throw new IllegalArgumentException("Protocol must be telnet or raw");
        }
        return protocol;
    }

    @Override
    public CellVersion getCellVersion() {
        return this._version;
    }

    public Object ac_get_children(Args args) {
        boolean binary = args.hasOption("binary");
        if (binary) {
            String[] list = this._children.keySet().toArray(new String[0]);
            return new LoginManagerChildrenInfo(this.getCellName(), this.getCellDomainName(), list);
        }
        StringBuilder sb = new StringBuilder();
        for (String child : this._children.keySet()) {
            sb.append(child).append("\n");
        }
        return sb.toString();
    }

    public String ac_set_keepalive_$_1(Args args) {
        long keepAlive = Long.parseLong(args.argv(0));
        this._keepAlive.schedule(keepAlive * 1000L);
        return "keepAlive value set to " + keepAlive + " seconds";
    }

    @Override
    public String toString() {
        ListenThread listenThread = this._listenThread;
        LoginCellFactory loginCellFactory = this._loginCellFactory;
        return "p=" + (listenThread == null ? "" : String.valueOf(listenThread.getListenPort())) + ";c=" + (loginCellFactory == null ? "" : loginCellFactory.getName());
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("  -- Login Manager");
        pw.println("  Listen Port    : " + this._listenThread.getListenPort());
        pw.println("  Protocol engine: " + this._loginCellFactory.getName());
        pw.println("  Protocol       : " + this._protocol);
        pw.println("  NioChannel     : " + (this._listenThread._serverSocket.getChannel() != null));
        pw.println("  Auth Class     : " + this._authClass);
        pw.println("  Logins created : " + this._loginCounter);
        pw.println("  Logins failed  : " + this._loginFailures);
        pw.println("  Logins denied  : " + this._connectionDeniedCounter);
        pw.println("  KeepAlive      : " + this._keepAlive.getKeepAlive() / 1000L);
        if (this._maxLogin > -1) {
            pw.println("  Logins/max     : " + this._children.size() + "/" + this._maxLogin);
        }
        if (this._locationManager != null) {
            pw.println("  Location Mgr   : " + this._locationManager + " (" + (this._sending ? "Sending" : "Informed") + ")");
        }
        if (this._loginBrokerPublisher != null) {
            pw.println("  LoginBroker Info :");
            this._loginBrokerPublisher.getInfo(pw);
        }
    }

    public String ac_set_max_logins_$_1(Args args) {
        int n = Integer.parseInt(args.argv(0));
        Preconditions.checkArgument((n == -1 || this._maxLogin >= 0 ? 1 : 0) != 0, (Object)"Can't switch off maxLogin feature");
        Preconditions.checkArgument((n >= 0 || this._maxLogin == -1 ? 1 : 0) != 0, (Object)"Can't switch on maxLogin feature");
        this._maxLogin = n;
        this.loadChanged();
        return "";
    }

    @Override
    public void cleanUp() {
        LOGGER.info("cleanUp requested by nucleus, closing listen socket");
        if (this._listenThread != null) {
            this._listenThread.shutdown();
        }
        if (this._loginBrokerPublisher != null) {
            this._loginBrokerPublisher.beforeStop();
        }
        if (this._scheduledExecutor != null) {
            this._scheduledExecutor.shutdown();
        }
        LOGGER.info("Bye Bye");
    }

    private void loadChanged() {
        int children = this._children.size();
        LOGGER.info("New child count : {}", (Object)children);
        if (this._loginBrokerPublisher != null) {
            this._loginBrokerPublisher.setLoad(children, this._maxLogin);
        }
    }

    public boolean validateUser(String userName, String password) {
        String[] request = new String[]{"request", userName, "check-password", userName, password};
        try {
            CellMessage msg = new CellMessage(this._authenticator, (Serializable)request);
            msg = this.getNucleus().sendAndWait(msg, 10000L);
            if (msg == null) {
                LOGGER.warn("Pam request timed out {}", (Object[])Thread.currentThread().getStackTrace());
                return false;
            }
            Object[] r = (Object[])msg.getMessageObject();
            return (Boolean)r[5];
        }
        catch (NoRouteToCellException e) {
            LOGGER.warn(e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            LOGGER.warn(e.getCause().getMessage());
            return false;
        }
    }

    private class RunEngineThread
    implements Runnable {
        private Socket _socket;

        private RunEngineThread(Socket socket) {
            this._socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread t = Thread.currentThread();
            InetSocketAddress remoteSocketAddress = (InetSocketAddress)this._socket.getRemoteSocketAddress();
            NDC.push((String)(InetAddresses.toUriString((InetAddress)remoteSocketAddress.getAddress()) + ":" + remoteSocketAddress.getPort()));
            try {
                LOGGER.info("acceptThread ({}): creating protocol engine", (Object)t);
                StreamEngine engine = LoginManager.this._authConstructor != null ? StreamEngineFactory.newStreamEngine(this._socket, LoginManager.this._protocol, LoginManager.this._nucleus, LoginManager.this.getArgs()) : StreamEngineFactory.newStreamEngineWithoutAuth(this._socket, LoginManager.this._protocol);
                String userName = Subjects.getDisplayName((Subject)engine.getSubject());
                LOGGER.info("acceptThread ({}): connection created for user {}", (Object)t, (Object)userName);
                int p = userName.indexOf(64);
                if (p > -1) {
                    userName = p == 0 ? "unknown" : userName.substring(0, p);
                }
                Cell cell = LoginManager.this._loginCellFactory.newCell(engine, userName);
                try {
                    Method m = cell.getClass().getMethod("getCellName", new Class[0]);
                    String cellName = (String)m.invoke((Object)cell, new Object[0]);
                    LOGGER.info("Invoked cell name : {}", (Object)cellName);
                    if (LoginManager.this._children.putIfAbsent(cellName, cell) == DEAD_CELL) {
                        LoginManager.this._children.remove(cellName, DEAD_CELL);
                    }
                    LoginManager.this.loadChanged();
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ee) {
                    LOGGER.warn("Can't determine child name", (Throwable)ee);
                }
                LoginManager.this._loginCounter.incrementAndGet();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                LOGGER.warn("Exception (ITE) in secure protocol : {}", cause);
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LoginManager.this._loginFailures.incrementAndGet();
            }
            catch (Exception e) {
                LOGGER.warn("Exception in secure protocol : {}", (Object)e.toString());
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LoginManager.this._loginFailures.incrementAndGet();
            }
            finally {
                NDC.pop();
            }
        }
    }

    public static class ShutdownEngine
    implements Runnable {
        private final Socket _socket;

        public ShutdownEngine(Socket socket) {
            this._socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InputStream inputStream = this._socket.getInputStream();
                OutputStream outputStream = this._socket.getOutputStream();
                outputStream.close();
                byte[] buffer = new byte[1024];
                while (inputStream.read(buffer, 0, buffer.length) > 0) {
                }
                inputStream.close();
            }
            catch (IOException ee) {
                LOGGER.warn("Shutdown : {}", (Object)ee.getMessage());
            }
            finally {
                try {
                    LOGGER.debug("Socket CLOSE (ACCEPT) remote = {} local = {}", (Object)this._socket.getRemoteSocketAddress(), (Object)this._socket.getLocalSocketAddress());
                    this._socket.close();
                }
                catch (IOException iOException) {}
            }
            LOGGER.info("Shutdown : done");
        }
    }

    private class ListenThread
    implements Runnable {
        private static final int SHUTDOWN_TIMEOUT = 60000;
        private final InetSocketAddress _socketAddress;
        private final Constructor<?> _ssfConstructor;
        private final String _factoryArgs;
        private final long _acceptErrorTimeout;
        private volatile boolean _shutdown;
        private ServerSocket _serverSocket;

        private ListenThread(int listenPort) throws Exception {
            long timeout;
            try {
                timeout = Long.parseLong(LoginManager.this._args.getOpt("acceptErrorWait"));
            }
            catch (NumberFormatException e) {
                timeout = 0L;
            }
            this._acceptErrorTimeout = timeout;
            String listen = LoginManager.this._args.getOpt("listen");
            this._socketAddress = Strings.isNullOrEmpty((String)listen) ? new InetSocketAddress(listenPort) : new InetSocketAddress(InetAddress.getByName(listen), listenPort);
            String ssf = LoginManager.this._args.getOpt("socketfactory");
            if (ssf != null) {
                Constructor<?> constructor;
                Args args = new Args((CharSequence)ssf);
                Preconditions.checkArgument((args.argc() >= 1 ? 1 : 0) != 0, (Object)"Invalid Arguments for 'socketfactory'");
                String tunnelFactoryClass = args.argv(0);
                args.shift();
                this._factoryArgs = args.toString();
                Class<?> ssfClass = Class.forName(tunnelFactoryClass);
                try {
                    constructor = ssfClass.getConstructor(String.class, Map.class);
                }
                catch (Exception ee) {
                    constructor = ssfClass.getConstructor(String.class);
                }
                this._ssfConstructor = constructor;
            } else {
                this._ssfConstructor = null;
                this._factoryArgs = null;
            }
            this.openPort();
        }

        private void openPort() throws Exception {
            if (this._ssfConstructor == null) {
                this._serverSocket = ServerSocketChannel.open().socket();
            } else {
                Object obj;
                try {
                    if (this._ssfConstructor.getParameterTypes().length == 2) {
                        HashMap map = Maps.newHashMap(LoginManager.this.getDomainContext());
                        map.put("UserValidatable", LoginManager.this);
                        obj = this._ssfConstructor.newInstance(this._factoryArgs, map);
                    } else {
                        obj = this._ssfConstructor.newInstance(this._factoryArgs);
                    }
                }
                catch (InvocationTargetException e) {
                    Throwables.propagateIfPossible((Throwable)e.getCause(), Exception.class);
                    throw new RuntimeException(e);
                }
                Method meth = obj.getClass().getMethod("createServerSocket", new Class[0]);
                this._serverSocket = (ServerSocket)meth.invoke(obj, new Object[0]);
                LOGGER.info("ListenThread : got serverSocket class : {}", (Object)this._serverSocket.getClass().getName());
            }
            this._serverSocket.bind(this._socketAddress);
            if (LoginManager.this._loginBrokerPublisher != null) {
                LoginManager.this._loginBrokerPublisher.setSocketAddress(this._socketAddress);
            }
            LOGGER.info("Listening on {}", (Object)this._serverSocket.getLocalSocketAddress());
            LOGGER.trace("Nio Socket Channel : {}", (Object)(this._serverSocket.getChannel() != null ? 1 : 0));
        }

        public int getListenPort() {
            return this._serverSocket.getLocalPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            ExecutorService executor = Executors.newCachedThreadPool(LoginManager.this._nucleus);
            try {
                LoginManager.this._loginCellFactory.startAsync().awaitRunning();
                while (!this._serverSocket.isClosed()) {
                    try {
                        Socket socket = this._serverSocket.accept();
                        socket.setKeepAlive(true);
                        socket.setTcpNoDelay(true);
                        LOGGER.debug("Socket OPEN (ACCEPT) remote = {} local = {}", (Object)socket.getRemoteSocketAddress(), (Object)socket.getLocalSocketAddress());
                        LOGGER.info("Nio Channel (accept) : {}", (Object)(socket.getChannel() != null ? 1 : 0));
                        int currentChildCount = LoginManager.this._children.size();
                        LOGGER.info("New connection : {}", (Object)currentChildCount);
                        if (LoginManager.this._maxLogin > -1 && currentChildCount >= LoginManager.this._maxLogin) {
                            LoginManager.this._connectionDeniedCounter.incrementAndGet();
                            LOGGER.warn("Connection denied: Number of allowed logins exceeded ({} > {}).", (Object)currentChildCount, (Object)LoginManager.this._maxLogin);
                            executor.execute(new ShutdownEngine(socket));
                            continue;
                        }
                        LOGGER.info("Connection request from {}", (Object)socket.getInetAddress());
                        executor.execute(new RunEngineThread(socket));
                    }
                    catch (InterruptedIOException ioe) {
                        LOGGER.debug("Listen thread interrupted");
                        try {
                            this._serverSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (IOException ioe) {
                        if (this._serverSocket.isClosed()) continue;
                        LOGGER.error("I/O error: {}", (Object)ioe.toString());
                        try {
                            this._serverSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (this._acceptErrorTimeout <= 0L) continue;
                        ListenThread listenThread = this;
                        // MONITORENTER : listenThread
                        while (!this._shutdown && this._serverSocket.isClosed()) {
                            LOGGER.warn("Sleeping {} ms before reopening server socket", (Object)this._acceptErrorTimeout);
                            this.wait(this._acceptErrorTimeout);
                            if (this._shutdown) continue;
                            try {
                                this.openPort();
                                LOGGER.warn("Resuming operation");
                            }
                            catch (Exception ee) {
                                LOGGER.warn("Failed to open socket: {}", (Object)ee.toString());
                            }
                        }
                        // MONITOREXIT : listenThread
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                this.terminateChildren();
                this.shutdownAndAwaitTermination(executor);
                this.terminateChildren();
                this.awaitTerminationOfChildren();
                LoginManager.this._loginCellFactory.stopAsync();
                LOGGER.trace("Listen thread finished");
            }
        }

        private void shutdownAndAwaitTermination(ExecutorService executor) {
            executor.shutdown();
            try {
                executor.awaitTermination(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void awaitTerminationOfChildren() {
            try {
                for (Object child : LoginManager.this._children.values()) {
                    if (!(child instanceof CellAdapter)) continue;
                    LoginManager.this.getNucleus().join(((CellAdapter)child).getCellName());
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }

        private void terminateChildren() {
            for (Object child : LoginManager.this._children.values()) {
                if (!(child instanceof CellAdapter)) continue;
                try {
                    LoginManager.this.getNucleus().kill(((CellAdapter)child).getCellName());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }

        public synchronized void shutdown() {
            LOGGER.info("Listen thread shutdown requested");
            if (this._shutdown || this._serverSocket == null) {
                return;
            }
            this._shutdown = true;
            try {
                LOGGER.debug("Socket SHUTDOWN local = {}", (Object)this._serverSocket.getLocalSocketAddress());
                this._serverSocket.close();
            }
            catch (IOException ee) {
                LOGGER.warn("ServerSocket close: {}", (Object)ee.toString());
            }
            this.notifyAll();
            LOGGER.info("Shutdown sequence done");
        }
    }

    private class KeepAliveTask
    implements Runnable {
        private ScheduledFuture<?> _future;
        private long _keepAlive;

        private KeepAliveTask() {
        }

        @Override
        public void run() {
            try {
                for (Object o : LoginManager.this._children.values()) {
                    if (!(o instanceof KeepAliveListener)) continue;
                    try {
                        ((KeepAliveListener)o).keepAlive();
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Problem reported by : {} : {}", o, (Object)t);
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.warn("runKeepAlive reported : {}", (Object)t.toString());
            }
        }

        public synchronized void schedule(long keepAlive) {
            this._keepAlive = keepAlive;
            if (this._future != null) {
                this._future.cancel(false);
            }
            this._future = this._keepAlive > 0L ? LoginManager.this._scheduledExecutor.scheduleWithFixedDelay(this, this._keepAlive, this._keepAlive, TimeUnit.MILLISECONDS) : null;
            LOGGER.info("Keep Alive value changed to {}", (Object)this._keepAlive);
        }

        public synchronized long getKeepAlive() {
            return this._keepAlive;
        }
    }

    private class AsynchronousLocationRegistrationTask
    implements CellMessageAnswerable,
    Runnable {
        private final int _port;
        private final CellPath _path;

        public AsynchronousLocationRegistrationTask(String dest) {
            this._port = LoginManager.this._listenThread.getListenPort();
            this._path = new CellPath(dest);
        }

        @Override
        public void run() {
            LOGGER.info("Sending 'listening on {} {}'", (Object)LoginManager.this.getCellName(), (Object)this._port);
            LoginManager.this.sendMessage(new CellMessage(this._path, (Serializable)((Object)("listening on " + LoginManager.this.getCellName() + " " + this._port))), this, MoreExecutors.directExecutor(), 5000L);
        }

        @Override
        public void answerArrived(CellMessage request, CellMessage answer) {
            LOGGER.info("Port number successfully sent to {}", (Object)this._path);
            LoginManager.this._sending = false;
        }

        @Override
        public void exceptionArrived(CellMessage request, Exception exception) {
            LOGGER.warn("Problem sending port number {}", (Object)exception.toString());
            LoginManager.this._scheduledExecutor.schedule(this, 10L, TimeUnit.SECONDS);
        }

        @Override
        public void answerTimedOut(CellMessage request) {
            LOGGER.warn("No reply from {}", (Object)this._path);
            LoginManager.this._scheduledExecutor.schedule(this, 10L, TimeUnit.SECONDS);
        }
    }

    private class LoginEventListener
    implements CellEventListener {
        private LoginEventListener() {
        }

        @Override
        public void cellCreated(CellEvent ce) {
        }

        @Override
        public void cellDied(CellEvent ce) {
            String removedCell = ce.getSource().toString();
            if (!removedCell.startsWith(LoginManager.this.getCellName())) {
                return;
            }
            Object cell = LoginManager.this._children.putIfAbsent(removedCell, DEAD_CELL);
            if (cell != null) {
                LoginManager.this._children.remove(removedCell, cell);
            }
            LOGGER.info("LoginEventListener : removing : {}", (Object)removedCell);
            LoginManager.this.loadChanged();
        }

        @Override
        public void routeAdded(CellEvent ce) {
        }

        @Override
        public void routeDeleted(CellEvent ce) {
        }
    }
}

