/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.CellNucleus;
import dmg.cells.services.login.TelnetSAuth_A;
import dmg.protocols.telnet.TelnetServerAuthentication;
import dmg.protocols.telnet.TelnetStreamEngine;
import dmg.util.DummyStreamEngine;
import dmg.util.StreamEngine;
import java.net.Socket;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamEngineFactory {
    private static Logger _log = LoggerFactory.getLogger(StreamEngineFactory.class);

    public static StreamEngine newStreamEngine(Socket socket, String protocol, CellNucleus nucleusForAuth, Args argsForAuth) throws Exception {
        DummyStreamEngine engine = null;
        switch (protocol) {
            case "raw": {
                _log.info("No authentication used");
                engine = new DummyStreamEngine(socket);
                break;
            }
            case "telnet": {
                TelnetSAuth_A auth = new TelnetSAuth_A(nucleusForAuth, argsForAuth);
                _log.info("Using authentication Module : " + TelnetSAuth_A.class);
                engine = new TelnetStreamEngine(socket, auth);
                break;
            }
            default: {
                _log.error("can't instantiate corresponding streamengine {}", (Object)protocol);
            }
        }
        return engine;
    }

    public static StreamEngine newStreamEngineWithoutAuth(Socket socket, String protocol) throws Exception {
        DummyStreamEngine engine = null;
        switch (protocol) {
            case "raw": {
                _log.info("No authentication used");
                engine = new DummyStreamEngine(socket);
                break;
            }
            case "telnet": {
                TelnetServerAuthentication auth = null;
                _log.info("No authentication used");
                engine = new TelnetStreamEngine(socket, auth);
                break;
            }
            default: {
                _log.error("can't instantiate corresponding streamengine {}", (Object)protocol);
            }
        }
        return engine;
    }
}

