/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import com.google.common.base.Preconditions;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.services.login.Crypt;
import dmg.cells.services.login.user.AclDb;
import dmg.cells.services.login.user.AclPermissionException;
import dmg.cells.services.login.user.FileUserRelation;
import dmg.cells.services.login.user.InMemoryUserRelation;
import dmg.cells.services.login.user.UserAdminCommands;
import dmg.cells.services.login.user.UserMetaDb;
import dmg.cells.services.login.user.UserMetaDictionary;
import dmg.cells.services.login.user.UserRelationable;
import dmg.util.Authorizable;
import dmg.util.UserPasswords;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.dcache.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclCell
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(AclCell.class);
    private AclDb _aclDb;
    private UserRelationable _userDb;
    private UserMetaDb _userMetaDb;
    private UserPasswords _sysPassword;
    private UserPasswords _egPassword;
    private Crypt _crypt = new Crypt();
    private static final String DUMMY_ADMIN = "5t2Hw7lNqVock";
    public static final String hh_set_passwd = "[-user=<userName>] [-old=<oldPasswd>] newPswd verifyPswd";

    public AclCell(String name, String argString) {
        super(name, argString);
    }

    @Override
    protected void startUp() {
        Args args = this.getArgs();
        Preconditions.checkArgument((args.argc() >= 1 ? 1 : 0) != 0, (Object)"Usage : ... <dbPath>");
        File dbBase = new File(args.argv(0));
        this._aclDb = new AclDb(new File(dbBase, "acls"));
        this._userDb = new InMemoryUserRelation(new FileUserRelation(new File(dbBase, "relations")));
        this._userMetaDb = new UserMetaDb(new File(dbBase, "meta"));
        UserAdminCommands uac = new UserAdminCommands(this._userDb, this._aclDb, this._userMetaDb);
        this.addCommandListener(uac);
        this.setCommandExceptionEnabled(true);
        String tmp = args.getOpt("syspassword");
        if (tmp != null) {
            this._sysPassword = new UserPasswords(new File(tmp));
            _log.info("using as SystemPasswordfile : " + tmp);
        }
        if ((tmp = args.getOpt("egpassword")) != null) {
            this._egPassword = new UserPasswords(new File(tmp));
            _log.info("using as EgPasswordfile : " + tmp);
        }
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Serializable answer;
        block16: {
            Serializable obj = msg.getMessageObject();
            try {
                _log.info("Message type : " + obj.getClass());
                if (obj instanceof Object[] && ((Object[])obj).length >= 3 && ((Object[])obj)[0].equals("request")) {
                    Object[] request = (Object[])obj;
                    String user = request[1] == null ? "unknown" : (String)request[1];
                    String command = (String)request[2];
                    _log.info(">" + command + "< request from " + user);
                    try {
                        switch (command) {
                            case "check-password": {
                                answer = this.acl_check_password(request);
                                break;
                            }
                            case "check-permission": {
                                answer = this.acl_check_permission(request);
                                break;
                            }
                            case "get-metainfo": {
                                answer = this.acl_get_metainfo(request);
                                break;
                            }
                            default: {
                                throw new Exception("Command not found : " + command);
                            }
                        }
                        break block16;
                    }
                    catch (Exception xe) {
                        throw new Exception("Problem : " + xe);
                    }
                }
                String r = "Illegal message object received from : " + msg.getSourcePath();
                _log.warn(r);
                throw new Exception(r);
            }
            catch (Exception iex) {
                answer = iex;
            }
        }
        if (answer instanceof Object[]) {
            ((Object[])answer)[0] = "response";
        }
        msg.revertDirection();
        msg.setMessageObject(answer);
        this.sendMessage(msg);
    }

    private Serializable acl_get_metainfo(Object[] request) {
        if (request.length < 5 || request[3] == null || request[4] == null) {
            throw new IllegalArgumentException("Not enough or illegal arguments for 'check-password'");
        }
        String userName = request[3].toString();
        UserMetaDictionary dict = this._userMetaDb.getDictionary(userName);
        if (dict == null) {
            throw new IllegalArgumentException("No such user : " + userName);
        }
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(request).subList(0, 5));
        StringTokenizer st = new StringTokenizer(request[4].toString(), ",");
        while (st.hasMoreTokens()) {
            result.add(dict.valueOf(st.nextToken()));
        }
        return result.toArray(new Object[result.size()]);
    }

    private Serializable acl_check_password(Object[] request) {
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'check-password'");
        }
        Object[] response = new Object[6];
        System.arraycopy(request, 0, response, 0, 5);
        response[1] = request[3];
        String userName = (String)request[3];
        String password = (String)request[4];
        response[5] = this.matchPassword(userName, password);
        return response;
    }

    private Serializable acl_check_permission(Object[] request) {
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'check-permission'");
        }
        Object[] response = new Object[6];
        System.arraycopy(request, 0, response, 0, 5);
        response[1] = request[3];
        String userName = (String)request[3];
        String acl = (String)request[4];
        response[5] = this.checkPermission(userName, acl);
        return response;
    }

    private boolean checkPermission(String user, String acl) {
        if (user.equals("admin")) {
            return true;
        }
        try {
            if (this._aclDb.check(acl, user, this._userDb)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this._aclDb.check("super.access", user, this._userDb)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean matchPassword(String userName, String password) {
        this.updatePassword();
        try {
            String pswd;
            if (userName.equals("admin")) {
                String pswd2;
                if (!(this._sysPassword != null && (pswd2 = this._sysPassword.getPassword(userName)) != null || this._egPassword != null && (pswd2 = this._egPassword.getPassword(userName)) != null)) {
                    pswd2 = DUMMY_ADMIN;
                }
                return this._crypt.crypt(pswd2, password).equals(pswd2);
            }
            UserMetaDictionary dict = this._userMetaDb.getDictionary(userName);
            if (dict == null) {
                return false;
            }
            String dis = dict.valueOf("login");
            if (dis != null && dis.equals("no")) {
                return false;
            }
            if (!(this._sysPassword != null && (pswd = this._sysPassword.getPassword(userName)) != null || this._egPassword != null && (pswd = this._egPassword.getPassword(userName)) != null)) {
                return false;
            }
            return this._crypt.crypt(pswd, password).equals(pswd);
        }
        catch (Throwable t) {
            _log.warn("Found : " + t);
            return false;
        }
    }

    private void updatePassword() {
        try {
            if (this._sysPassword != null) {
                this._sysPassword.update();
            }
        }
        catch (Exception ee) {
            _log.warn("Updating failed : " + this._sysPassword);
        }
        try {
            if (this._egPassword != null) {
                this._egPassword.update();
            }
        }
        catch (Exception ee) {
            _log.warn("Updating failed : " + this._egPassword);
        }
    }

    private void checkPermission(Args args, String acl) throws Exception {
        if (!(args instanceof Authorizable)) {
            throw new AclPermissionException("Command not authorizable");
        }
        String user = ((Authorizable)args).getAuthorizedPrincipal();
        if (user.equals("admin")) {
            return;
        }
        try {
            if (this._aclDb.check("super.access", user, this._userDb)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this._aclDb.check(acl, user, this._userDb)) {
            throw new AclPermissionException("Acl >" + acl + "< negative for " + user);
        }
    }

    public String ac_interrupted(Args args) {
        return "\n";
    }

    public String ac_set_passwd_$_2(Args args) throws Exception {
        String[] record;
        String pswd2;
        if (this._egPassword == null) {
            throw new AclPermissionException("No private password file found");
        }
        if (!(args instanceof Authorizable)) {
            throw new AclPermissionException("Command not authorizable");
        }
        String pswd1 = args.argv(0);
        if (!pswd1.equals(pswd2 = args.argv(1))) {
            throw new IllegalArgumentException("pswd1 doesn't match pswd2");
        }
        String auth = ((Authorizable)args).getAuthorizedPrincipal();
        String user = args.getOpt("user");
        user = user == null ? auth : user;
        String old = args.getOpt("old");
        String acl = "user." + user + ".setpassword";
        if (!auth.equals("admin") && !this._aclDb.check(acl, auth, this._userDb)) {
            if (auth.equals(user)) {
                if (old == null) {
                    throw new IllegalArgumentException("-old=<oldPassword> option missing");
                }
            } else {
                throw new AclPermissionException("Acl >" + acl + "< negative for " + auth);
            }
            pswd2 = this._egPassword.getPassword(user);
            if (pswd2 == null) {
                throw new IllegalArgumentException("User not found in private passwd file");
            }
            if (!this._crypt.crypt(pswd2, old).equals(pswd2)) {
                throw new IllegalArgumentException("Old password doesn't match");
            }
            record = this._egPassword.getRecord(user);
            if (record == null) {
                throw new IllegalArgumentException("User " + user + " doesn't exist");
            }
        } else {
            record = this._egPassword.getRecord(user);
            if (record == null) {
                record = new String[]{user, this._crypt.crypt(user.substring(0, 2), pswd1)};
            }
        }
        this._egPassword.addRecord(record);
        this._egPassword.commit();
        return "";
    }
}

