/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.services.login.user.AcDictionary;
import dmg.cells.services.login.user.AclDb;
import dmg.cells.services.login.user.AclPermissionException;
import dmg.cells.services.login.user.DatabaseException;
import dmg.cells.services.login.user.UserMetaDb;
import dmg.cells.services.login.user.UserMetaDictionary;
import dmg.cells.services.login.user.UserRelationable;
import dmg.util.Authorizable;
import dmg.util.CommandSyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dcache.util.Args;

public class UserAdminCommands {
    private AclDb _aclDb;
    private UserRelationable _userDb;
    private UserMetaDb _userMetaDb;
    public static final String hh_create_user = "<userName>";
    public static final String hh_create_group = "<groupName>";
    public static final String hh_destroy_principal = "<principalName>";
    public static final String hh_add = "<principalName> to <groupName>";
    public static final String hh_remove = "<principalName> from <groupName>";
    public static final String hh_show_parents = "<principal>";
    public static final String hh_show_group = "<group>";
    public static final String hh_show_groups = "";
    public static final String hh_add_access = "[-allowed|-denied] <acl> <principal>";
    public static final String hh_remove_access = "<acl> <principal>";
    public static final String hh_create_acl = "<aclName>";
    public static final String hh_destroy_acl = "<aclName>";
    public static final String hh_show_acl = "<aclName> [-resolve]";
    public static final String hh_check = "<acl> <user>";
    public static final String hh_show_principal = "<principalName>";
    public static final String hh_set_principal = "<principalName> <key>=<value> [...]";
    public static final String hh_let = "<aclName> inheritfrom <aclNameFrom>";

    public UserAdminCommands(UserRelationable userDb, AclDb aclDb, UserMetaDb metaDb) {
        this._userDb = userDb;
        this._aclDb = aclDb;
        this._userMetaDb = metaDb;
    }

    private void checkDatabase() throws Exception {
        if (this._userMetaDb != null && this._aclDb != null && this._userDb != null) {
            return;
        }
        throw new Exception("Not all databases are open");
    }

    private void checkPermission(Args args, String acl) throws Exception {
        if (!(args instanceof Authorizable)) {
            return;
        }
        String user = ((Authorizable)args).getAuthorizedPrincipal();
        if (user.equals("admin")) {
            return;
        }
        if (!this._aclDb.check("super.access", user, this._userDb) && !this._aclDb.check(acl, user, this._userDb)) {
            throw new AclPermissionException("Acl >" + acl + "< negative for " + user);
        }
    }

    public String ac_create_user_$_1(Args args) throws Exception {
        this.checkDatabase();
        String user = args.argv(0);
        this.checkPermission(args, "user." + user + ".create");
        this._userMetaDb.createUser(user);
        return hh_show_groups;
    }

    public String ac_create_group_$_1(Args args) throws Exception {
        this.checkDatabase();
        String group = args.argv(0);
        this.checkPermission(args, "user." + group + ".create");
        this._userMetaDb.createGroup(group);
        this._userDb.createContainer(group);
        this._aclDb.createAclItem("user." + group + ".modify");
        return hh_show_groups;
    }

    public String ac_destroy_principal_$_1(Args args) throws Exception {
        this.checkDatabase();
        String user = args.argv(0);
        this.checkPermission(args, "user." + user + ".destroy");
        try {
            UserMetaDictionary dict = this._userMetaDb.getDictionary(user);
            String type = dict.valueOf("type");
            if (type == null) {
                throw new DatabaseException("Principal type not defined in meta database");
            }
            switch (type) {
                case "user": {
                    try {
                        Enumeration<String> e = this._userDb.getParentsOf(user);
                        if (e.hasMoreElements()) {
                            throw new DatabaseException("Still in groups : " + user);
                        }
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                    this._userMetaDb.removePrincipal(user);
                    break;
                }
                case "group": {
                    Enumeration<String> e = this._userDb.getElementsOf(user);
                    if (e.hasMoreElements()) {
                        throw new DatabaseException("Not Empty : " + user);
                    }
                    e = this._userDb.getParentsOf(user);
                    if (e.hasMoreElements()) {
                        throw new DatabaseException("Still in groups : " + user);
                    }
                    this._userMetaDb.removePrincipal(user);
                    this._userDb.removeContainer(user);
                    this._aclDb.removeAclItem("user." + user + ".access");
                    break;
                }
                default: {
                    throw new DatabaseException("Invalid principal type : " + type);
                }
            }
        }
        catch (Exception ie) {
            ie.printStackTrace();
            throw ie;
        }
        return hh_show_groups;
    }

    public String ac_add_$_3(Args args) throws Exception {
        this.checkDatabase();
        if (!args.argv(1).equals("to")) {
            throw new CommandSyntaxException("keyword 'to' missing");
        }
        String group = args.argv(2);
        String princ = args.argv(0);
        this.checkPermission(args, "user." + group + ".add");
        this._userDb.addElement(group, princ);
        return hh_show_groups;
    }

    public String ac_remove_$_3(Args args) throws Exception {
        this.checkDatabase();
        if (!args.argv(1).equals("from")) {
            throw new CommandSyntaxException("keyword 'from' missing");
        }
        String group = args.argv(2);
        String princ = args.argv(0);
        this.checkPermission(args, "user." + group + ".remove");
        this._userDb.removeElement(group, princ);
        return hh_show_groups;
    }

    public Object ac_show_parents_$_1(Args args) {
        String user = args.argv(0);
        boolean isBinary = args.hasOption("binary");
        this._userMetaDb.getDictionary(user);
        try {
            Enumeration<String> e = this._userDb.getParentsOf(user);
            return isBinary ? this.sendBinary(e) : this.sendAscii(e);
        }
        catch (NoSuchElementException eee) {
            return isBinary ? new Vector() : hh_show_groups;
        }
    }

    public Object ac_show_group_$_1(Args args) {
        Enumeration<String> ee = this._userDb.getElementsOf(args.argv(0));
        Enumeration<String> ep = this._userDb.getParentsOf(args.argv(0));
        if (!args.hasOption("binary")) {
            StringBuilder sb = new StringBuilder();
            sb.append("Parents : \n");
            while (ep.hasMoreElements()) {
                sb.append("  ").append(ep.nextElement()).append("\n");
            }
            sb.append("Elements : \n");
            while (ee.hasMoreElements()) {
                sb.append("  ").append(ee.nextElement()).append("\n");
            }
            return sb.toString();
        }
        Vector[] v = new Vector[]{this.sendBinary(ep), this.sendBinary(ee)};
        return v;
    }

    public Object ac_show_groups(Args args) {
        Enumeration<String> e = this._userDb.getContainers();
        return !args.hasOption("binary") ? this.sendAscii(e) : this.sendBinary(e);
    }

    private String sendAscii(Enumeration<String> e) {
        StringBuilder sb = new StringBuilder();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement()).append("\n");
        }
        return sb.toString();
    }

    private Object sendBinary(Enumeration<String> e) {
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return v;
    }

    public String ac_add_access_$_2(Args args) throws Exception {
        this.checkDatabase();
        boolean allowed = !args.hasOption("denied");
        String acl = args.argv(0);
        String princ = args.argv(1);
        this.checkPermission(args, "acl." + acl + ".add");
        if (allowed) {
            this._aclDb.addAllowed(acl, princ);
        } else {
            this._aclDb.addDenied(acl, princ);
        }
        return hh_show_groups;
    }

    public String ac_remove_access_$_2(Args args) throws Exception {
        String acl = args.argv(0);
        String princ = args.argv(1);
        this.checkPermission(args, "acl." + acl + ".remove");
        this._aclDb.removeUser(acl, princ);
        return hh_show_groups;
    }

    public String ac_create_acl_$_1(Args args) throws Exception {
        this.checkDatabase();
        String aclName = args.argv(0);
        this.checkPermission(args, "acl." + aclName + ".create");
        this._aclDb.createAclItem(aclName);
        return hh_show_groups;
    }

    public String ac_destroy_acl_$_1(Args args) throws Exception {
        this.checkDatabase();
        String aclName = args.argv(0);
        this.checkPermission(args, "acl." + aclName + ".destroy");
        this._aclDb.removeAclItem(aclName);
        return hh_show_groups;
    }

    public Object ac_show_acl_$_1(Args args) throws Exception {
        this.checkDatabase();
        boolean resolve = args.hasOption("resolve");
        AcDictionary dict = this._aclDb.getPermissions(args.argv(0), resolve);
        Enumeration<String> e = dict.getPrincipals();
        String inherits = dict.getInheritance();
        StringBuilder sb = new StringBuilder();
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        if (!resolve) {
            if (inherits == null) {
                sb.append("<noinheritance>\n");
                hash.put("<inheritsFrom>", "none");
            } else {
                sb.append("<inherits=").append(inherits).append(">\n");
                hash.put("<inheritsFrom>", inherits);
            }
        }
        while (e.hasMoreElements()) {
            String user = e.nextElement();
            boolean perm = dict.getPermission(user);
            sb.append(user).append(" -> ").append(perm).append("\n");
            hash.put(user, perm);
        }
        return !args.hasOption("binary") ? sb.toString() : hash;
    }

    public Object ac_check_$_2(Args args) throws Exception {
        this.checkDatabase();
        boolean ok = this._aclDb.check(args.argv(0), args.argv(1), this._userDb);
        if (args.hasOption("binary")) {
            return ok;
        }
        return (ok ? "Allowed" : "Denied") + "\n";
    }

    public Object ac_show_principal_$_1(Args args) {
        UserMetaDictionary dict = this._userMetaDb.getDictionary(args.argv(0));
        Enumeration<String> e = dict.keys();
        if (!args.hasOption("binary")) {
            StringBuilder sb = new StringBuilder();
            while (e.hasMoreElements()) {
                String user = e.nextElement();
                sb.append(user).append(" -> ").append(dict.valueOf(user)).append("\n");
            }
            return sb.toString();
        }
        Hashtable<String, String> hash = new Hashtable<String, String>();
        while (e.hasMoreElements()) {
            String user = e.nextElement();
            hash.put(user, dict.valueOf(user));
        }
        return hash;
    }

    public String ac_set_principal_$_1_99(Args args) throws Exception {
        this.checkPermission(args, "user." + args.argv(0) + ".modify");
        for (int i = 1; i < args.argc(); ++i) {
            String value;
            StringTokenizer st = new StringTokenizer(args.argv(i), "=");
            String key = st.nextToken();
            try {
                value = st.nextToken();
            }
            catch (Exception ee) {
                value = hh_show_groups;
            }
            this._userMetaDb.setAttribute(args.argv(0), key, value);
        }
        return hh_show_groups;
    }

    public String ac_let_$_3(Args args) throws Exception {
        if (!args.argv(1).equals("inheritfrom")) {
            throw new CommandSyntaxException("keyword 'inheritfrom' missing");
        }
        this.checkPermission(args, "acl." + args.argv(0) + ".modify");
        this._aclDb.setInheritance(args.argv(0), args.argv(2));
        return hh_show_groups;
    }
}

