/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.services.login.user.AgingHash;
import dmg.cells.services.login.user.DatabaseException;
import dmg.cells.services.login.user.UserMetaDictionary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class UserMetaDb {
    private File _userMetaDir;
    private AgingHash _hash = new AgingHash(20);

    public UserMetaDb(File userMetaDir) {
        if (!userMetaDir.isDirectory()) {
            throw new IllegalArgumentException("Not a user meta DB(not a dir)" + userMetaDir);
        }
        this._userMetaDir = userMetaDir;
    }

    public synchronized boolean isGroup(String principalName) {
        UserMetaItem item;
        try {
            item = this.getUser(principalName);
        }
        catch (Exception ii) {
            return false;
        }
        String type = item.getAttribute("type");
        if (type == null) {
            return false;
        }
        return type.equals("group");
    }

    public synchronized boolean exists(String principalName) {
        UserMetaItem item;
        try {
            item = this.getUser(principalName);
        }
        catch (Exception ii) {
            return false;
        }
        String type = item.getAttribute("type");
        return type != null;
    }

    private void putUser(String userName, UserMetaItem item) throws DatabaseException {
        this._storeUser(userName, item);
        this._hash.put(userName, item);
    }

    private UserMetaItem getUser(String userName) throws NoSuchElementException {
        UserMetaItem item = (UserMetaItem)this._hash.get(userName);
        if (item != null) {
            return item;
        }
        return this._loadUser(userName);
    }

    private void _storeUser(String userName, UserMetaItem item) throws DatabaseException {
        PrintWriter pw;
        File file = new File(this._userMetaDir, "." + userName);
        try {
            pw = new PrintWriter(new FileWriter(file));
        }
        catch (IOException ioe) {
            throw new DatabaseException("Can't create : " + userName);
        }
        Enumeration e = item.getAttributes();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            pw.println(key + "=" + item.getAttribute(key));
        }
        pw.close();
        file.renameTo(new File(this._userMetaDir, userName));
    }

    private UserMetaItem _loadUser(String userName) throws NoSuchElementException {
        BufferedReader br;
        File file = new File(this._userMetaDir, userName);
        if (!file.exists()) {
            throw new NoSuchElementException("User not found : " + userName);
        }
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (IOException e) {
            throw new NoSuchElementException("No found " + file);
        }
        UserMetaItem item = new UserMetaItem(userName);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, "=");
                String key = st.nextToken();
                String value = st.nextToken();
                item.addAttribute(key, value);
            }
        }
        catch (NoSuchElementException nsee) {
            throw new NoSuchElementException("Syntax error in " + file);
        }
        catch (Exception ioe) {
            throw new NoSuchElementException("IOError on " + file);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        return item;
    }

    public synchronized void createUser(String userName) throws DatabaseException {
        try {
            this.getUser(userName);
        }
        catch (Exception ii) {
            UserMetaItem item = new UserMetaItem(userName);
            item.addAttribute("type", "user");
            this.putUser(userName, item);
            return;
        }
        throw new DatabaseException("Already exists : " + userName);
    }

    public synchronized void createGroup(String groupName) throws DatabaseException {
        try {
            this.getUser(groupName);
        }
        catch (Exception ii) {
            UserMetaItem item = new UserMetaItem(groupName);
            item.addAttribute("type", "group");
            this.putUser(groupName, item);
            return;
        }
        throw new DatabaseException("Already exists : " + groupName);
    }

    public synchronized void removePrincipal(String principalName) throws NoSuchElementException {
        this._hash.remove(principalName);
        boolean ok = new File(this._userMetaDir, principalName).delete();
        if (!ok) {
            throw new NoSuchElementException("Not found : " + principalName);
        }
    }

    public synchronized void setAttribute(String principalName, String key, String value) throws DatabaseException {
        UserMetaItem item = this.getUser(principalName);
        item.addAttribute(key, value);
        this.putUser(principalName, item);
    }

    public synchronized UserMetaDictionary getDictionary(String principalName) throws NoSuchElementException {
        return this.getUser(principalName);
    }

    public synchronized void removeAttribute(String principalName, String key) throws DatabaseException {
        UserMetaItem item = this.getUser(principalName);
        item.removeAttribute(key);
        this.putUser(principalName, item);
    }

    private class UserMetaItem
    implements UserMetaDictionary {
        private String _name;
        private Hashtable<String, String> _attr = new Hashtable();

        private UserMetaItem(String name) {
            this._name = name;
        }

        private void addAttribute(String key, String value) {
            this._attr.put(key, value);
        }

        private Enumeration<String> getAttributes() {
            return this._attr.keys();
        }

        private void removeAttribute(String key) {
            this._attr.remove(key);
        }

        private String getAttribute(String key) {
            String attr = this._attr.get(key);
            if (attr == null) {
                return "<notSet>";
            }
            return attr;
        }

        @Override
        public Enumeration<String> keys() {
            return this._attr.keys();
        }

        @Override
        public String valueOf(String key) {
            return this._attr.get(key);
        }
    }
}

