/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.services.login.user.DatabaseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class UserRelationDb {
    private File _dbDir;
    private Hashtable<String, ElementItem> _elements;

    public UserRelationDb(File dbDir) throws DatabaseException {
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            throw new DatabaseException(11, "Not a directory : " + dbDir);
        }
        this._dbDir = dbDir;
        this._loadElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Boolean> loadAcl(File aclFile) {
        Hashtable<String, Boolean> acl = new Hashtable<String, Boolean>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(aclFile));
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, "=");
                try {
                    String name = st.nextToken();
                    String value = st.nextToken();
                    acl.put(name, value.equals("allowed"));
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return acl;
    }

    public void display() {
        for (String name : this._elements.keySet()) {
            ElementItem item = this._elements.get(name);
            System.out.println(name);
            Enumeration e = item.parents();
            while (e.hasMoreElements()) {
                System.out.println("   p:" + (String)e.nextElement());
            }
            e = item.children();
            while (e.hasMoreElements()) {
                System.out.println("   c:" + (String)e.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadElements() {
        String[] elements = this._dbDir.list((dir, name) -> !name.startsWith("."));
        Hashtable<String, ElementItem> hash = new Hashtable<String, ElementItem>();
        for (String element : elements) {
            File file = new File(this._dbDir, element);
            BufferedReader br = null;
            ElementItem item = (ElementItem)hash.get(element);
            if (item == null) {
                item = new ElementItem();
                hash.put(element, item);
            }
            try {
                String line;
                br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    String name2 = line.trim();
                    if (name2.length() == 0 || name2.charAt(0) == '#') continue;
                    item.addChild(name2);
                    ElementItem x = (ElementItem)hash.get(name2);
                    if (x == null) {
                        x = new ElementItem();
                        hash.put(name2, x);
                    }
                    x.addParent(element);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this._elements = hash;
    }

    public boolean check(String user, Map<String, Boolean> acl) {
        Boolean ok = acl.get(user);
        if (ok != null) {
            return ok;
        }
        Vector<String> v = new Vector<String>();
        v.addElement(user);
        for (int i = 0; i < v.size(); ++i) {
            String p = (String)v.elementAt(i);
            Boolean x = acl.get(p);
            if (x != null) {
                if (!x.booleanValue()) continue;
                return true;
            }
            ElementItem item = this._elements.get(p);
            if (item == null) continue;
            Enumeration e = item.parents();
            while (e.hasMoreElements()) {
                v.addElement((String)e.nextElement());
            }
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage : ... <dbDirectory> [<acl> <user>]");
            System.exit(4);
        }
        File dbDir = new File(args[0]);
        UserRelationDb db = new UserRelationDb(dbDir);
        if (args.length < 3) {
            db.display();
        } else {
            File aclFile = new File(args[1]);
            String user = args[2];
            Map<String, Boolean> acl = UserRelationDb.loadAcl(aclFile);
            boolean rc = db.check(user, acl);
            System.out.println("user=" + user + ";acl=" + aclFile + ";allowed=" + rc);
        }
    }

    private class ElementItem {
        private Hashtable<String, String> _parents;
        private Hashtable<String, String> _childs;

        private ElementItem() {
        }

        private void addParent(String parent) {
            if (this._parents == null) {
                this._parents = new Hashtable();
            }
            this._parents.put(parent, parent);
        }

        private void addChild(String child) {
            if (this._childs == null) {
                this._childs = new Hashtable();
            }
            this._childs.put(child, child);
        }

        private Enumeration<String> parents() {
            return this._parents == null ? new DEnumeration() : this._parents.keys();
        }

        private Enumeration<String> children() {
            return this._childs == null ? new DEnumeration() : this._childs.keys();
        }
    }

    private class DEnumeration<T>
    implements Enumeration<T> {
        private DEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() {
            return null;
        }
    }
}

