/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import javatunnel.TunnelSocket;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyStreamEngine
implements StreamEngine {
    private static final Logger _logger = LoggerFactory.getLogger(DummyStreamEngine.class);
    private final Socket _socket;
    private Subject _subject = new Subject();
    private ByteChannel _channel;
    private OutputStream _outputStream;
    private InputStream _inputStream;
    private Reader _reader;
    private Writer _writer;

    public DummyStreamEngine(Socket socket) throws IOException {
        SocketChannel channel;
        this._socket = socket;
        if (socket instanceof TunnelSocket) {
            if (!((TunnelSocket)socket).verify()) {
                String hostAddress = socket.getInetAddress().getHostAddress();
                socket.close();
                throw new IOException("Host " + hostAddress + ": Tunnel verification failed!");
            }
            this.setSubject(((TunnelSocket)socket).getSubject());
        }
        if ((channel = this._socket.getChannel()) != null) {
            this._channel = DummyStreamEngine.wrapChannel(channel);
        }
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }

    @Override
    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    @Override
    public synchronized InputStream getInputStream() {
        if (this._inputStream == null) {
            if (this._channel == null) {
                try {
                    this._inputStream = this._socket.getInputStream();
                }
                catch (IOException e) {
                    _logger.error("Could not create input stream: " + e.getMessage());
                }
            } else {
                this._inputStream = Channels.newInputStream(this._channel);
            }
        }
        return this._inputStream;
    }

    @Override
    public synchronized OutputStream getOutputStream() {
        if (this._outputStream == null) {
            if (this._channel == null) {
                try {
                    this._outputStream = this._socket.getOutputStream();
                }
                catch (IOException e) {
                    _logger.error("Could not create output stream: " + e.getMessage());
                }
            } else {
                this._outputStream = Channels.newOutputStream(this._channel);
            }
        }
        return this._outputStream;
    }

    @Override
    public synchronized Reader getReader() {
        if (this._reader == null) {
            this._reader = this._channel == null ? new InputStreamReader(this.getInputStream()) : Channels.newReader(this._channel, Charset.defaultCharset().newDecoder(), -1);
        }
        return this._reader;
    }

    @Override
    public synchronized Writer getWriter() {
        if (this._writer == null) {
            this._writer = this._channel == null ? new OutputStreamWriter(this.getOutputStream()) : Channels.newWriter(this._channel, Charset.defaultCharset().newEncoder(), -1);
        }
        return this._writer;
    }

    @Override
    public Socket getSocket() {
        return this._socket;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    @Override
    public String getTerminalType() {
        return "dumb";
    }

    @Override
    public int getTerminalWidth() {
        return 0;
    }

    @Override
    public int getTerminalHeight() {
        return 0;
    }

    private static ByteChannel wrapChannel(final ByteChannel channel) {
        return new ByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                return channel.write(src);
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return channel.read(dst);
            }

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        };
    }
}

