/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exceptions {
    private static final Logger LOG = LoggerFactory.getLogger(Exceptions.class);

    private Exceptions() {
    }

    public static String getMessageWithCauses(Throwable t) {
        StringBuilder msg = new StringBuilder(t.getMessage());
        for (t = t.getCause(); t != null; t = t.getCause()) {
            msg.append("; caused by: ").append(t.getMessage());
        }
        return msg.toString();
    }

    public static <T extends Exception> T wrap(String message, T cause, Class<T> enclosingType) {
        ReflectiveOperationException lastException = null;
        Class<?> type = cause.getClass();
        while (enclosingType.isAssignableFrom(type)) {
            try {
                Constructor<?> c = type.getConstructor(String.class, Throwable.class);
                return (T)((Exception)c.newInstance(message, cause));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                lastException = e;
                try {
                    Constructor<?> c = type.getConstructor(String.class);
                    return (T)((Exception)c.newInstance(message));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                    lastException = e2;
                    type = type.getSuperclass();
                }
            }
        }
        if (lastException == null) {
            LOG.error("Failed to wrap exception with message {}: exception {} not subclass of {}", new Object[]{message, cause.getClass().getCanonicalName(), enclosingType.getCanonicalName()});
        } else {
            LOG.error("Failed to wrap exception with message {}: {}", (Object)message, (Object)lastException.getMessage());
        }
        return cause;
    }
}

