/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import com.google.common.collect.EvictingQueue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Queue;

public class Pinboard {
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withZone(ZoneId.systemDefault());
    private final Queue<PinEntry> _entries;

    public Pinboard(int size) {
        this._entries = EvictingQueue.create((int)size);
    }

    public synchronized void pin(String note) {
        this._entries.add(new PinEntry(note));
    }

    public synchronized void dump(StringBuilder sb) {
        this._entries.stream().forEach(e -> sb.append(e).append('\n'));
    }

    public synchronized void dump(StringBuilder sb, int last) {
        this._entries.stream().skip(Math.max(0, this._entries.size() - last)).forEach(e -> sb.append(e).append('\n'));
    }

    public synchronized void dump(File file) throws IOException {
        try (PrintWriter pw = new PrintWriter(new FileWriter(file));){
            this._entries.stream().forEach(pw::println);
        }
    }

    public synchronized void dump(File file, int last) throws IOException {
        try (PrintWriter pw = new PrintWriter(new FileWriter(file));){
            this._entries.stream().skip(Math.max(0, this._entries.size() - last)).forEach(pw::println);
        }
    }

    private static class PinEntry {
        final String message;
        final long timestamp;

        public PinEntry(String message) {
            this.message = message;
            this.timestamp = System.currentTimeMillis();
        }

        public String toString() {
            return TIMESTAMP_FORMAT.format(Instant.ofEpochMilli(this.timestamp)) + ' ' + this.message;
        }
    }
}

