/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.command;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import dmg.util.CommandException;
import dmg.util.CommandPanicException;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.command.HelpFormat;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dcache.util.Args;
import org.dcache.util.cli.CommandExecutor;

class AcCommandExecutor
implements CommandExecutor {
    private final Object _listener;
    private Method _method;
    private int _minArgs;
    private int _maxArgs;
    private Field _fullHelp;
    private Field _helpHint;
    private Field _acls;
    private boolean _isDeprecated;

    public AcCommandExecutor(Object listener) {
        this._listener = listener;
    }

    public boolean isDeprecated() {
        return this._isDeprecated;
    }

    public void setMethod(Method m, int mn, int mx) {
        this._method = m;
        this._minArgs = mn;
        this._maxArgs = mx;
        this._isDeprecated = m.getDeclaredAnnotation(Deprecated.class) != null;
    }

    public void setFullHelpField(Field f) {
        this._fullHelp = f;
    }

    public void setHelpHintField(Field f) {
        this._helpHint = f;
    }

    public void setAclField(Field f) {
        this._acls = f;
    }

    public boolean hasACLs() {
        return this._acls != null;
    }

    public String[] getACLs() {
        try {
            if (this._acls != null) {
                Object value = this._acls.get(this._listener);
                if (value instanceof String[]) {
                    return (String[])value;
                }
                if (value instanceof String) {
                    return new String[]{value.toString()};
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new String[0];
    }

    public String getFullHelp(HelpFormat format) {
        try {
            Object help;
            if (this._fullHelp != null && (help = this._fullHelp.get(this._listener)) != null) {
                return help.toString();
            }
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return null;
    }

    public String getHelpHint(HelpFormat format) {
        block7: {
            try {
                int i;
                if (this._helpHint != null) {
                    Object hint = this._helpHint.get(this._listener);
                    if (hint != null) {
                        return hint.toString();
                    }
                    break block7;
                }
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < this._minArgs; ++i) {
                    sb.append(" <arg-").append(i).append(">");
                }
                if (this._maxArgs != this._minArgs) {
                    sb.append(" [ ");
                    for (i = this._minArgs; i < this._maxArgs; ++i) {
                        sb.append(" <arg-").append(i).append(">");
                    }
                    sb.append(" ] ");
                }
                return sb.toString();
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    public Serializable execute(Args arguments) throws CommandException {
        int params = arguments.argc();
        if (params < this._minArgs || params > this._maxArgs) {
            throw new CommandSyntaxException("Invalid number of arguments");
        }
        try {
            return (Serializable)this._method.invoke(this._listener, arguments);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            Throwables.propagateIfInstanceOf((Throwable)te, CommandException.class);
            Throwables.propagateIfInstanceOf((Throwable)te, Error.class);
            if (te instanceof RuntimeException && !(te instanceof IllegalArgumentException) && !(te instanceof IllegalStateException)) {
                boolean declared = false;
                for (Class<?> clazz : this._method.getExceptionTypes()) {
                    if (!clazz.isAssignableFrom(te.getClass())) continue;
                    declared = true;
                }
                if (!declared) {
                    throw new CommandPanicException("Command failed: " + te.toString(), te);
                }
            }
            throw new CommandThrowableException(te.toString() + " from " + this._method.getName(), te);
        }
        catch (IllegalAccessException e) {
            throw new CommandPanicException("Exception while invoking " + this._method.getName() + ": " + e.toString(), (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this._method).addValue((Object)this._fullHelp).addValue((Object)this._helpHint).addValue((Object)this._acls).omitNullValues().toString();
    }
}

