/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.UidPrincipal;
import org.slf4j.Logger;

public class NetLoggerBuilder {
    private static final DateTimeFormatter TS_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final StringBuilder s = new StringBuilder(256);
    private boolean omitNullValues;
    private Level level;
    private Logger logger;
    private static final Escaper AS_QUOTED_VALUE = new CharEscaperBuilder().addEscape('\\', "\\\\").addEscape('\"', "\\\"").addEscape('\n', "\\n").addEscape('\r', "\\r").toEscaper();
    private static final CharMatcher NEEDS_QUOTING = CharMatcher.anyOf((CharSequence)" \"\n\r");

    private static StringBuilder appendSubject(StringBuilder sb, Subject subject) {
        if (subject == null) {
            return sb.append("unknown");
        }
        Long uid = null;
        Long gid = null;
        for (Principal principal : subject.getPrincipals()) {
            if (principal instanceof UidPrincipal) {
                if (((UidPrincipal)principal).getUid() == 0L) {
                    return sb.append("root");
                }
                uid = ((UidPrincipal)principal).getUid();
                continue;
            }
            if (!(principal instanceof GidPrincipal) || !((GidPrincipal)principal).isPrimaryGroup()) continue;
            gid = ((GidPrincipal)principal).getGid();
        }
        if (uid == null) {
            return sb.append("nobody");
        }
        sb.append(uid).append(':');
        if (gid != null) {
            sb.append(gid);
        }
        for (Principal principal : subject.getPrincipals()) {
            if (!(principal instanceof GidPrincipal) || ((GidPrincipal)principal).isPrimaryGroup()) continue;
            sb.append(',').append(((GidPrincipal)principal).getGid());
        }
        return sb;
    }

    public static CharSequence describeSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        return NetLoggerBuilder.appendSubject(new StringBuilder(), subject);
    }

    private String getTimestamp() {
        return ZonedDateTime.now().format(TS_FORMAT);
    }

    public NetLoggerBuilder(String event) {
        this.s.append("ts=").append(this.getTimestamp()).append(' ');
        this.s.append("event=").append(event);
    }

    public NetLoggerBuilder(Level level, String event) {
        this.level = level;
        this.s.append("level=").append((Object)level).append(' ');
        this.s.append("ts=").append(this.getTimestamp()).append(' ');
        this.s.append("event=").append(event);
    }

    public NetLoggerBuilder omitNullValues() {
        this.omitNullValues = true;
        return this;
    }

    public NetLoggerBuilder onLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public NetLoggerBuilder add(String name, Object value) {
        if (!this.omitNullValues || value != null) {
            this.s.append(' ').append(name).append('=');
            if (value != null) {
                String stringValue = value.toString();
                if (NEEDS_QUOTING.matchesAnyOf((CharSequence)stringValue)) {
                    this.s.append('\"').append(AS_QUOTED_VALUE.escape(stringValue)).append('\"');
                } else {
                    this.s.append(stringValue);
                }
            }
        }
        return this;
    }

    public NetLoggerBuilder add(String name, Subject subject) {
        if (!this.omitNullValues || subject != null) {
            this.s.append(' ').append(name).append('=');
            NetLoggerBuilder.appendSubject(this.s, subject);
        }
        return this;
    }

    public NetLoggerBuilder add(String name, InetSocketAddress sock) {
        if (!this.omitNullValues || sock != null) {
            this.s.append(' ').append(name).append('=');
            if (sock != null) {
                this.s.append(InetAddresses.toUriString((InetAddress)sock.getAddress())).append(':').append(sock.getPort());
            }
        }
        return this;
    }

    public NetLoggerBuilder addInQuotes(String name, Object value) {
        if (!this.omitNullValues || value != null) {
            this.s.append(' ').append(name).append('=');
            if (value != null) {
                this.s.append('\"').append(AS_QUOTED_VALUE.escape(value.toString())).append('\"');
            }
        }
        return this;
    }

    public NetLoggerBuilder add(String name, boolean value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, char value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, double value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, float value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, int value) {
        return this.add(name, String.valueOf(value));
    }

    public NetLoggerBuilder add(String name, long value) {
        return this.add(name, String.valueOf(value));
    }

    public String toString() {
        return this.s.toString();
    }

    public void toLogger(Logger logger) {
        Preconditions.checkState((this.level != null ? 1 : 0) != 0, (Object)"Cannot log to logger without a level.");
        String line = this.toString();
        switch (this.level) {
            case ERROR: {
                logger.error(line);
                break;
            }
            case WARN: {
                logger.warn(line);
                break;
            }
            case INFO: {
                logger.info(line);
                break;
            }
            case DEBUG: {
                logger.debug(line);
                break;
            }
            case TRACE: {
                logger.trace(line);
            }
        }
    }

    public void log() {
        Preconditions.checkState((this.logger != null ? 1 : 0) != 0, (Object)"can't log without logger");
        this.toLogger(this.logger);
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

