/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Uninterruptibles;
import dmg.cells.network.LocationMgrTunnel;
import dmg.cells.nucleus.CellAdapter;
import dmg.util.DummyStreamEngine;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import javax.net.SocketFactory;
import org.dcache.alarms.AlarmMarkerFactory;
import org.dcache.alarms.PredefinedAlarm;
import org.dcache.util.Args;
import org.dcache.util.NDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationManagerConnector
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger((String)"org.dcache.cells.network");
    private final String _domain;
    private final SocketFactory _ssf;
    private final InetSocketAddress _address;
    private Thread _thread;
    private volatile String _status = "disconnected";
    private volatile int _retries;
    private volatile boolean _isRunning;

    public LocationManagerConnector(String cellName, String args, SocketFactory socketFactory) {
        super(cellName, "System", args);
        Args a = this.getArgs();
        this._domain = a.getOpt("domain");
        this._ssf = Objects.requireNonNull(socketFactory);
        HostAndPort where = HostAndPort.fromString((String)a.getOpt("where"));
        this._address = new InetSocketAddress(where.getHost(), where.getPort());
    }

    @Override
    protected void started() {
        this._thread = this.getNucleus().newThread(this, "TunnelConnector-" + this._domain);
        this._thread.start();
        this._isRunning = true;
    }

    private StreamEngine connect() throws IOException, InterruptedException {
        Socket socket;
        this._status = "Connecting to " + this._address;
        try {
            socket = this._ssf.createSocket(this._address.getAddress(), this._address.getPort());
        }
        catch (UnsupportedAddressTypeException e) {
            throw new IOException("Unsupported address type: " + this._address, e);
        }
        catch (UnresolvedAddressException e) {
            throw new IOException("Unable to resolve " + this._address, e);
        }
        catch (InterruptedIOException | ClosedByInterruptException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Failed to connect to " + this._address + ": " + e, e);
        }
        socket.setKeepAlive(true);
        _log.info("Connecting using {}", (Object)socket.getClass().getSimpleName());
        return new DummyStreamEngine(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Args args = this.getArgs();
        String name = this.getCellName() + "*";
        Random random = new Random();
        NDC.push((String)this._address.toString());
        try {
            while (this._isRunning) {
                try {
                    ++this._retries;
                    LocationMgrTunnel tunnel = new LocationMgrTunnel(name, this.connect(), args);
                    try {
                        tunnel.start().get();
                        this._retries = 0;
                        this._status = "Connected";
                        this.getNucleus().join(tunnel.getCellName());
                    }
                    finally {
                        this.getNucleus().kill(tunnel.getCellName());
                    }
                }
                catch (InterruptedIOException | ClosedByInterruptException e) {
                    throw e;
                }
                catch (IOException | ExecutionException e) {
                    _log.warn(AlarmMarkerFactory.getMarker((PredefinedAlarm)PredefinedAlarm.LOCATION_MANAGER_FAILURE, (String[])new String[]{name, this._domain, e.getMessage()}), "Failed to connect to " + this._domain + ": " + e.getMessage());
                }
                this._status = "Sleeping";
                long sleep = random.nextInt(16000) + 4000;
                _log.warn("Sleeping {} seconds", (Object)(sleep / 1000L));
                Thread.sleep(sleep);
            }
        }
        catch (InterruptedIOException | InterruptedException | ClosedByInterruptException exception) {
        }
        finally {
            NDC.pop();
            this._status = "Terminated";
        }
    }

    @Override
    public String toString() {
        return this._status;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("Location manager connector : " + this.getCellName());
        pw.println("Status   : " + this._status);
        pw.println("Retries  : " + this._retries);
    }

    @Override
    public void stopped() {
        this._isRunning = false;
        Thread thread = this._thread;
        if (thread != null) {
            thread.interrupt();
            Uninterruptibles.joinUninterruptibly((Thread)thread);
        }
    }
}

