/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.HasDiagnosticContext;
import java.io.Serializable;
import org.dcache.util.NDC;
import org.slf4j.MDC;

public class CDC
implements AutoCloseable {
    public static final String MDC_DOMAIN = "cells.domain";
    public static final String MDC_CELL = "cells.cell";
    public static final String MDC_SESSION = "cells.session";
    private final NDC _ndc;
    private final String _session = MDC.get((String)"cells.session");
    private final String _cell = MDC.get((String)"cells.cell");
    private final String _domain = MDC.get((String)"cells.domain");

    public CDC() {
        this._ndc = NDC.cloneNdc();
    }

    private static void setMdc(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    private void apply() {
        CDC.setMdc(MDC_DOMAIN, this._domain);
        CDC.setMdc(MDC_CELL, this._cell);
        CDC.setMdc(MDC_SESSION, this._session);
        if (this._ndc == null) {
            NDC.clear();
        } else {
            NDC.set((NDC)this._ndc);
        }
    }

    @Override
    public void close() {
        this.apply();
    }

    public CDC restore() {
        CDC cdc = new CDC();
        this.apply();
        return cdc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable r) {
        String session = MDC.get((String)MDC_SESSION);
        String cell = MDC.get((String)MDC_CELL);
        String domain = MDC.get((String)MDC_DOMAIN);
        NDC ndc = NDC.cloneNdc();
        try {
            this.apply();
            r.run();
        }
        finally {
            CDC.setMdc(MDC_DOMAIN, domain);
            CDC.setMdc(MDC_CELL, cell);
            CDC.setMdc(MDC_SESSION, session);
            NDC.set((NDC)ndc);
        }
    }

    public static String getCellName() {
        return MDC.get((String)MDC_CELL);
    }

    public static String getDomainName() {
        return MDC.get((String)MDC_DOMAIN);
    }

    public static String getSession() {
        return MDC.get((String)MDC_SESSION);
    }

    public static void setSession(String session) {
        CDC.setMdc(MDC_SESSION, session);
    }

    public static CDC reset(CellNucleus cell) {
        return CDC.reset(cell.getCellName(), cell.getCellDomainName());
    }

    public static CDC reset(CellAddressCore address) {
        return CDC.reset(address.getCellName(), address.getCellDomainName());
    }

    public static void discoverAndReset() {
        CellNucleus nucleus = CellNucleus.findForThread(Thread.currentThread()).orElseGet(() -> CellNucleus.getLogTargetForCell(null));
        CDC.reset(nucleus);
    }

    public static CDC reset(String cellName, String domainName) {
        CDC cdc = new CDC();
        CDC.setMdc(MDC_CELL, cellName);
        CDC.setMdc(MDC_DOMAIN, domainName);
        MDC.remove((String)MDC_SESSION);
        NDC.clear();
        return cdc;
    }

    protected static String getMessageContext(CellMessage envelope) {
        Serializable sessionObject = envelope.getSession();
        String session = sessionObject == null ? null : sessionObject.toString();
        String cellName = envelope.getSourcePath().getCellName();
        Serializable msg = envelope.getMessageObject();
        String context = msg instanceof HasDiagnosticContext ? ((HasDiagnosticContext)((Object)msg)).getDiagnosticContext() : null;
        StringBuilder s = new StringBuilder((session == null ? 0 : session.length() + 1) + cellName.length() + (context == null ? 0 : 1 + context.length()));
        if (session != null) {
            s.append(session).append(' ');
        }
        s.append(cellName);
        if (context != null) {
            s.append(' ').append(context);
        }
        return s.toString();
    }

    public static void setMessageContext(CellMessage envelope) {
        Serializable session = envelope.getSession();
        NDC.push((String)CDC.getMessageContext(envelope));
        CDC.setMdc(MDC_SESSION, session == null ? null : session.toString());
    }

    public static void clearMessageContext() {
        MDC.remove((String)MDC_SESSION);
        NDC.pop();
    }

    public static void clear() {
        MDC.remove((String)MDC_DOMAIN);
        MDC.remove((String)MDC_CELL);
        MDC.remove((String)MDC_SESSION);
        NDC.clear();
    }
}

