/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellDomainRole;
import dmg.util.Releases;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public class CellDomainInfo
implements Serializable {
    private static final long serialVersionUID = 486982068268709272L;
    private final String _domainName;
    private final String _version;
    private final String _zone;
    private CellDomainRole _role;

    public CellDomainInfo(String name, String version, CellDomainRole role, Optional<String> zone) {
        this._domainName = Objects.requireNonNull(name);
        this._version = Objects.requireNonNull(version);
        this._role = Objects.requireNonNull(role);
        this._zone = zone.orElse(null);
    }

    public String getVersion() {
        return this._version;
    }

    public short getRelease() throws Releases.BadVersionException {
        return this._version == null ? (short)517 : Releases.getRelease(this._version);
    }

    public String getCellDomainName() {
        return this._domainName;
    }

    public CellDomainRole getRole() {
        return this._role;
    }

    public Optional<String> getZone() {
        return Optional.ofNullable(this._zone);
    }

    public String toString() {
        return this._domainName + "," + this._version + "," + this._role;
    }
}

