/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.SerializationHandler;
import dmg.cells.nucleus.UOID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;

public final class CellMessage
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5559658187264201731L;
    private static final int TTL_BUFFER_MAXIMUM = 10000;
    private static final float TTL_BUFFER_FRACTION = 0.1f;
    private CellPath _source;
    private CellPath _destination;
    private Object _message;
    private long _creationTime;
    private long _ttl = Long.MAX_VALUE;
    private int _mode;
    private UOID _umid;
    private UOID _lastUmid;
    private byte[] _messageStream;
    private boolean _isPersistent;
    private Object _session;
    private static final int ORIGINAL_MODE = 0;
    private static final int STREAM_MODE = 1;
    private transient long _receivedAt;

    public CellMessage(CellAddressCore address, Serializable msg) {
        this(new CellPath(address));
        this._message = msg;
    }

    public CellMessage(CellAddressCore address) {
        this(new CellPath(address));
    }

    public CellMessage(CellPath path, Serializable msg) {
        this(path.clone());
        this._message = msg;
    }

    public CellMessage(CellPath path) {
        this._source = new CellPath();
        this._destination = path;
        this._receivedAt = this._creationTime = System.currentTimeMillis();
        this._mode = 0;
        this._lastUmid = this._umid = new UOID();
        this._session = CDC.getSession();
    }

    public CellMessage() {
        this(new CellPath());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<CM: S=").append(this._source).append(";D=").append(this._destination);
        if (this._mode == 0) {
            sb.append(";C=").append(this._message.getClass().getName());
            sb.append(";M=").append(this._message.toString());
        } else {
            sb.append(";C=Stream");
        }
        sb.append(";O=").append(this._umid).append(";LO=").append(this._lastUmid);
        if (this._session != null) {
            sb.append(";SID=").append(this._session);
        }
        if (this._ttl < Long.MAX_VALUE) {
            sb.append(";TTL=").append(this._ttl);
        }
        sb.append('>');
        return sb.toString();
    }

    public int hashCode() {
        return this._umid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return ((CellMessage)obj)._umid.equals(this._umid);
    }

    public boolean isReply() {
        return this._isPersistent;
    }

    public UOID getUOID() {
        return this._umid;
    }

    public UOID getLastUOID() {
        return this._lastUmid;
    }

    public void setUOID(UOID umid) {
        this._umid = umid;
    }

    public void setLastUOID(UOID lastUOID) {
        this._lastUmid = lastUOID;
    }

    public Serializable getSession() {
        return (Serializable)this._session;
    }

    public void setSession(Serializable session) {
        this._session = session;
    }

    public void setTtl(long ttl) {
        this._ttl = ttl;
        this._receivedAt = System.currentTimeMillis();
    }

    public long getTtl() {
        return this._ttl;
    }

    public CellAddressCore getSourceAddress() {
        return this._source.getSourceAddress();
    }

    public CellPath getDestinationPath() {
        return this._destination;
    }

    public CellPath getSourcePath() {
        return this._source;
    }

    public Serializable getMessageObject() {
        return (Serializable)this._message;
    }

    public void setMessageObject(Serializable obj) {
        Preconditions.checkState((this._mode == 0 ? 1 : 0) != 0);
        this._message = obj;
    }

    public void revertDirection() {
        Preconditions.checkState((!this._source.getSourceAddress().isDomainAddress() ? 1 : 0) != 0, (Object)"Cannot return envelope to a domain address.");
        this._destination = this._source.revert();
        this._source = new CellPath();
        this._lastUmid = this._umid;
        this._umid = new UOID();
        this._isPersistent = true;
    }

    public boolean isFinalDestination() {
        return this._destination.isFinalDestination();
    }

    public boolean isFirstDestination() {
        return this._destination.isFirstDestination();
    }

    public boolean nextDestination() {
        return this._destination.next();
    }

    boolean isStreamMode() {
        return this._mode == 1;
    }

    public CellMessage clone() {
        try {
            CellMessage copy = (CellMessage)super.clone();
            copy._destination = this._destination.clone();
            if (this._source != null) {
                copy._source = this._source.clone();
            }
            copy._messageStream = this._messageStream;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public CellMessage encodeWith(SerializationHandler.Serializer serializer) {
        Preconditions.checkState((this._mode == 0 ? 1 : 0) != 0);
        CellMessage encoded = this.clone();
        encoded._mode = 1;
        encoded._messageStream = SerializationHandler.encode(this._message, serializer);
        return encoded;
    }

    public CellMessage ensureEncodedWith(SerializationHandler.Serializer handler) {
        Preconditions.checkState((this._mode == 1 ? 1 : 0) != 0, (Object)"not encoded");
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"Cannot ensure CellMessage is encoded. The given msg payload serializer is null.");
        if (!SerializationHandler.isEncodedWith(this._messageStream, handler)) {
            Object payload = SerializationHandler.decode(this._messageStream);
            this._messageStream = SerializationHandler.encode(payload, handler);
        }
        return this;
    }

    public CellMessage decode() throws SerializationException {
        Preconditions.checkState((this._mode == 1 ? 1 : 0) != 0);
        CellMessage decoded = this.clone();
        decoded._mode = 0;
        decoded._messageStream = null;
        decoded._message = SerializationHandler.decode(this._messageStream);
        return decoded;
    }

    public void addSourceAddress(CellAddressCore source) {
        this._source.add(source);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this._receivedAt = System.currentTimeMillis();
    }

    public long getLocalAge() {
        return System.currentTimeMillis() - this._receivedAt;
    }

    public long getAdjustedTtl() {
        return this._ttl == Long.MAX_VALUE ? Long.MAX_VALUE : this._ttl - Math.min(10000L, (long)((float)this._ttl * 0.1f));
    }

    public void writeTo(DataOutput out) throws IOException {
        Preconditions.checkState((this._mode == 1 ? 1 : 0) != 0);
        out.writeByte(this._mode);
        out.writeBoolean(this._isPersistent);
        out.writeLong(this._creationTime);
        out.writeLong(this._ttl);
        this._umid.writeTo(out);
        this._lastUmid.writeTo(out);
        this._source.writeTo(out);
        this._destination.writeTo(out);
        out.writeUTF(Objects.toString(this._session, ""));
        out.writeInt(this._messageStream.length);
        out.write(this._messageStream);
    }

    public static CellMessage createFrom(DataInput in) throws IOException {
        CellMessage message = new CellMessage();
        message._mode = in.readByte();
        if (message._mode != 1) {
            throw new IOException("Invalid message tunnel wire format.");
        }
        message._receivedAt = System.currentTimeMillis();
        message._isPersistent = in.readBoolean();
        message._creationTime = in.readLong();
        message._ttl = in.readLong();
        message._umid = UOID.createFrom(in);
        message._lastUmid = UOID.createFrom(in);
        message._source = CellPath.createFrom(in);
        message._destination = CellPath.createFrom(in);
        message._session = Strings.emptyToNull((String)in.readUTF());
        int len = in.readInt();
        message._messageStream = new byte[len];
        in.readFully(message._messageStream);
        return message;
    }
}

