/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Monitor;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellGlue;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellLock;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellRoutingTable;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.EventLogger;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.SerializationHandler;
import dmg.cells.nucleus.StartEvent;
import dmg.cells.nucleus.UOID;
import dmg.cells.zookeeper.CellCuratorFramework;
import dmg.util.Pinboard;
import dmg.util.logback.FilterThresholdSet;
import dmg.util.logback.RootFilterThresholds;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.apache.curator.framework.CuratorFramework;
import org.dcache.util.BoundedCachedExecutor;
import org.dcache.util.BoundedExecutor;
import org.dcache.util.CompletableFutures;
import org.dcache.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CellNucleus
implements ThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellNucleus.class);
    private static final int PINBOARD_DEFAULT_SIZE = 200;
    private static CellGlue __cellGlue;
    private final String _cellName;
    private final String _cellType;
    private final ThreadGroup _threads;
    private final AtomicInteger _threadCounter = new AtomicInteger();
    private final Cell _cell;
    private final Date _creationTime = new Date();
    private volatile State _state = State.NEW;
    private final ConcurrentMap<UOID, CellLock> _waitHash = new ConcurrentHashMap<UOID, CellLock>();
    private String _cellClass;
    private String _cellSimpleClass;
    private final BoundedExecutor _messageExecutor;
    private final AtomicInteger _eventQueueSize = new AtomicInteger();
    private static final ScheduledExecutorService _timer;
    private Future<?> _timeoutTask;
    private ListenableFuture<Void> _startup;
    private Pinboard _pinboard;
    private FilterThresholdSet _loggingThresholds;
    private final BlockingQueue<Runnable> _deferredTasks = new LinkedBlockingQueue<Runnable>();
    private volatile long _lastQueueTime;
    private final CellCuratorFramework _curatorFramework;
    private final Monitor _lifeCycleMonitor = new Monitor();
    private final List<CellEventListener> _cellEventListeners = new CopyOnWriteArrayList<CellEventListener>();
    private final Monitor.Guard isNotStarting = new Monitor.Guard(this._lifeCycleMonitor){

        public boolean isSatisfied() {
            return !CellNucleus.this._state.isStarting;
        }
    };

    public CellNucleus(Cell cell, String name, String type, Executor executor) {
        int dot;
        Object cellName = name.replace('@', '+');
        if (((String)cellName).isEmpty()) {
            cellName = "*";
        }
        if (((String)cellName).charAt(((String)cellName).length() - 1) == '*') {
            cellName = ((String)cellName).length() == 1 ? "$-" + this.getUnique() : ((String)cellName).substring(0, ((String)cellName).length() - 1) + "-" + this.getUnique();
        }
        this._cellName = cellName;
        this._cellType = type;
        this._cell = cell;
        Class<?> clazz = this._cell.getClass();
        this._cellClass = clazz.getName();
        this._cellSimpleClass = clazz.isAnonymousClass() ? ((dot = this._cellClass.lastIndexOf(46)) == -1 ? this._cellClass : this._cellClass.substring(dot + 1)) : clazz.getSimpleName();
        this.setPinboard(new Pinboard(200));
        this._threads = new ThreadGroup(__cellGlue.getMasterThreadGroup(), this._cellName + "-threads");
        __cellGlue.registerCell(this);
        CellNucleus parentNucleus = CellNucleus.getLogTargetForCell(MDC.get((String)"cells.cell"));
        FilterThresholdSet parentThresholds = parentNucleus.isSystemNucleus() || parentNucleus == this ? RootFilterThresholds.getInstance() : parentNucleus.getLoggingThresholds();
        this.setLoggingThresholds(new FilterThresholdSet(parentThresholds));
        this._messageExecutor = executor == null ? new BoundedCachedExecutor((ThreadFactory)this, 1) : new BoundedExecutor(executor, 1);
        CuratorFramework curatorFramework = __cellGlue.getCuratorFramework();
        this._curatorFramework = new CellCuratorFramework(curatorFramework, (Executor)this._messageExecutor);
        LOGGER.info("Created {}", cellName);
    }

    public static CellNucleus getLogTargetForCell(String cell) {
        CellNucleus nucleus = null;
        if (__cellGlue != null) {
            if (cell != null) {
                nucleus = __cellGlue.getCell(cell);
            }
            if (nucleus == null) {
                nucleus = __cellGlue.getSystemNucleus();
            }
        }
        return nucleus;
    }

    public static Optional<CellNucleus> findForThread(Thread thread) {
        return __cellGlue.findCellNucleus(thread);
    }

    public static void initCellGlue(String cellDomainName, CuratorFramework curatorFramework, Optional<String> zone, SerializationHandler.Serializer serializer) {
        Preconditions.checkState((__cellGlue == null ? 1 : 0) != 0);
        __cellGlue = new CellGlue(cellDomainName, curatorFramework, zone, serializer);
    }

    public static void startCurator() {
        __cellGlue.getCuratorFramework().start();
    }

    public static void shutdownCellGlue() {
        if (__cellGlue != null) {
            __cellGlue.shutdown();
        }
    }

    boolean isSystemNucleus() {
        return this == __cellGlue.getSystemNucleus();
    }

    public String getCellName() {
        return this._cellName;
    }

    public String getCellType() {
        return this._cellType;
    }

    public String getCellClass() {
        return this._cellClass;
    }

    public void setCellClass(String cellClass) {
        this._cellClass = cellClass;
    }

    public CellAddressCore getThisAddress() {
        return new CellAddressCore(this._cellName, __cellGlue.getCellDomainName());
    }

    public String getCellDomainName() {
        return __cellGlue.getCellDomainName();
    }

    public List<String> getCellNames() {
        return __cellGlue.getCellNames();
    }

    public CellInfo getCellInfo(String name) {
        return __cellGlue.getCellInfo(name);
    }

    public CellInfo getCellInfo() {
        return this._getCellInfo();
    }

    public Map<String, Object> getDomainContext() {
        return __cellGlue.getCellContext();
    }

    public Reader getDomainContextReader(String contextName) throws FileNotFoundException {
        Object o = __cellGlue.getCellContext(contextName);
        if (o == null) {
            throw new FileNotFoundException("Context not found : " + contextName);
        }
        return new StringReader(o.toString());
    }

    public void setDomainContext(String contextName, Object context) {
        __cellGlue.getCellContext().put(contextName, context);
    }

    public Object getDomainContext(String str) {
        return __cellGlue.getCellContext(str);
    }

    Cell getThisCell() {
        return this._cell;
    }

    CellInfo _getCellInfo() {
        CellInfo info = new CellInfo();
        info.setCellName(this.getCellName());
        info.setDomainName(this.getCellDomainName());
        info.setCellType(this.getCellType());
        info.setCreationTime(this._creationTime);
        try {
            info.setCellVersion(this._cell.getCellVersion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setPrivateInfo(this._cell.getInfo());
        }
        catch (Exception e) {
            info.setPrivateInfo("Not yet/No more available\n");
        }
        try {
            info.setShortInfo(this._cell.toString());
        }
        catch (Exception e) {
            info.setShortInfo("Not yet/No more available");
        }
        info.setCellClass(this._cellClass);
        info.setCellSimpleClass(this._cellSimpleClass);
        try {
            int eventQueueSize = this.getEventQueueSize();
            info.setEventQueueSize(eventQueueSize);
            info.setExpectedQueueTime(eventQueueSize == 0 ? 0L : this._lastQueueTime);
            info.setState(this._state.externalState);
            info.setThreadCount(this._threads.activeCount());
        }
        catch (Exception e) {
            info.setEventQueueSize(0);
            info.setState(0);
            info.setThreadCount(0);
        }
        return info;
    }

    public void setLoggingThresholds(FilterThresholdSet thresholds) {
        this._loggingThresholds = thresholds;
    }

    public FilterThresholdSet getLoggingThresholds() {
        return this._loggingThresholds;
    }

    public synchronized void setPinboard(Pinboard pinboard) {
        this._pinboard = pinboard;
    }

    public synchronized Pinboard getPinboard() {
        return this._pinboard;
    }

    public void setMaximumPoolSize(int size) {
        this._messageExecutor.setMaximumPoolSize(size);
    }

    public int getMaximumPoolSize() {
        return this._messageExecutor.getMaximumPoolSize();
    }

    public void setMaximumQueueSize(int size) {
        this._messageExecutor.setMaximumQueueSize(size);
    }

    public int getMaximumQueueSize() {
        return this._messageExecutor.getMaximumQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(CellMessage msg, boolean locally, boolean remotely, boolean shouldAddSource) throws SerializationException {
        Preconditions.checkArgument((!msg.isFinalDestination() ? 1 : 0) != 0, (String)"Message has no next destination: %s", (Object)msg.getDestinationPath());
        if (shouldAddSource) {
            msg.addSourceAddress(this.getThisAddress());
        }
        EventLogger.sendBegin(msg, "async");
        try {
            __cellGlue.sendMessage(msg, locally, remotely);
        }
        finally {
            EventLogger.sendEnd(msg);
        }
    }

    public CellMessage sendAndWait(CellMessage envelope, long timeout) throws SerializationException, NoRouteToCellException, InterruptedException, ExecutionException {
        final SettableFuture future = SettableFuture.create();
        this.sendMessage(envelope, true, true, true, new CellMessageAnswerable(){

            @Override
            public void answerArrived(CellMessage request, CellMessage answer) {
                future.set((Object)answer);
            }

            @Override
            public void exceptionArrived(CellMessage request, Exception exception) {
                future.setException((Throwable)exception);
            }

            @Override
            public void answerTimedOut(CellMessage request) {
                future.set(null);
            }
        }, MoreExecutors.directExecutor(), timeout);
        try {
            return (CellMessage)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), NoRouteToCellException.class);
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), SerializationException.class);
            throw e;
        }
    }

    public Map<UOID, CellLock> getWaitQueue() {
        return Collections.unmodifiableMap(this._waitHash);
    }

    private void executeMaintenanceTasks() {
        long now = System.currentTimeMillis();
        this._waitHash.entrySet().stream().filter(e -> ((CellLock)e.getValue()).getTimeout() < now).forEach(e -> this.timeOutMessage((UOID)e.getKey(), (CellLock)e.getValue(), this::reregisterCallback));
        Iterables.limit((Iterable)Iterables.consumingIterable(this._deferredTasks), (int)this._deferredTasks.size()).forEach(Runnable::run);
    }

    public void sendMessage(CellMessage msg, boolean local, boolean remote, boolean shouldAddSource, CellMessageAnswerable callback, Executor executor, long timeout) throws SerializationException {
        Preconditions.checkState((boolean)this._state.isSendWithCallbackAllowed, (String)"Cannot send message with callback in state {}", (Object)((Object)this._state));
        Preconditions.checkArgument((!msg.isFinalDestination() ? 1 : 0) != 0, (String)"Message has no next destination: %s", (Object)msg.getDestinationPath());
        if (shouldAddSource) {
            msg.addSourceAddress(this.getThisAddress());
        } else {
            Preconditions.checkArgument((msg.getSourcePath().hops() > 0 ? 1 : 0) != 0, (Object)"Message has no source address.");
        }
        msg.setTtl(timeout);
        UOID uoid = msg.getUOID();
        CellLock lock = new CellLock(msg, callback, executor, timeout);
        EventLogger.sendBegin(msg, "callback");
        this._waitHash.put(uoid, lock);
        if (!this._state.areCallbacksGuaranteed) {
            this.timeOutMessage(uoid, lock, (u, l) -> {});
            return;
        }
        try {
            __cellGlue.sendMessage(msg, local, remote);
        }
        catch (SerializationException e) {
            if (this._waitHash.remove(uoid, lock)) {
                EventLogger.sendEnd(msg);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this._waitHash.remove(uoid, lock)) {
                try {
                    executor.execute(() -> {
                        try {
                            callback.exceptionArrived(msg, e);
                            EventLogger.sendEnd(msg);
                        }
                        catch (RejectedExecutionException e1) {
                            LOGGER.error("Failed to invoke callback: {}", (Object)e1.toString());
                            this.reregisterCallback(uoid, lock);
                        }
                    });
                }
                catch (RejectedExecutionException e1) {
                    LOGGER.error("Failed to invoke callback: {}", (Object)e1.toString());
                    this.reregisterCallback(uoid, lock);
                }
            }
            LOGGER.error("Failed to send message: {}", (Object)e.toString());
        }
    }

    public void addCellEventListener(CellEventListener listener) {
        this._cellEventListeners.add(listener);
    }

    void addToEventQueue(CellEvent ce) {
        try {
            this._eventQueueSize.incrementAndGet();
            this._messageExecutor.execute((Runnable)new CellEventTask(ce));
        }
        catch (RejectedExecutionException e) {
            this._eventQueueSize.decrementAndGet();
            LOGGER.error("Dropping event: {}", (Object)e.getMessage());
        }
    }

    public void consume(String queue) {
        __cellGlue.consume(this, queue);
    }

    public void subscribe(String topic) {
        __cellGlue.subscribe(this, topic);
    }

    public CompletableFuture<?> kill() {
        return __cellGlue.kill(this);
    }

    public CompletableFuture<?> kill(String cellName) {
        return __cellGlue.kill(this, cellName);
    }

    public static void listThreadGroupOf(String cellName) {
        __cellGlue.listThreadGroupOf(cellName);
    }

    public static void listKillerThreadGroup() {
        __cellGlue.listKillerThreadGroup();
    }

    public void threadGroupList() {
        CellGlue.listThreadGroup(this._threads);
    }

    public boolean join(String cellName) throws InterruptedException {
        return __cellGlue.join(cellName, 0L);
    }

    public boolean join(String cellName, long timeout) throws InterruptedException {
        return __cellGlue.join(cellName, timeout);
    }

    private Collection<Thread> getNonDaemonThreads(ThreadGroup group) {
        Thread[] threads = new Thread[group.activeCount()];
        int count = group.enumerate(threads);
        ArrayList<Thread> nonDaemonThreads = new ArrayList<Thread>(count);
        for (int i = 0; i < count; ++i) {
            Thread thread = threads[i];
            if (thread.isDaemon()) continue;
            nonDaemonThreads.add(thread);
        }
        return nonDaemonThreads;
    }

    private boolean joinThreads(Collection<Thread> threads, long timeout) throws InterruptedException {
        long deadline = MathUtils.addWithInfinity((long)System.currentTimeMillis(), (long)timeout);
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            long wait = MathUtils.subWithInfinity((long)deadline, (long)System.currentTimeMillis());
            if (wait <= 0L) {
                return false;
            }
            thread.join(wait);
            if (!thread.isAlive()) continue;
            return false;
        }
        return true;
    }

    private void killThreads(Collection<Thread> threads) {
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            LOGGER.warn("Forcefully interrupting thread {} during shutdown.", (Object)thread.getName());
            thread.interrupt();
        }
    }

    private Runnable wrapLoggingContext(Runnable runnable) {
        return () -> {
            try (CDC ignored = CDC.reset(this);){
                runnable.run();
            }
        };
    }

    private <T> Callable<T> wrapLoggingContext(Callable<T> callable) {
        return () -> {
            try (CDC ignored = CDC.reset(this);){
                Object v = callable.call();
                return v;
            }
        };
    }

    <T> Future<T> invokeOnMessageThread(Callable<T> task) {
        return this._messageExecutor.submit(this.wrapLoggingContext(task));
    }

    Future<?> invokeOnMessageThread(Runnable task) {
        return this._messageExecutor.submit(this.wrapLoggingContext(task));
    }

    void invokeLater(Runnable runnable) {
        this._deferredTasks.add(this.wrapLoggingContext(runnable));
    }

    void runDeferredTasksNow() {
        _timer.execute(() -> Iterables.consumingIterable(this._deferredTasks).forEach(Runnable::run));
    }

    @Override
    @Nonnull
    public Thread newThread(@Nonnull Runnable target) {
        return this.newThread(target, this.getCellName() + "-" + this._threadCounter.getAndIncrement());
    }

    @Nonnull
    public Thread newThread(@Nonnull Runnable target, @Nonnull String name) {
        return CellGlue.newThread(this._threads, this.wrapLoggingContext(target), name);
    }

    Thread[] getThreads(String cellName) {
        return __cellGlue.getThreads(cellName);
    }

    public ThreadGroup getThreadGroup() {
        return this._threads;
    }

    Thread[] getThreads() {
        if (this._threads == null) {
            return new Thread[0];
        }
        int threadCount = this._threads.activeCount();
        Thread[] list = new Thread[threadCount];
        int rc = this._threads.enumerate(list);
        if (rc == list.length) {
            return list;
        }
        Thread[] ret = new Thread[rc];
        System.arraycopy(list, 0, ret, 0, rc);
        return ret;
    }

    private String getUnique() {
        return __cellGlue.getUnique();
    }

    int getEventQueueSize() {
        return this._eventQueueSize.get();
    }

    void addToEventQueue(MessageEvent ce) {
        CellMessage msg = ce.getMessage();
        LOGGER.trace("addToEventQueue : message arrived : {}", (Object)msg);
        CellLock lock = (CellLock)this._waitHash.remove(msg.getLastUOID());
        if (lock != null) {
            LOGGER.trace("addToEventQueue : lock found for : {}", (Object)msg);
            try {
                this._eventQueueSize.incrementAndGet();
                lock.getExecutor().execute(new CallbackTask(lock, msg));
            }
            catch (RejectedExecutionException e) {
                this._eventQueueSize.decrementAndGet();
                LOGGER.error("Dropping reply: {}", (Object)e.getMessage());
                this.reregisterCallback(msg.getLastUOID(), lock);
            }
        } else {
            if (this._eventQueueSize.get() == 0) {
                this._lastQueueTime = 0L;
            } else if (!msg.isReply()) {
                long queueTime = this._lastQueueTime;
                if (msg.getTtl() < queueTime) {
                    CellMessage envelope = new CellMessage(msg.getSourcePath().revert(), (Serializable)new NoRouteToCellException(msg, this.getCellName() + "@" + this.getCellDomainName() + " is busy (its estimated response time of " + queueTime + " ms is longer than the message TTL of " + msg.getTtl() + " ms)."));
                    envelope.setLastUOID(msg.getUOID());
                    this.sendMessage(envelope, true, true, true);
                }
            }
            try {
                EventLogger.queueBegin(ce);
                this._eventQueueSize.incrementAndGet();
                this._messageExecutor.execute((Runnable)new DeliverMessageTask(ce));
            }
            catch (RejectedExecutionException e) {
                EventLogger.queueEnd(ce);
                this._eventQueueSize.decrementAndGet();
                LOGGER.error("Dropping message: {}", (Object)e.getMessage());
            }
        }
    }

    private void setState(State newState) {
        this._lifeCycleMonitor.enter();
        try {
            this._state = newState;
        }
        finally {
            this._lifeCycleMonitor.leave();
        }
    }

    public CompletableFuture<Void> start() {
        this._lifeCycleMonitor.enter();
        try {
            Preconditions.checkState((this._state == State.NEW ? 1 : 0) != 0);
            this._state = State.PRE_STARTUP;
            this._startup = this._messageExecutor.submit(this.wrapLoggingContext(this::doStart));
        }
        finally {
            this._lifeCycleMonitor.leave();
        }
        return CompletableFutures.fromListenableFuture((ListenableFuture)Futures.nonCancellationPropagating(this._startup));
    }

    private Void doStart() throws Exception {
        try {
            Preconditions.checkState((this._state == State.PRE_STARTUP ? 1 : 0) != 0);
            this._timeoutTask = _timer.scheduleWithFixedDelay(this.wrapLoggingContext(this::executeMaintenanceTasks), 20L, 20L, TimeUnit.SECONDS);
            StartEvent event = new StartEvent(new CellPath(this._cellName), 0L);
            try {
                EventLogger.prepareSetupBegin(this._cell, event);
                this._cell.prepareStartup(event);
            }
            finally {
                EventLogger.prepareSetupEnd(this._cell, event);
            }
            this.setState(State.POST_STARTUP);
            __cellGlue.publishCell(this);
            try {
                EventLogger.postStartupBegin(this._cell, event);
                this._cell.postStartup(event);
            }
            finally {
                EventLogger.postStartupEnd(this._cell, event);
            }
            this.setState(State.RUNNING);
        }
        catch (Throwable e) {
            this.setState(State.FAILED);
            __cellGlue.kill(this);
            throw e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(KillEvent event) {
        try (CDC ignored = CDC.reset(this);){
            Thread t;
            LOGGER.trace("Received {}", (Object)event);
            boolean wasRunning = false;
            this._lifeCycleMonitor.enter();
            try {
                State state;
                if (!this._lifeCycleMonitor.waitForUninterruptibly(this.isNotStarting, 2L, TimeUnit.SECONDS)) {
                    this._startup.cancel(true);
                    this._lifeCycleMonitor.waitForUninterruptibly(this.isNotStarting);
                }
                Preconditions.checkState(((state = this._state) == State.NEW || state == State.RUNNING || state == State.FAILED ? 1 : 0) != 0);
                wasRunning = state == State.RUNNING;
                this._state = State.STOPPING;
            }
            finally {
                this._lifeCycleMonitor.leave();
            }
            if (this._timeoutTask != null) {
                this._timeoutTask.cancel(false);
                try {
                    Uninterruptibles.getUninterruptibly(this._timeoutTask);
                }
                catch (CancellationException | ExecutionException state) {
                    // empty catch block
                }
            }
            if (wasRunning) {
                try {
                    Uninterruptibles.getUninterruptibly((Future)this._messageExecutor.submit(() -> {
                        try {
                            EventLogger.prepareRemovalBegin(this._cell, event);
                            this._cell.prepareRemoval(event);
                        }
                        finally {
                            EventLogger.prepareRemovalEnd(this._cell, event);
                        }
                    }));
                }
                catch (Throwable e) {
                    t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, e);
                }
            }
            this._waitHash.forEach((uoid, lock) -> this.timeOutMessage((UOID)uoid, (CellLock)lock, (u, l) -> {}));
            if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this._messageExecutor, (long)2L, (TimeUnit)TimeUnit.SECONDS)) {
                LOGGER.warn("Failed to flush message queue during shutdown.");
            }
            try {
                EventLogger.postRemovalBegin(this._cell, event);
                this._cell.postRemoval(event);
            }
            catch (Throwable e) {
                t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
            }
            finally {
                EventLogger.postRemovalEnd(this._cell, event);
            }
            LOGGER.debug("Waiting for all threads in {} to finish", (Object)this._threads);
            try {
                Collection<Thread> threads = this.getNonDaemonThreads(this._threads);
                while (!this.joinThreads(threads, 1000L)) {
                    this.threadGroupList();
                    this.killThreads(threads);
                }
                this._threads.destroy();
            }
            catch (IllegalThreadStateException e) {
                this._threads.setDaemon(true);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for threads");
            }
            __cellGlue.destroy(this);
            this.setState(State.TERMINATED);
        }
    }

    private void reregisterCallback(UOID uoid, CellLock lock) {
        this._waitHash.put(uoid, lock);
        if (!this._state.areCallbacksGuaranteed) {
            this.timeOutMessage(uoid, lock, (u, l) -> {});
        }
    }

    private void timeOutMessage(UOID uoid, CellLock lock, BiConsumer<UOID, CellLock> reregister) {
        if (this._waitHash.remove(uoid, lock)) {
            try (CDC ignored = lock.getCdc().restore();){
                try {
                    lock.getExecutor().execute(() -> {
                        try (CDC ignored2 = lock.getCdc().restore();){
                            CellMessage envelope = lock.getMessage();
                            try {
                                lock.getCallback().answerTimedOut(envelope);
                                EventLogger.sendEnd(envelope);
                            }
                            catch (RejectedExecutionException e) {
                                LOGGER.warn("Failed to invoke callback: {}", (Object)e.toString());
                                reregister.accept(uoid, lock);
                            }
                            catch (RuntimeException e) {
                                Thread t = Thread.currentThread();
                                t.getUncaughtExceptionHandler().uncaughtException(t, e);
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    reregister.accept(uoid, lock);
                    LOGGER.warn("Failed to invoke callback: {}", (Object)e.toString());
                }
            }
        }
    }

    public void routeAdd(CellRoute route) throws IllegalArgumentException {
        __cellGlue.routeAdd(route);
    }

    public void routeDelete(CellRoute route) throws IllegalArgumentException {
        __cellGlue.routeDelete(route);
    }

    CellRoute routeFind(CellAddressCore addr) {
        return __cellGlue.getRoutingTable().find(addr, this.getZone(), true);
    }

    public CellRoutingTable getRoutingTable() {
        return __cellGlue.getRoutingTable();
    }

    public CellRoute[] getRoutingList() {
        return __cellGlue.getRoutingList();
    }

    public List<CellTunnelInfo> getCellTunnelInfos() {
        return __cellGlue.getCellTunnelInfos();
    }

    public CuratorFramework getCuratorFramework() {
        return this._curatorFramework;
    }

    @Nonnull
    public Optional<String> getZone() {
        return __cellGlue.getZone();
    }

    public SerializationHandler.Serializer getMsgSerialization() {
        return __cellGlue.getMessageSerializer();
    }

    static {
        _timer = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Cell maintenance task timer").build());
    }

    private class CellEventTask
    implements Runnable {
        private final CellEvent _event;

        public CellEventTask(CellEvent event) {
            this._event = event;
        }

        @Override
        public void run() {
            CellNucleus.this._eventQueueSize.decrementAndGet();
            try (CDC ignored = CDC.reset(CellNucleus.this);){
                for (CellEventListener listener : CellNucleus.this._cellEventListeners) {
                    try {
                        switch (this._event.getEventType()) {
                            case 3: {
                                listener.cellCreated(this._event);
                                break;
                            }
                            case 4: {
                                listener.cellDied(this._event);
                                break;
                            }
                            case 7: {
                                listener.routeAdded(this._event);
                                break;
                            }
                            case 8: {
                                listener.routeDeleted(this._event);
                            }
                        }
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            }
        }
    }

    private class DeliverMessageTask
    implements Runnable {
        private final MessageEvent _event;

        public DeliverMessageTask(MessageEvent event) {
            this._event = event;
        }

        @Override
        public void run() {
            block12: {
                try (CDC ignored = CDC.reset(CellNucleus.this);){
                    try {
                        EventLogger.queueEnd(this._event);
                        CellNucleus.this._lastQueueTime = this._event.getMessage().getLocalAge();
                        CellNucleus.this._eventQueueSize.decrementAndGet();
                        if (this._event instanceof RoutedMessageEvent) {
                            CellNucleus.this._cell.messageArrived(this._event);
                            break block12;
                        }
                        CellMessage msg = this._event.getMessage();
                        CDC.setMessageContext(msg);
                        msg.getDestinationPath().next();
                        try {
                            CellNucleus.this._cell.messageArrived(this._event);
                        }
                        catch (RuntimeException e) {
                            if (!msg.isReply()) {
                                msg.revertDirection();
                                msg.setMessageObject(e);
                                CellNucleus.this.sendMessage(msg, true, true, true);
                            }
                            throw e;
                        }
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            }
        }

        public String toString() {
            return "Delivery-of-" + this._event;
        }
    }

    private class CallbackTask
    implements Runnable {
        private final CellLock _lock;
        private final CellMessage _message;

        public CallbackTask(CellLock lock, CellMessage message) {
            this._lock = lock;
            this._message = message;
        }

        @Override
        public void run() {
            CellNucleus.this._eventQueueSize.decrementAndGet();
            try (CDC ignored = this._lock.getCdc().restore();){
                try {
                    this._message.getDestinationPath().next();
                    CellMessageAnswerable callback = this._lock.getCallback();
                    CellMessage request = this._lock.getMessage();
                    try {
                        Serializable obj = this._message.getMessageObject();
                        if (obj instanceof Exception) {
                            callback.exceptionArrived(request, (Exception)obj);
                        } else {
                            callback.answerArrived(request, this._message);
                        }
                        EventLogger.sendEnd(request);
                    }
                    catch (RejectedExecutionException e) {
                        LOGGER.error("Failed to invoke callback: {}", (Object)e.toString());
                        CellNucleus.this.reregisterCallback(request.getUOID(), this._lock);
                    }
                    LOGGER.trace("addToEventQueue : callback done for : {}", (Object)this._message);
                }
                catch (Throwable e) {
                    Thread t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, e);
                }
            }
        }

        public String toString() {
            return "Delivery-of-" + this._message;
        }
    }

    private static enum State {
        NEW(0, false, false, true),
        PRE_STARTUP(1, true, false, true),
        POST_STARTUP(1, true, true, true),
        RUNNING(1, false, true, true),
        FAILED(2, false, true, true),
        STOPPING(2, false, true, false),
        TERMINATED(3, false, false, false);

        int externalState;
        boolean isStarting;
        boolean isSendWithCallbackAllowed;
        boolean areCallbacksGuaranteed;

        private State(int externalState, boolean isStarting, boolean isSendWithCallbackAllowed, boolean areCallbacksGuaranteed) {
            this.externalState = externalState;
            this.isStarting = isStarting;
            this.isSendWithCallbackAllowed = isSendWithCallbackAllowed;
            this.areCallbacksGuaranteed = areCallbacksGuaranteed;
        }
    }
}

