/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import dmg.cells.nucleus.CellAddressCore;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CellPath
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4922955783102747577L;
    private final List<CellAddressCore> _list;
    private int _position;

    private CellPath(int position, List<CellAddressCore> list) {
        Preconditions.checkArgument((position >= 0 && position <= list.size() ? 1 : 0) != 0);
        this._position = position;
        this._list = list;
    }

    protected CellPath() {
        this(0, new ArrayList<CellAddressCore>());
    }

    public CellPath(String path) {
        this(0, CellPath.streamOfPath(path).collect(Collectors.toList()));
    }

    public CellPath(CellAddressCore ... address) {
        this(0, Lists.newArrayList((Object[])address));
    }

    public CellPath(CellPath path, CellAddressCore ... addresses) {
        this(0, Stream.concat(path._list.stream(), Stream.of(addresses)).collect(Collectors.toList()));
    }

    public CellPath(String cellName, String domainName) {
        this(new CellAddressCore(cellName, domainName));
    }

    public synchronized int hops() {
        return this._list.size();
    }

    public synchronized void add(CellAddressCore core) {
        this._list.add(core);
    }

    public synchronized void add(CellPath addr) {
        this._list.addAll(addr._list);
    }

    public synchronized void add(String path) {
        CellPath.streamOfPath(path).forEachOrdered(this::add);
    }

    public synchronized CellPath clone() {
        return new CellPath(this._position, new ArrayList<CellAddressCore>(this._list));
    }

    public synchronized void insert(CellPath path) {
        this._list.addAll(this._position, path._list);
    }

    public synchronized void insert(CellAddressCore address) {
        this._list.add(this._position, address);
    }

    public synchronized boolean next() {
        int size = this._list.size();
        if (this._position < size) {
            ++this._position;
        }
        return this._position < size;
    }

    public synchronized CellPath revert() {
        CellPath path = new CellPath();
        Iterator iterator = Lists.reverse(this._list).iterator();
        if (iterator.hasNext()) {
            CellAddressCore address = (CellAddressCore)iterator.next();
            while (iterator.hasNext()) {
                CellAddressCore next = (CellAddressCore)iterator.next();
                if (!address.isDomainAddress() || next.isLocalAddress()) {
                    path.add(address);
                }
                address = next;
            }
            path.add(address);
        }
        return path;
    }

    public synchronized boolean isFinalDestination() {
        return this._position >= this._list.size();
    }

    public synchronized boolean isFirstDestination() {
        return this._position == 0;
    }

    public synchronized CellAddressCore getCurrent() {
        return this._position >= this._list.size() ? null : this._list.get(this._position);
    }

    public synchronized CellAddressCore getSourceAddress() {
        return this._list.get(0);
    }

    public synchronized CellAddressCore getDestinationAddress() {
        return this._list.get(this._list.size() - 1);
    }

    synchronized void replaceCurrent(CellAddressCore core) {
        if (this._position < this._list.size()) {
            this._list.set(this._position, core);
        }
    }

    public String getCellName() {
        CellAddressCore core = this.getCurrent();
        return core == null ? null : core.getCellName();
    }

    public String getCellDomainName() {
        CellAddressCore core = this.getCurrent();
        return core == null ? null : core.getCellDomainName();
    }

    public synchronized String toSmallString() {
        int size = this._list.size();
        if (size == 0) {
            return "[empty]";
        }
        if (this._position >= size || this._position < 0) {
            return "[INVALID]";
        }
        CellAddressCore core = this._list.get(this._position);
        if (size == 1) {
            return "[" + core.toString() + "]";
        }
        if (this._position == 0) {
            return "[" + core.toString() + ":...(" + (size - 1) + ")...]";
        }
        if (this._position == size - 1) {
            return "[...(" + (size - 1) + ")...:" + core + "]";
        }
        return "[...(" + this._position + ")...:" + core + "...(" + (size - this._position - 1) + ")...]";
    }

    public String toAddressString() {
        return this._list.stream().map(CellAddressCore::toString).collect(Collectors.joining(":"));
    }

    public List<CellAddressCore> getAddresses() {
        return Collections.unmodifiableList(this._list);
    }

    public String toString() {
        return this.toFullString();
    }

    public synchronized String toFullString() {
        CellAddressCore address;
        int i;
        int size = this._list.size();
        if (size == 0) {
            return "[empty]";
        }
        int position = this._position;
        if (position > size || position < 0) {
            return "[INVALID]";
        }
        StringBuilder sb = new StringBuilder(size * 16);
        sb.append('[');
        if (position < size) {
            for (i = 0; i < position; ++i) {
                address = this._list.get(i);
                sb.append(address.getCellName()).append('@').append(address.getCellDomainName());
                sb.append(':');
            }
            sb.append('>');
        }
        address = this._list.get(i);
        sb.append(address.getCellName()).append('@').append(address.getCellDomainName());
        ++i;
        while (i < size) {
            sb.append(':');
            address = this._list.get(i);
            sb.append(address.getCellName()).append('@').append(address.getCellDomainName());
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        ArrayList<CellAddressCore> other;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CellPath)) {
            return false;
        }
        Object object = obj;
        synchronized (object) {
            other = new ArrayList<CellAddressCore>(((CellPath)obj)._list);
        }
        object = this;
        synchronized (object) {
            return this._list.equals(other);
        }
    }

    public synchronized int hashCode() {
        return this._list.hashCode();
    }

    private static Stream<CellAddressCore> streamOfPath(String path) {
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0);
        return Stream.of(path.split(":")).map(CellAddressCore::new);
    }

    public boolean contains(CellAddressCore address) {
        return this._list.contains(address);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this._list.size());
        out.writeInt(this._position);
        for (CellAddressCore cellAddressCore : this._list) {
            out.writeUTF(cellAddressCore.getCellName());
            out.writeUTF(cellAddressCore.getCellDomainName());
        }
    }

    public static CellPath createFrom(DataInput in) throws IOException {
        int len = in.readInt();
        int position = in.readInt();
        ArrayList<CellAddressCore> list = new ArrayList<CellAddressCore>(len);
        for (int i = 0; i < len; ++i) {
            list.add(new CellAddressCore(in.readUTF(), in.readUTF().intern()));
        }
        return new CellPath(position, list);
    }
}

